/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.utilities.schema.converter.JsonToAvroSchemaConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TestJsonToAvroSchemaConverter {
    TestJsonToAvroSchemaConverter() {
    }

    @ParameterizedTest
    @ValueSource(strings={"enum-properties", "example-address", "example-calendar", "example-card", "example-geographical-location", "multiple-properties", "nested-properties", "single-properties"})
    void testConvertJsonSchemaToAvroSchema(String inputCase) throws IOException {
        String jsonSchema = this.loadJsonSchema(inputCase);
        String avroSchema = new JsonToAvroSchemaConverter().convert(jsonSchema);
        Schema schema = new Schema.Parser().parse(avroSchema);
        Schema expected = new Schema.Parser().parse(this.loadAvroSchema(inputCase));
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    private String loadJsonSchema(String inputCase) throws IOException {
        return FileIOUtils.readAsUTFString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format("schema-provider/json/%s/input.json", inputCase)));
    }

    private String loadAvroSchema(String inputCase) throws IOException {
        return FileIOUtils.readAsUTFString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format("schema-provider/json/%s/expected.json", inputCase)));
    }
}

