/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.AvroDFSSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.testutils.sources.AbstractDFSSourceTestBase;
import org.junit.jupiter.api.BeforeEach;

public class TestAvroDFSSource
extends AbstractDFSSourceTestBase {
    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.dfsRoot = basePath + "/avroFiles";
        this.fileSuffix = ".avro";
    }

    @Override
    protected Source prepareDFSSource(TypedProperties props) {
        props.setProperty("hoodie.streamer.source.dfs.root", this.dfsRoot);
        try {
            return new AvroDFSSource(props, jsc, sparkSession, (SchemaProvider)this.schemaProvider);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void writeNewDataToFile(List<HoodieRecord> records, Path path) throws IOException {
        UtilitiesTestBase.Helpers.saveAvroToDFS(UtilitiesTestBase.Helpers.toGenericRecords(records), path);
    }
}

