/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.ParquetDFSSource;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class TestParquetDFSSourceEmptyBatch
extends ParquetDFSSource {
    public static String RETURN_EMPTY_BATCH = "test.dfs.source.return.empty.batches.for";
    public static String DEFAULT_RETURN_EMPTY_BATCH = "";
    public List<Integer> emptyBatches;
    private int counter = 0;

    public TestParquetDFSSourceEmptyBatch(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        String[] emptyBatchesStr = props.getString(RETURN_EMPTY_BATCH, DEFAULT_RETURN_EMPTY_BATCH).split(",");
        this.emptyBatches = Arrays.stream(emptyBatchesStr).filter(entry -> !StringUtils.isNullOrEmpty((String)entry)).map(entry -> Integer.parseInt(entry)).collect(Collectors.toList());
    }

    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        Pair toReturn = super.fetchNextBatch(lastCkptStr, sourceLimit);
        if (this.emptyBatches.contains(this.counter++)) {
            return Pair.of((Object)Option.empty(), (Object)toReturn.getRight());
        }
        return toReturn;
    }
}

