/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.utilities.config.DFSPathSelectorConfig;
import org.apache.hudi.utilities.config.DatePartitionPathSelectorConfig;
import org.apache.hudi.utilities.sources.helpers.DatePartitionPathSelector;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestDatePartitionPathSelector
extends HoodieSparkClientTestHarness {
    private transient HoodieSparkEngineContext context = null;
    static List<LocalDate> totalDates;

    @BeforeAll
    public static void initClass() {
        String s = "2020-07-21";
        String e = "2020-07-25";
        LocalDate start = LocalDate.parse(s);
        LocalDate end = LocalDate.parse(e);
        totalDates = new ArrayList<LocalDate>();
        while (!start.isAfter(end)) {
            totalDates.add(start);
            start = start.plusDays(1L);
        }
    }

    @BeforeEach
    public void setup() {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.context = new HoodieSparkEngineContext(this.jsc);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.cleanupResources();
    }

    public List<StoragePath> createDatePartitionsWithFiles(List<StoragePath> leafDirs, boolean hiveStyle, String dateFormat) throws IOException {
        ArrayList<StoragePath> allFiles = new ArrayList<StoragePath>();
        for (StoragePath path : leafDirs) {
            List<StoragePath> datePartitions = this.generateDatePartitionsUnder(path, hiveStyle, dateFormat);
            for (StoragePath datePartition : datePartitions) {
                allFiles.addAll(this.createRandomFilesUnder(datePartition));
            }
        }
        return allFiles;
    }

    public void createParentDirsBeforeDatePartitions(StoragePath root, List<String> dirs, int depth, List<StoragePath> leafDirs) throws IOException {
        if (depth <= 0) {
            leafDirs.add(root);
            return;
        }
        for (String s : dirs) {
            StoragePath subdir = new StoragePath(root, s);
            this.storage.createDirectory(subdir);
            this.createParentDirsBeforeDatePartitions(subdir, this.generateRandomStrings(), depth - 1, leafDirs);
        }
    }

    private List<String> generateRandomStrings() {
        ArrayList<String> subDirs = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            subDirs.add(UUID.randomUUID().toString());
        }
        return subDirs;
    }

    private List<StoragePath> generateDatePartitionsUnder(StoragePath parent, boolean hiveStyle, String dateFormat) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        ArrayList<StoragePath> datePartitions = new ArrayList<StoragePath>();
        String prefix = hiveStyle ? "dt=" : "";
        for (int i = 0; i < 5; ++i) {
            StoragePath child = new StoragePath(parent, prefix + formatter.format(totalDates.get(i)));
            this.storage.createDirectory(child);
            datePartitions.add(child);
        }
        return datePartitions;
    }

    private List<StoragePath> createRandomFilesUnder(StoragePath path) throws IOException {
        ArrayList<StoragePath> resultFiles = new ArrayList<StoragePath>();
        List<String> fileNames = this.generateRandomStrings();
        for (String fileName : fileNames) {
            List<String> fileContent = this.generateRandomStrings();
            String[] lines = new String[fileContent.size()];
            lines = fileContent.toArray(lines);
            StoragePath file = new StoragePath(path, fileName);
            UtilitiesTestBase.Helpers.saveStringsToDFS(lines, this.storage, file.toString());
            resultFiles.add(file);
        }
        return resultFiles;
    }

    private static TypedProperties getProps(String basePath, String dateFormat, int datePartitionDepth, int numDaysToList, String currentDate) {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)DFSPathSelectorConfig.ROOT_INPUT_PATH.key(), (Object)basePath);
        properties.put((Object)DatePartitionPathSelectorConfig.DATE_FORMAT.key(), (Object)dateFormat);
        properties.put((Object)DatePartitionPathSelectorConfig.DATE_PARTITION_DEPTH.key(), (Object)("" + datePartitionDepth));
        properties.put((Object)DatePartitionPathSelectorConfig.LOOKBACK_DAYS.key(), (Object)("" + numDaysToList));
        properties.put((Object)DatePartitionPathSelectorConfig.CURRENT_DATE.key(), (Object)currentDate);
        return properties;
    }

    private static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{"table1", "yyyyMMdd", 0, 2, "2020-07-25", true, 1}, {"table2", "yyyyMMdd", 0, 2, "2020-07-25", false, 1}, {"table3", "yyyyMMMdd", 1, 3, "2020-07-25", true, 4}, {"table4", "yyyyMMMdd", 1, 3, "2020-07-25", false, 4}, {"table5", "yyyy-MM-dd", 2, 1, "2020-07-25", true, 10}, {"table6", "yyyy-MM-dd", 2, 1, "2020-07-25", false, 10}, {"table7", "yyyy-MMM-dd", 3, 2, "2020-07-25", true, 75}, {"table8", "yyyy-MMM-dd", 3, 2, "2020-07-25", false, 75}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"configParams"})
    public void testPruneDatePartitionPaths(String tableName, String dateFormat, int datePartitionDepth, int numPrevDaysToList, String currentDate, boolean isHiveStylePartition, int expectedNumFiles) throws IOException {
        TypedProperties props = TestDatePartitionPathSelector.getProps(this.basePath + "/" + tableName, dateFormat, datePartitionDepth, numPrevDaysToList, currentDate);
        DatePartitionPathSelector pathSelector = new DatePartitionPathSelector(props, this.jsc.hadoopConfiguration());
        StoragePath root = new StoragePath(ConfigUtils.getStringWithAltKeys((TypedProperties)props, (ConfigProperty)DFSPathSelectorConfig.ROOT_INPUT_PATH));
        int totalDepthBeforeDatePartitions = props.getInteger(DatePartitionPathSelectorConfig.DATE_PARTITION_DEPTH.key()) - 1;
        ArrayList<StoragePath> leafDirs = new ArrayList<StoragePath>();
        this.createParentDirsBeforeDatePartitions(root, this.generateRandomStrings(), totalDepthBeforeDatePartitions, leafDirs);
        this.createDatePartitionsWithFiles(leafDirs, isHiveStylePartition, dateFormat);
        List paths = pathSelector.pruneDatePartitionPaths(this.context, (FileSystem)this.storage.getFileSystem(), root.toString(), LocalDate.parse(currentDate));
        Assertions.assertEquals((int)expectedNumFiles, (int)paths.size());
    }
}

