/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.sources.TestS3EventsHoodieIncrSource;
import org.apache.hudi.utilities.sources.helpers.CloudObjectIncrCheckpoint;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestIncrSourceHelper
extends SparkClientFunctionalTestHarness {
    private ObjectMapper mapper = new ObjectMapper();
    private JavaSparkContext jsc;
    private HoodieTableMetaClient metaClient;
    private static final Schema S3_METADATA_SCHEMA = SchemaTestUtil.getSchemaFromResource(TestS3EventsHoodieIncrSource.class, (String)"/streamer-config/s3-metadata.avsc", (boolean)true);

    TestIncrSourceHelper() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.jsc = JavaSparkContext.fromSparkContext((SparkContext)this.spark().sparkContext());
        this.metaClient = this.getHoodieMetaClient(this.storageConf(), this.basePath());
    }

    private String generateS3EventMetadata(Long objectSize, String bucketName, String objectKey, String commitTime) throws JsonProcessingException {
        HashMap<String, Object> objectMetadata = new HashMap<String, Object>();
        objectMetadata.put("size", objectSize);
        objectMetadata.put("key", objectKey);
        HashMap<String, String> bucketMetadata = new HashMap<String, String>();
        bucketMetadata.put("name", bucketName);
        HashMap<String, HashMap<String, Object>> s3Metadata = new HashMap<String, HashMap<String, Object>>();
        s3Metadata.put("object", objectMetadata);
        s3Metadata.put("bucket", bucketMetadata);
        HashMap<String, Object> eventMetadata = new HashMap<String, Object>();
        eventMetadata.put("s3", s3Metadata);
        eventMetadata.put("_hoodie_commit_time", commitTime);
        return this.mapper.writeValueAsString(eventMetadata);
    }

    private List<String> getSampleS3ObjectKeys(List<Triple<String, Long, String>> filePathSizeAndCommitTime) {
        return filePathSizeAndCommitTime.stream().map(f -> {
            try {
                return this.generateS3EventMetadata((Long)f.getMiddle(), "bucket-1", (String)f.getLeft(), (String)f.getRight());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private Dataset<Row> generateDataset(List<Triple<String, Long, String>> filePathSizeAndCommitTime) {
        JavaRDD testRdd = this.jsc.parallelize(this.getSampleS3ObjectKeys(filePathSizeAndCommitTime), 2);
        Dataset inputDs = this.spark().read().json(testRdd);
        return inputDs;
    }

    @Test
    void testEmptySource() {
        StructType schema = new StructType();
        Dataset emptyDataset = this.spark().createDataFrame(new ArrayList(), schema);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit2", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit((Dataset)emptyDataset, (long)50L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint(null, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit2", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        org.junit.jupiter.api.Assertions.assertTrue((!((Option)result.getRight()).isPresent() ? 1 : 0) != 0);
    }

    @Test
    void testSingleObjectExceedingSourceLimit() {
        ArrayList<Triple<String, Long, String>> filePathSizeAndCommitTime = new ArrayList<Triple<String, Long, String>>();
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file1.json", (Object)100L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file3.json", (Object)200L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file2.json", (Object)150L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file4.json", (Object)50L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file5.json", (Object)150L, (Object)"commit2"));
        Dataset<Row> inputDs = this.generateDataset(filePathSizeAndCommitTime);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit2", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)50L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit1", null));
        Row row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit1#path/to/file1.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        List rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[[commit1,[[bucket-1],[path/to/file1.json,100]],100]]", (Object)rows.toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)100L, (Object)row.get(0));
    }

    @Test
    void testMultipleObjectExceedingSourceLimit() {
        ArrayList<Triple<String, Long, String>> filePathSizeAndCommitTime = new ArrayList<Triple<String, Long, String>>();
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file1.json", (Object)100L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file3.json", (Object)200L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file2.json", (Object)150L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file4.json", (Object)50L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file5.json", (Object)150L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file7.json", (Object)100L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file7.json", (Object)250L, (Object)"commit3"));
        Dataset<Row> inputDs = this.generateDataset(filePathSizeAndCommitTime);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit2", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)350L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit1", null));
        Row row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit1#path/to/file2.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        List rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[[commit1,[[bucket-1],[path/to/file1.json,100]],100], [commit1,[[bucket-1],[path/to/file2.json,150]],250]]", (Object)rows.toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)250L, (Object)row.get(0));
        result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)550L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit1", null));
        row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit2#path/to/file4.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"[[commit1,[[bucket-1],[path/to/file1.json,100]],100], [commit1,[[bucket-1],[path/to/file2.json,150]],250], [commit1,[[bucket-1],[path/to/file3.json,200]],450], [commit2,[[bucket-1],[path/to/file4.json,50]],500]]", (Object)rows.toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)500L, (Object)row.get(0));
    }

    @Test
    void testCatchAllObjects() {
        ArrayList<Triple<String, Long, String>> filePathSizeAndCommitTime = new ArrayList<Triple<String, Long, String>>();
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file1.json", (Object)100L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file3.json", (Object)200L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file2.json", (Object)150L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file4.json", (Object)50L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file5.json", (Object)150L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file8.json", (Object)100L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file6.json", (Object)250L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file7.json", (Object)50L, (Object)"commit3"));
        Dataset<Row> inputDs = this.generateDataset(filePathSizeAndCommitTime);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit2", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)1500L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit1", null));
        Row row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit3#path/to/file8.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        List rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)1050L, (Object)row.get(0));
    }

    @Test
    void testFileOrderingAcrossCommits() {
        ArrayList<Triple<String, Long, String>> filePathSizeAndCommitTime = new ArrayList<Triple<String, Long, String>>();
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file8.json", (Object)100L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file6.json", (Object)250L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file7.json", (Object)50L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file0.json", (Object)100L, (Object)"commit4"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file1.json", (Object)50L, (Object)"commit4"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file2.json", (Object)50L, (Object)"commit4"));
        Dataset<Row> inputDs = this.generateDataset(filePathSizeAndCommitTime);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit3", "commit3", "commit4", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)50L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit3", "path/to/file8.json"));
        Row row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit4#path/to/file0.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        List rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)100L, (Object)row.get(0));
        result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)350L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit3", "path/to/file8.json"));
        row = (Row)((Dataset)((Option)result.getRight()).get()).select("cumulativeSize", new String[0]).collectAsList().get((int)((Dataset)((Option)result.getRight()).get()).count() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit4#path/to/file2.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        rows = ((Dataset)((Option)result.getRight()).get()).collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)rows.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)200L, (Object)row.get(0));
    }

    @Test
    void testLastObjectInCommit() {
        ArrayList<Triple<String, Long, String>> filePathSizeAndCommitTime = new ArrayList<Triple<String, Long, String>>();
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file1.json", (Object)100L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file3.json", (Object)200L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file2.json", (Object)150L, (Object)"commit1"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file4.json", (Object)50L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file5.json", (Object)150L, (Object)"commit2"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file8.json", (Object)100L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file6.json", (Object)250L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file7.json", (Object)50L, (Object)"commit3"));
        filePathSizeAndCommitTime.add(Triple.of((Object)"path/to/file8.json", (Object)50L, (Object)"commit3"));
        Dataset<Row> inputDs = this.generateDataset(filePathSizeAndCommitTime);
        QueryInfo queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit3", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        Pair result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)1500L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit3", "path/to/file8.json"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit3#path/to/file8.json", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        org.junit.jupiter.api.Assertions.assertTrue((!((Option)result.getRight()).isPresent() ? 1 : 0) != 0);
        queryInfo = new QueryInfo(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL(), "commit1", "commit1", "commit4", "_hoodie_commit_time", "s3.object.key", "s3.object.size");
        result = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(inputDs, (long)1500L, (QueryInfo)queryInfo, (CloudObjectIncrCheckpoint)new CloudObjectIncrCheckpoint("commit3", "path/to/file8.json"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit4", (Object)((CloudObjectIncrCheckpoint)result.getKey()).toString());
        org.junit.jupiter.api.Assertions.assertTrue((!((Option)result.getRight()).isPresent() ? 1 : 0) != 0);
    }

    private HoodieRecord generateS3EventMetadata(String commitTime, String bucketName, String objectKey, Long objectSize) {
        String partitionPath = bucketName;
        Schema schema = S3_METADATA_SCHEMA;
        GenericData.Record rec = new GenericData.Record(schema);
        Schema.Field s3Field = schema.getField("s3");
        Schema s3Schema = (Schema)s3Field.schema().getTypes().get(1);
        GenericData.Record s3Record = new GenericData.Record(s3Schema);
        Schema.Field s3BucketField = s3Schema.getField("bucket");
        Schema s3Bucket = (Schema)s3BucketField.schema().getTypes().get(1);
        GenericData.Record s3BucketRec = new GenericData.Record(s3Bucket);
        s3BucketRec.put("name", (Object)bucketName);
        Schema.Field s3ObjectField = s3Schema.getField("object");
        Schema s3Object = (Schema)s3ObjectField.schema().getTypes().get(1);
        GenericData.Record s3ObjectRec = new GenericData.Record(s3Object);
        s3ObjectRec.put("key", (Object)objectKey);
        s3ObjectRec.put("size", (Object)objectSize);
        s3Record.put("bucket", (Object)s3BucketRec);
        s3Record.put("object", (Object)s3ObjectRec);
        rec.put("s3", (Object)s3Record);
        rec.put("_hoodie_commit_time", (Object)commitTime);
        HoodieAvroPayload payload = new HoodieAvroPayload(Option.of((Object)rec));
        return new HoodieAvroRecord(new HoodieKey(objectKey, partitionPath), (HoodieRecordPayload)payload);
    }

    private HoodieWriteConfig.Builder getConfigBuilder(String basePath, HoodieTableMetaClient metaClient) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema(S3_METADATA_SCHEMA.toString()).withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).forTable(metaClient.getTableConfig().getTableName());
    }

    private HoodieWriteConfig getWriteConfig() {
        return this.getConfigBuilder(this.basePath(), this.metaClient).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).build();
    }

    private Pair<String, List<HoodieRecord>> writeS3MetadataRecords(String commitTime) throws IOException {
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(writeConfig);){
            writeClient.startCommitWithTime(commitTime);
            List<HoodieRecord> s3MetadataRecords = Arrays.asList(this.generateS3EventMetadata(commitTime, "bucket-1", "data-file-1.json", 1L));
            JavaRDD result = writeClient.upsert(this.jsc().parallelize(s3MetadataRecords, 1), commitTime);
            List statuses = result.collect();
            Assertions.assertNoWriteErrors((List)statuses);
            Pair pair = Pair.of((Object)commitTime, s3MetadataRecords);
            return pair;
        }
    }

    @Test
    void testQueryInfoGeneration() throws IOException {
        String commitTimeForReads = "1";
        String commitTimeForWrites = "2";
        Pair<String, List<HoodieRecord>> inserts = this.writeS3MetadataRecords(commitTimeForReads);
        inserts = this.writeS3MetadataRecords(commitTimeForWrites);
        String startInstant = commitTimeForReads;
        String orderColumn = "_hoodie_commit_time";
        String keyColumn = "s3.object.key";
        String limitColumn = "s3.object.size";
        QueryInfo queryInfo = IncrSourceHelper.generateQueryInfo((JavaSparkContext)this.jsc, (String)this.basePath(), (int)5, (Option)Option.of((Object)startInstant), null, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.BLOCK, (String)orderColumn, (String)keyColumn, (String)limitColumn, (boolean)true, (Option)Option.empty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)String.valueOf(Integer.parseInt(commitTimeForReads) - 1), (Object)queryInfo.getPreviousInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)commitTimeForReads, (Object)queryInfo.getStartInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)commitTimeForWrites, (Object)queryInfo.getEndInstant());
        startInstant = commitTimeForWrites;
        queryInfo = IncrSourceHelper.generateQueryInfo((JavaSparkContext)this.jsc, (String)this.basePath(), (int)5, (Option)Option.of((Object)startInstant), null, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.BLOCK, (String)orderColumn, (String)keyColumn, (String)limitColumn, (boolean)true, (Option)Option.empty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)commitTimeForReads, (Object)queryInfo.getPreviousInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)commitTimeForWrites, (Object)queryInfo.getStartInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)commitTimeForWrites, (Object)queryInfo.getEndInstant());
    }
}

