/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.utilities.sources.helpers.SanitizationUtils;
import org.apache.hudi.utilities.testutils.SanitizationTestUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSanitizationUtils {
    protected static SparkSession spark;
    protected static JavaSparkContext jsc;

    @BeforeAll
    public static void start() {
        spark = SparkSession.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)TestSanitizationUtils.class.getName())).getOrCreate();
        jsc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    @AfterAll
    public static void shutdown() {
        jsc.close();
        spark.close();
    }

    @ParameterizedTest
    @MethodSource(value={"provideDataFiles"})
    public void testSanitizeDataset(String unsanitizedDataFile, String sanitizedDataFile, StructType unsanitizedSchema, StructType sanitizedSchema) {
        Dataset expectedSanitizedDataset = spark.read().schema(sanitizedSchema).format("json").load(sanitizedDataFile);
        Dataset unsanitizedDataset = spark.read().schema(unsanitizedSchema).format("json").load(unsanitizedDataFile);
        Dataset sanitizedDataset = SanitizationUtils.sanitizeColumnNamesForAvro((Dataset)unsanitizedDataset, (String)SanitizationTestUtils.invalidCharMask);
        Assertions.assertEquals((long)unsanitizedDataset.count(), (long)sanitizedDataset.count());
        Assertions.assertEquals((Object)expectedSanitizedDataset.schema(), (Object)sanitizedDataset.schema());
        Assertions.assertEquals((Object)expectedSanitizedDataset.collectAsList(), (Object)sanitizedDataset.collectAsList());
    }

    private void testSanitizeSchema(String unsanitizedSchema, Schema expectedSanitizedSchema) {
        this.testSanitizeSchema(unsanitizedSchema, expectedSanitizedSchema, true);
    }

    private void testSanitizeSchema(String unsanitizedSchema, Schema expectedSanitizedSchema, boolean shouldSanitize) {
        this.testSanitizeSchema(unsanitizedSchema, expectedSanitizedSchema, shouldSanitize, SanitizationTestUtils.invalidCharMask);
    }

    private void testSanitizeSchema(String unsanitizedSchema, Schema expectedSanitizedSchema, boolean shouldSanitize, String charMask) {
        Schema sanitizedSchema = SanitizationUtils.parseAvroSchema((String)unsanitizedSchema, (boolean)shouldSanitize, (String)charMask);
        Assertions.assertEquals((Object)sanitizedSchema, (Object)expectedSanitizedSchema);
    }

    @Test
    public void testGoodAvroSchema() {
        String goodJson = this.getJson("src/test/resources/streamer-config/file_schema_provider_valid.avsc");
        this.testSanitizeSchema(goodJson, SanitizationTestUtils.generateProperFormattedSchema());
    }

    @Test
    public void testBadAvroSchema() {
        String badJson = this.getJson("src/test/resources/streamer-config/file_schema_provider_invalid.avsc");
        this.testSanitizeSchema(badJson, SanitizationTestUtils.generateRenamedSchemaWithDefaultReplacement());
    }

    @Test
    public void testBadAvroSchemaAltCharMask() {
        String badJson = this.getJson("src/test/resources/streamer-config/file_schema_provider_invalid.avsc");
        this.testSanitizeSchema(badJson, SanitizationTestUtils.generateRenamedSchemaWithConfiguredReplacement(), true, "_");
    }

    @Test
    public void testBadAvroSchemaDisabledTest() {
        String badJson = this.getJson("src/test/resources/streamer-config/file_schema_provider_invalid.avsc");
        Assertions.assertThrows(SchemaParseException.class, () -> this.testSanitizeSchema(badJson, SanitizationTestUtils.generateRenamedSchemaWithDefaultReplacement(), false));
    }

    @Test
    private String getJson(String path) {
        String schemaStr;
        FileSystem fs = HadoopFSUtils.getFs((String)path, (Configuration)jsc.hadoopConfiguration(), (boolean)true);
        try (FSDataInputStream in = fs.open(new Path(path));){
            schemaStr = FileIOUtils.readAsUTFString((InputStream)in);
        }
        catch (IOException e) {
            throw new HoodieIOException("can't read schema file", e);
        }
        return schemaStr;
    }

    private static Stream<Arguments> provideDataFiles() {
        return SanitizationTestUtils.provideDataFiles();
    }
}

