/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.testutils.minicluster.ZookeeperTestService;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TestAvroOrcUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.ddl.JDBCExecutor;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.sources.TestDataSource;
import org.apache.log4j.Level;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class UtilitiesTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(UtilitiesTestBase.class);
    @TempDir
    protected static java.nio.file.Path sharedTempDir;
    protected static FileSystem fs;
    protected static HoodieStorage storage;
    protected static String basePath;
    protected static HdfsTestService hdfsTestService;
    protected static MiniDFSCluster dfsCluster;
    protected static HiveServer2 hiveServer;
    protected static HiveTestService hiveTestService;
    protected static ZookeeperTestService zookeeperTestService;
    private static final ObjectMapper MAPPER;
    protected static JavaSparkContext jsc;
    protected static HoodieSparkEngineContext context;
    protected static SparkSession sparkSession;
    protected static SQLContext sqlContext;
    protected static Configuration hadoopConf;

    @BeforeAll
    public static void setLogLevel() {
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        rootLogger.setLevel(Level.ERROR);
        org.apache.log4j.Logger.getLogger((String)"org.apache.spark").setLevel(Level.WARN);
    }

    public static void initTestServices() throws Exception {
        UtilitiesTestBase.initTestServices(false, false, false);
    }

    public static void initTestServices(boolean needsHdfs, boolean needsHive, boolean needsZookeeper) throws Exception {
        hadoopConf = (Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap();
        if (needsHdfs) {
            hdfsTestService = new HdfsTestService(hadoopConf);
            dfsCluster = hdfsTestService.start(true);
            fs = dfsCluster.getFileSystem();
            basePath = fs.getWorkingDirectory().toString();
            fs.mkdirs(new Path(basePath));
        } else {
            fs = FileSystem.getLocal((Configuration)hadoopConf);
            basePath = sharedTempDir.toUri().toString();
        }
        storage = new HoodieHadoopStorage(fs);
        hadoopConf.set("hive.exec.scratchdir", basePath + "/.tmp/hive");
        if (needsHive) {
            hiveTestService = new HiveTestService(hadoopConf);
            hiveServer = hiveTestService.start();
            UtilitiesTestBase.clearHiveDb(basePath + "/dummy" + System.currentTimeMillis());
        }
        if (needsZookeeper) {
            zookeeperTestService = new ZookeeperTestService(hadoopConf);
            zookeeperTestService.start();
        }
        jsc = UtilHelpers.buildSparkContext((String)(UtilitiesTestBase.class.getName() + "-hoodie"), (String)"local[4]", UtilitiesTestBase.sparkConf());
        context = new HoodieSparkEngineContext(jsc);
        sqlContext = new SQLContext(jsc);
        sparkSession = SparkSession.builder().config(jsc.getConf()).getOrCreate();
    }

    @AfterAll
    public static void cleanUpUtilitiesTestServices() {
        ArrayList<String> failedReleases = new ArrayList<String>();
        try {
            if (fs != null) {
                fs.delete(new Path(basePath), true);
                fs.close();
                fs = null;
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
            failedReleases.add("FileSystem");
        }
        try {
            if (hdfsTestService != null) {
                hdfsTestService.stop();
                hdfsTestService = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("HdfsTestService");
        }
        try {
            if (hiveServer != null) {
                hiveServer.stop();
                hiveServer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("HiveServer");
        }
        try {
            if (hiveTestService != null) {
                hiveTestService.stop();
                hiveTestService = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("HiveTestService");
        }
        try {
            if (zookeeperTestService != null) {
                zookeeperTestService.stop();
                zookeeperTestService = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("ZooKeeperTestService");
        }
        try {
            if (jsc != null) {
                jsc.stop();
                jsc = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("JSC");
        }
        try {
            if (sparkSession != null) {
                sparkSession.close();
                sparkSession = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failedReleases.add("SparkSession");
        }
        if (context != null) {
            context = null;
        }
        if (!failedReleases.isEmpty()) {
            LOG.error("Exception happened during releasing: " + String.join((CharSequence)",", failedReleases));
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        TestDataSource.initDataGen();
        if (fs != null) {
            fs.delete(new Path(basePath), true);
        }
    }

    @AfterEach
    public void teardown() throws Exception {
        TestDataSource.resetDataGen();
    }

    private static Map<String, String> sparkConf() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("spark.default.parallelism", "2");
        conf.put("spark.sql.shuffle.partitions", "2");
        conf.put("spark.executor.memory", "1G");
        conf.put("spark.driver.memory", "1G");
        conf.put("spark.hadoop.mapred.output.compress", "true");
        conf.put("spark.ui.enable", "false");
        return conf;
    }

    protected static HiveSyncConfig getHiveSyncConfig(String basePath, String tableName) {
        Properties props = new Properties();
        props.setProperty(HiveSyncConfigHolder.HIVE_URL.key(), hiveTestService.getJdbcHive2Url());
        props.setProperty(HiveSyncConfigHolder.HIVE_USER.key(), "");
        props.setProperty(HiveSyncConfigHolder.HIVE_PASS.key(), "");
        props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "testdb1");
        props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), tableName);
        props.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), basePath);
        props.setProperty(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION.key(), "false");
        props.setProperty(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), "false");
        props.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        return new HiveSyncConfig(props);
    }

    private static void clearHiveDb(String tempWriteablePath) throws Exception {
        HiveSyncConfig hiveSyncConfig = UtilitiesTestBase.getHiveSyncConfig(tempWriteablePath, "dummy");
        hiveSyncConfig.setHadoopConf((Configuration)hiveTestService.getHiveConf());
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME)).initTable(storage.getConf().newInstance(), hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
        JDBCExecutor ddlExecutor = new JDBCExecutor(hiveSyncConfig);
        ddlExecutor.runSQL("drop database if exists " + hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME));
        ddlExecutor.runSQL("create database " + hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME));
        ddlExecutor.close();
    }

    static {
        MAPPER = new ObjectMapper();
    }

    public static class Helpers {
        private static ClassLoader classLoader = Helpers.class.getClassLoader();

        public static String readFile(String testResourcePath) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(testResourcePath)));
            StringBuffer sb = new StringBuffer();
            reader.lines().forEach(line -> sb.append((String)line).append("\n"));
            return sb.toString();
        }

        public static String readFileFromAbsolutePath(String absolutePathForResource) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(absolutePathForResource)));
            StringBuffer sb = new StringBuffer();
            reader.lines().forEach(line -> sb.append((String)line).append("\n"));
            return sb.toString();
        }

        public static void copyToDFS(String testResourcePath, HoodieStorage storage, String targetPath) throws IOException {
            PrintStream os = new PrintStream(storage.create(new StoragePath(targetPath), true));
            os.print(Helpers.readFile(testResourcePath));
            os.flush();
            os.close();
        }

        public static void copyToDFSFromAbsolutePath(String absolutePathForResource, FileSystem fs, String targetPath) throws IOException {
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            os.print(Helpers.readFileFromAbsolutePath(absolutePathForResource));
            os.flush();
            os.close();
        }

        public static void deleteFileFromDfs(FileSystem fs, String targetPath) throws IOException {
            if (fs.exists(new Path(targetPath))) {
                fs.delete(new Path(targetPath), true);
            }
        }

        public static void savePropsToDFS(TypedProperties props, HoodieStorage storage, String targetPath) throws IOException {
            String[] lines = (String[])props.keySet().stream().map(k -> String.format("%s=%s", k, props.get(k))).toArray(String[]::new);
            Helpers.saveStringsToDFS(lines, storage, targetPath);
        }

        public static void saveStringsToDFS(String[] lines, HoodieStorage storage, String targetPath) throws IOException {
            PrintStream os = new PrintStream(storage.create(new StoragePath(targetPath), true));
            for (String l : lines) {
                os.println(l);
            }
            os.flush();
            os.close();
        }

        public static void saveCsvToDFS(boolean hasHeader, char sep, String[] lines, FileSystem fs, String targetPath) throws IOException {
            CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder();
            ArrayNode arrayNode = MAPPER.createArrayNode();
            Arrays.stream(lines).forEachOrdered(line -> {
                try {
                    arrayNode.add((JsonNode)MAPPER.readValue(line, ObjectNode.class));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error converting json records into CSV format: " + e.getMessage());
                }
            });
            arrayNode.get(0).fieldNames().forEachRemaining(arg_0 -> ((CsvSchema.Builder)csvSchemaBuilder).addColumn(arg_0));
            ObjectWriter csvObjWriter = new CsvMapper().writerFor(JsonNode.class).with((FormatSchema)csvSchemaBuilder.setUseHeader(hasHeader).setColumnSeparator(sep).build());
            PrintStream os = new PrintStream((OutputStream)fs.create(new Path(targetPath), true));
            csvObjWriter.writeValue((OutputStream)os, (Object)arrayNode);
            os.flush();
            os.close();
        }

        public static void saveParquetToDFS(List<GenericRecord> records, Path targetFile) throws IOException {
            Helpers.saveParquetToDFS(records, targetFile, HoodieTestDataGenerator.AVRO_SCHEMA);
        }

        public static void saveParquetToDFS(List<GenericRecord> records, Path targetFile, Schema schema) throws IOException {
            try (ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)targetFile).withSchema(schema).withConf((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();){
                for (GenericRecord record : records) {
                    writer.write((Object)record);
                }
            }
        }

        public static void saveORCToDFS(List<GenericRecord> records, Path targetFile) throws IOException {
            Helpers.saveORCToDFS(records, targetFile, TestAvroOrcUtils.ORC_SCHEMA);
        }

        public static void saveORCToDFS(List<GenericRecord> records, Path targetFile, TypeDescription schema) throws IOException {
            OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap())).setSchema(schema);
            try (Writer writer = OrcFile.createWriter((Path)targetFile, (OrcFile.WriterOptions)options);){
                VectorizedRowBatch batch = schema.createRowBatch();
                for (GenericRecord record : records) {
                    Helpers.addAvroRecord(batch, record, schema);
                    ++batch.size;
                    if (batch.size % records.size() != 0 && batch.size != batch.getMaxSize()) continue;
                    writer.addRowBatch(batch);
                    batch.reset();
                    batch.size = 0;
                }
                writer.addRowBatch(batch);
            }
        }

        public static void saveAvroToDFS(List<GenericRecord> records, Path targetFile) throws IOException {
            Helpers.saveAvroToDFS(records, targetFile, HoodieTestDataGenerator.AVRO_SCHEMA);
        }

        public static void saveAvroToDFS(List<GenericRecord> records, Path targetFile, Schema schema) throws IOException {
            FileSystem fs = targetFile.getFileSystem((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap());
            FSDataOutputStream output = fs.create(targetFile);
            try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema)).create(schema, (OutputStream)output);){
                for (GenericRecord record : records) {
                    dataFileWriter.append((Object)record);
                }
            }
        }

        public static TypedProperties setupSchemaOnDFS() throws IOException {
            return Helpers.setupSchemaOnDFS("streamer-config", "source.avsc");
        }

        public static TypedProperties setupSchemaOnDFS(String scope, String filename) throws IOException {
            Helpers.copyToDFS(scope + "/" + filename, storage, basePath + "/" + filename);
            TypedProperties props = new TypedProperties();
            props.setProperty("hoodie.streamer.schemaprovider.source.schema.file", basePath + "/" + filename);
            return props;
        }

        public static TypedProperties setupSchemaOnDFSWithAbsoluteScope(String scope, String filename) throws IOException {
            Helpers.copyToDFSFromAbsolutePath(scope + "/" + filename, fs, basePath + "/" + filename);
            TypedProperties props = new TypedProperties();
            props.setProperty("hoodie.streamer.schemaprovider.source.schema.file", basePath + "/" + filename);
            return props;
        }

        public static GenericRecord toGenericRecord(HoodieRecord hoodieRecord, Schema schema) {
            try {
                Option recordOpt = ((HoodieAvroRecord)hoodieRecord).getData().getInsertValue(schema);
                return (GenericRecord)recordOpt.get();
            }
            catch (IOException e) {
                return null;
            }
        }

        public static List<GenericRecord> toGenericRecords(List<HoodieRecord> hoodieRecords) {
            return Helpers.toGenericRecords(hoodieRecords, HoodieTestDataGenerator.AVRO_SCHEMA);
        }

        public static List<GenericRecord> toGenericRecords(List<HoodieRecord> hoodieRecords, Schema schema) {
            ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
            for (HoodieRecord hoodieRecord : hoodieRecords) {
                records.add(Helpers.toGenericRecord(hoodieRecord, schema));
            }
            return records;
        }

        public static String toJsonString(HoodieRecord hr) {
            try {
                return ((RawTripTestPayload)hr.getData()).getJsonData();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        public static String[] jsonifyRecords(List<HoodieRecord> records) {
            return (String[])records.stream().map(Helpers::toJsonString).toArray(String[]::new);
        }

        public static Tuple2<String, String>[] jsonifyRecordsByPartitions(List<HoodieRecord> records, int partitions) {
            Tuple2[] data = new Tuple2[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                int key = i % partitions;
                String value = Helpers.toJsonString(records.get(i));
                data[i] = new Tuple2((Object)Long.toString(key), (Object)value);
            }
            return data;
        }

        public static Tuple2<String, String>[] jsonifyRecordsByPartitionsWithNullKafkaKey(List<HoodieRecord> records, int partitions) {
            Tuple2[] data = new Tuple2[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                String value = Helpers.toJsonString(records.get(i));
                data[i] = new Tuple2(null, (Object)value);
            }
            return data;
        }

        private static void addAvroRecord(VectorizedRowBatch batch, GenericRecord record, TypeDescription orcSchema) {
            for (int c = 0; c < batch.numCols; ++c) {
                ColumnVector colVector = batch.cols[c];
                String thisField = (String)orcSchema.getFieldNames().get(c);
                TypeDescription type = (TypeDescription)orcSchema.getChildren().get(c);
                Object fieldValue = record.get(thisField);
                Schema.Field avroField = record.getSchema().getField(thisField);
                AvroOrcUtils.addToVector((TypeDescription)type, (ColumnVector)colVector, (Schema)avroField.schema(), (Object)fieldValue, (int)batch.size);
            }
        }
    }
}

