/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils.sources;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.testutils.CloudObjectTestUtils;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import software.amazon.awssdk.services.sqs.SqsClient;

public abstract class AbstractCloudObjectsSourceTestBase
extends UtilitiesTestBase {
    protected FilebasedSchemaProvider schemaProvider;
    protected String dfsRoot;
    protected String fileSuffix;
    protected HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
    protected boolean useFlattenedSchema = false;
    protected String sqsUrl = "test-queue";
    protected String regionName = "us-east-1";
    @Mock
    protected SqsClient sqs;

    @BeforeAll
    public static void initClass() throws Exception {
        UtilitiesTestBase.initTestServices();
    }

    @AfterAll
    public static void cleanupClass() throws IOException {
        UtilitiesTestBase.cleanUpUtilitiesTestServices();
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.schemaProvider = new FilebasedSchemaProvider(UtilitiesTestBase.Helpers.setupSchemaOnDFS(), jsc);
        MockitoAnnotations.initMocks((Object)this);
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        super.teardown();
    }

    protected abstract Source prepareCloudObjectSource();

    protected abstract void writeNewDataToFile(List<HoodieRecord> var1, Path var2) throws IOException;

    protected Path generateOneFile(String filename, String instantTime, int n) throws IOException {
        Path path = new Path(this.dfsRoot, filename + this.fileSuffix);
        this.writeNewDataToFile(this.dataGenerator.generateInserts(instantTime, Integer.valueOf(n), this.useFlattenedSchema), path);
        return path;
    }

    public void generateMessageInQueue(String filename) {
        Path path = null;
        if (filename != null) {
            path = new Path(this.dfsRoot, filename + this.fileSuffix);
        }
        CloudObjectTestUtils.setMessagesInQueue(this.sqs, path);
    }
}

