/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.exception.HoodieTransformException;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.transform.SqlFileBasedTransformer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSqlFileBasedTransformer
extends UtilitiesTestBase {
    private TypedProperties props;
    private SqlFileBasedTransformer sqlFileTransformer;
    private Dataset<Row> inputDatasetRows;
    private Dataset<Row> emptyDatasetRow;

    @BeforeAll
    public static void initClass() throws Exception {
        UtilitiesTestBase.initTestServices();
    }

    @AfterAll
    public static void cleanupClass() throws IOException {
        UtilitiesTestBase.cleanUpUtilitiesTestServices();
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.props = new TypedProperties();
        this.sqlFileTransformer = new SqlFileBasedTransformer();
        this.inputDatasetRows = this.getInputDatasetRows();
        this.emptyDatasetRow = this.getEmptyDatasetRow();
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        super.teardown();
    }

    @Test
    public void testSqlFileBasedTransformerIllegalArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.sqlFileTransformer.apply(jsc, sparkSession, this.inputDatasetRows, this.props));
    }

    @Test
    public void testSqlFileBasedTransformerIncorrectConfig() {
        this.props.setProperty("hoodie.streamer.transformer.sql.file", UtilitiesTestBase.basePath + "/non-exist-sql-file.sql");
        Assertions.assertThrows(HoodieTransformException.class, () -> this.sqlFileTransformer.apply(jsc, sparkSession, this.inputDatasetRows, this.props));
    }

    @Test
    public void testSqlFileBasedTransformerInvalidSQL() throws IOException {
        UtilitiesTestBase.Helpers.copyToDFS("streamer-config/sql-file-transformer-invalid.sql", UtilitiesTestBase.storage, UtilitiesTestBase.basePath + "/sql-file-transformer-invalid.sql");
        this.props.setProperty("hoodie.streamer.transformer.sql.file", UtilitiesTestBase.basePath + "/sql-file-transformer-invalid.sql");
        Assertions.assertThrows(ParseException.class, () -> this.sqlFileTransformer.apply(jsc, sparkSession, this.inputDatasetRows, this.props));
    }

    @Test
    public void testSqlFileBasedTransformerEmptyDataset() throws IOException {
        UtilitiesTestBase.Helpers.copyToDFS("streamer-config/sql-file-transformer-empty.sql", UtilitiesTestBase.storage, UtilitiesTestBase.basePath + "/sql-file-transformer-empty.sql");
        this.props.setProperty("hoodie.streamer.transformer.sql.file", UtilitiesTestBase.basePath + "/sql-file-transformer-empty.sql");
        Dataset emptyRow = this.sqlFileTransformer.apply(jsc, sparkSession, this.inputDatasetRows, this.props);
        Object[] actualRows = emptyRow.as(Encoders.STRING()).collectAsList().toArray(new String[0]);
        Object[] expectedRows = this.emptyDatasetRow.collectAsList().toArray(new String[0]);
        Assertions.assertArrayEquals((Object[])expectedRows, (Object[])actualRows);
    }

    @Test
    public void testSqlFileBasedTransformer() throws IOException {
        UtilitiesTestBase.Helpers.copyToDFS("streamer-config/sql-file-transformer.sql", UtilitiesTestBase.storage, UtilitiesTestBase.basePath + "/sql-file-transformer.sql");
        this.props.setProperty("hoodie.streamer.transformer.sql.file", UtilitiesTestBase.basePath + "/sql-file-transformer.sql");
        Dataset transformedRow = this.sqlFileTransformer.apply(jsc, sparkSession, this.inputDatasetRows, this.props);
        Object[] expectedRows = this.inputDatasetRows.distinct().sort("col1", new String[0]).as(Encoders.STRING()).collectAsList().toArray(new String[0]);
        Object[] actualRows = transformedRow.as(Encoders.STRING()).collectAsList().toArray(new String[0]);
        Assertions.assertArrayEquals((Object[])expectedRows, (Object[])actualRows);
    }

    private Dataset<Row> getInputDatasetRows() {
        ArrayList<Row> list = new ArrayList<Row>();
        list.add(RowFactory.create((Object[])new Object[]{"one"}));
        list.add(RowFactory.create((Object[])new Object[]{"two"}));
        list.add(RowFactory.create((Object[])new Object[]{"three"}));
        list.add(RowFactory.create((Object[])new Object[]{"four"}));
        list.add(RowFactory.create((Object[])new Object[]{"four"}));
        ArrayList<StructField> listOfStructField = new ArrayList<StructField>();
        listOfStructField.add(DataTypes.createStructField((String)"col1", (DataType)DataTypes.StringType, (boolean)true));
        StructType structType = DataTypes.createStructType(listOfStructField);
        return sparkSession.createDataFrame(list, structType);
    }

    private Dataset<Row> getEmptyDatasetRow() {
        ArrayList<StructField> listOfStructField = new ArrayList<StructField>();
        listOfStructField.add(DataTypes.createStructField((String)"col1", (DataType)DataTypes.StringType, (boolean)true));
        StructType structType = DataTypes.createStructType(listOfStructField);
        ArrayList list = new ArrayList();
        return sparkSession.createDataFrame(list, structType);
    }
}

