/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.Collections;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.utilities.transform.SqlQueryBasedTransformer;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlQueryBasedTransformer {
    @Test
    public void testSqlQuery() {
        SparkSession spark = SparkSession.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)TestSqlQueryBasedTransformer.class.getName())).getOrCreate();
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        String testData = "{\n  \"ts\": 1622126968000,\n  \"uuid\": \"c978e157-72ee-4819-8f04-8e46e1bb357a\",\n  \"rider\": \"rider-213\",\n  \"driver\": \"driver-213\",\n  \"begin_lat\": 0.4726905879569653,\n  \"begin_lon\": 0.46157858450465483,\n  \"end_lat\": 0.754803407008858,\n  \"end_lon\": 0.9671159942018241,\n  \"fare\": 34.158284716382845,\n  \"partitionpath\": \"americas/brazil/sao_paulo\"\n}";
        JavaRDD testRdd = jsc.parallelize(Collections.singletonList(testData), 2);
        Dataset ds = spark.read().json(testRdd);
        String transSql = "select\n\tuuid,\n\tbegin_lat,\n\tbegin_lon,\n\tdriver,\n\tend_lat,\n\tend_lon,\n\tfare,\n\tpartitionpath,\n\trider,\n\tts,\n\tFROM_UNIXTIME(ts / 1000, 'yyyyMMdd') as dt\nfrom\n\t<SRC>";
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.streamer.transformer.sql", (Object)transSql);
        SqlQueryBasedTransformer transformer = new SqlQueryBasedTransformer();
        Dataset result = transformer.apply(jsc, spark, ds, props);
        Assertions.assertEquals((int)11, (int)result.columns().length);
        Assertions.assertNotNull((Object)result.col("dt"));
        Assertions.assertEquals((Object)"20210527", (Object)((Row)result.first()).get(10).toString());
        spark.close();
    }
}

