/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class HoodieSnapshotCopier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSnapshotCopier.class);

    public void snapshot(JavaSparkContext jsc, String baseDir, String outputDir, boolean shouldAssumeDatePartitioning, boolean useFileListingFromMetadata) throws IOException {
        FileSystem fs = HadoopFSUtils.getFs((String)baseDir, (Configuration)jsc.hadoopConfiguration());
        StorageConfiguration storageConf = HadoopFSUtils.getStorageConfWithCopy((Configuration)jsc.hadoopConfiguration());
        HoodieTableMetaClient tableMetadata = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)fs.getConf())).setBasePath(baseDir).build();
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(tableMetadata, tableMetadata.getActiveTimeline().getWriteTimeline().filterCompletedInstants());
        HoodieSparkEngineContext context = new HoodieSparkEngineContext(jsc);
        Option latestCommit = tableMetadata.getActiveTimeline().getWriteTimeline().filterCompletedInstants().lastInstant();
        if (!latestCommit.isPresent()) {
            LOG.warn("No commits present. Nothing to snapshot");
            return;
        }
        String latestCommitTimestamp = ((HoodieInstant)latestCommit.get()).getTimestamp();
        LOG.info(String.format("Starting to snapshot latest version files which are also no-late-than %s.", latestCommitTimestamp));
        List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)context, (HoodieStorage)new HoodieHadoopStorage(fs), (String)baseDir, (boolean)useFileListingFromMetadata, (boolean)shouldAssumeDatePartitioning);
        if (partitions.size() > 0) {
            FileStatus[] commitFilesToCopy;
            LOG.info(String.format("The job needs to copy %d partitions.", partitions.size()));
            Path outputPath = new Path(outputDir);
            if (fs.exists(outputPath)) {
                LOG.warn(String.format("The output path %s targetBasePath already exists, deleting", outputPath));
                fs.delete(new Path(outputDir), true);
            }
            context.setJobStatus(this.getClass().getSimpleName(), "Creating a snapshot: " + baseDir);
            List filesToCopy = context.flatMap(partitions, arg_0 -> HoodieSnapshotCopier.lambda$snapshot$7172462b$1(baseDir, storageConf, (TableFileSystemView.BaseFileOnlyView)fsView, latestCommitTimestamp, arg_0), partitions.size());
            context.foreach(filesToCopy, (SerializableConsumer & Serializable)tuple -> {
                String partition = (String)tuple._1();
                Path sourceFilePath = new Path((String)tuple._2());
                Path toPartitionPath = HadoopFSUtils.constructAbsolutePathInHadoopPath((String)outputDir, (String)partition);
                FileSystem ifs = HadoopFSUtils.getFs((String)baseDir, (Configuration)((Configuration)storageConf.unwrapCopyAs(Configuration.class)));
                if (!ifs.exists(toPartitionPath)) {
                    ifs.mkdirs(toPartitionPath);
                }
                FileUtil.copy((FileSystem)ifs, (Path)sourceFilePath, (FileSystem)ifs, (Path)new Path(toPartitionPath, sourceFilePath.getName()), (boolean)false, (Configuration)ifs.getConf());
            }, filesToCopy.size());
            LOG.info(String.format("Copying .commit files which are no-late-than %s.", latestCommitTimestamp));
            for (FileStatus commitStatus : commitFilesToCopy = fs.listStatus(new Path(baseDir + "/" + ".hoodie"), commitFilePath -> {
                if (commitFilePath.getName().equals("hoodie.properties")) {
                    return true;
                }
                String instantTime = FSUtils.getCommitFromCommitFile((String)commitFilePath.getName());
                return HoodieTimeline.compareTimestamps((String)instantTime, (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)latestCommitTimestamp);
            })) {
                Path targetFilePath = new Path(outputDir + "/" + ".hoodie" + "/" + commitStatus.getPath().getName());
                if (!fs.exists(targetFilePath.getParent())) {
                    fs.mkdirs(targetFilePath.getParent());
                }
                if (fs.exists(targetFilePath)) {
                    LOG.error(String.format("The target output commit file (%s targetBasePath) already exists.", targetFilePath));
                }
                FileUtil.copy((FileSystem)fs, (Path)commitStatus.getPath(), (FileSystem)fs, (Path)targetFilePath, (boolean)false, (Configuration)fs.getConf());
            }
        } else {
            LOG.info("The job has 0 partition to copy.");
        }
        Path successTagPath = new Path(outputDir + "/_SUCCESS");
        if (!fs.exists(successTagPath)) {
            LOG.info(String.format("Creating _SUCCESS under targetBasePath: %s", outputDir));
            fs.createNewFile(successTagPath);
        }
    }

    public static void main(String[] args) throws IOException {
        Config cfg = new Config();
        new JCommander((Object)cfg, null, args);
        LOG.info(String.format("Snapshot hoodie table from %s (source) to %s (target)", cfg.basePath, cfg.outputPath));
        SparkConf sparkConf = UtilHelpers.buildSparkConf("Hoodie-snapshot-copier", "local[*]");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        LOG.info("Initializing spark job.");
        HoodieSnapshotCopier copier = new HoodieSnapshotCopier();
        copier.snapshot(jsc, cfg.basePath, cfg.outputPath, cfg.shouldAssumeDatePartitioning, cfg.useFileListingFromMetadata);
        jsc.stop();
    }

    private static /* synthetic */ Stream lambda$snapshot$7172462b$1(String baseDir, StorageConfiguration storageConf, TableFileSystemView.BaseFileOnlyView fsView, String latestCommitTimestamp, String partition) throws Exception {
        HoodieStorage storage1 = HoodieStorageUtils.getStorage((String)baseDir, (StorageConfiguration)storageConf);
        ArrayList<Tuple2> filePaths = new ArrayList<Tuple2>();
        Stream dataFiles = fsView.getLatestBaseFilesBeforeOrOn(partition, latestCommitTimestamp);
        dataFiles.forEach(hoodieDataFile -> filePaths.add(new Tuple2((Object)partition, (Object)hoodieDataFile.getPath())));
        StoragePath partitionMetaFile = (StoragePath)HoodiePartitionMetadata.getPartitionMetafilePath((HoodieStorage)storage1, (StoragePath)FSUtils.constructAbsolutePath((String)baseDir, (String)partition)).get();
        if (storage1.exists(partitionMetaFile)) {
            filePaths.add(new Tuple2((Object)partition, (Object)partitionMetaFile.toString()));
        }
        return filePaths.stream();
    }

    static class Config
    implements Serializable {
        @Parameter(names={"--base-path", "-bp"}, description="Hoodie table base path", required=true)
        String basePath = null;
        @Parameter(names={"--output-path", "-op"}, description="The snapshot output path", required=true)
        String outputPath = null;
        @Parameter(names={"--date-partitioned", "-dp"}, description="Can we assume date partitioning?")
        boolean shouldAssumeDatePartitioning = false;
        @Parameter(names={"--use-file-listing-from-metadata"}, description="Fetch file listing from Hudi's metadata")
        public Boolean useFileListingFromMetadata = false;

        Config() {
        }
    }
}

