/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="JDBC Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of JDBC source in Hudi Streamer.")
@Immutable
public class JdbcSourceConfig
extends HoodieConfig {
    public static final ConfigProperty<String> URL = ConfigProperty.key((String)"hoodie.streamer.jdbc.url").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.url"}).markAdvanced().withDocumentation("JDBC url for the Hoodie datasource.");
    public static final ConfigProperty<String> USER = ConfigProperty.key((String)"hoodie.streamer.jdbc.user").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.user"}).markAdvanced().withDocumentation("Username used for JDBC connection");
    public static final ConfigProperty<String> PASSWORD = ConfigProperty.key((String)"hoodie.streamer.jdbc.password").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.password"}).markAdvanced().withDocumentation("Password used for JDBC connection");
    public static final ConfigProperty<String> PASSWORD_FILE = ConfigProperty.key((String)"hoodie.streamer.jdbc.password.file").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.password.file"}).markAdvanced().withDocumentation("Base-path for the JDBC password file.");
    public static final ConfigProperty<String> DRIVER_CLASS = ConfigProperty.key((String)"hoodie.streamer.jdbc.driver.class").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.driver.class"}).markAdvanced().withDocumentation("Driver class used for JDBC connection");
    public static final ConfigProperty<String> RDBMS_TABLE_NAME = ConfigProperty.key((String)"hoodie.streamer.jdbc.table.name").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.table.name"}).markAdvanced().withDocumentation("RDBMS table to pull");
    public static final ConfigProperty<String> INCREMENTAL_COLUMN = ConfigProperty.key((String)"hoodie.streamer.jdbc.table.incr.column.name").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.table.incr.column.name"}).markAdvanced().withDocumentation("If run in incremental mode, this field is to pull new data incrementally");
    public static final ConfigProperty<String> IS_INCREMENTAL = ConfigProperty.key((String)"hoodie.streamer.jdbc.incr.pull").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.incr.pull"}).markAdvanced().withDocumentation("Will the JDBC source do an incremental pull?");
    public static final ConfigProperty<String> EXTRA_OPTIONS = ConfigProperty.key((String)"hoodie.streamer.jdbc.extra.options.").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.extra.options."}).markAdvanced().withDocumentation("Used to set any extra options the user specifies for jdbc");
    public static final ConfigProperty<String> STORAGE_LEVEL = ConfigProperty.key((String)"hoodie.streamer.jdbc.storage.level").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.storage.level"}).markAdvanced().withDocumentation("Used to control the persistence level. Default value: MEMORY_AND_DISK_SER");
    public static final ConfigProperty<String> FALLBACK_TO_FULL_FETCH = ConfigProperty.key((String)"hoodie.streamer.jdbc.incr.fallback.to.full.fetch").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.jdbc.incr.fallback.to.full.fetch"}).markAdvanced().withDocumentation("If set true, makes incremental fetch to fallback to full fetch in case of any error");
}

