/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deser;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.kafka.common.errors.SerializationException;

public class KafkaAvroSchemaDeserializer
extends KafkaAvroDeserializer {
    private Schema sourceSchema;

    public KafkaAvroSchemaDeserializer() {
    }

    public KafkaAvroSchemaDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        super(client, props);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        try {
            TypedProperties props = this.getConvertToTypedProperties(configs);
            this.sourceSchema = new Schema.Parser().parse(ConfigUtils.getStringWithAltKeys((TypedProperties)props, KafkaSourceConfig.KAFKA_VALUE_DESERIALIZER_SCHEMA));
        }
        catch (Throwable e) {
            throw new HoodieException(e);
        }
    }

    protected Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        return super.deserialize(topic, isKey, payload, this.sourceSchema);
    }

    protected TypedProperties getConvertToTypedProperties(Map<String, ?> configs) {
        TypedProperties typedProperties = new TypedProperties();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            typedProperties.put((Object)entry.getKey(), entry.getValue());
        }
        return typedProperties;
    }
}

