/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.HoodieIncrSourceConfig;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.SnapshotLoadQuerySplitter;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.hudi.utilities.streamer.StreamContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieIncrSource
extends RowSource {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIncrSource.class);
    private final Option<SnapshotLoadQuerySplitter> snapshotLoadQuerySplitter;

    public HoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, StreamContext streamContext) {
        super(props, sparkContext, sparkSession, streamContext);
        this.snapshotLoadQuerySplitter = SnapshotLoadQuerySplitter.getInstance(props);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        Dataset source;
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy;
        ConfigUtils.checkRequiredConfigProperties((TypedProperties)this.props, Collections.singletonList(HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH));
        String srcPath = ConfigUtils.getStringWithAltKeys((TypedProperties)this.props, HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH);
        int numInstantsPerFetch = ConfigUtils.getIntWithAltKeys((TypedProperties)this.props, HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH);
        boolean readLatestOnMissingCkpt = ConfigUtils.getBooleanWithAltKeys((Properties)this.props, HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT);
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy2 = missingCheckpointStrategy = ConfigUtils.containsConfigProperty((TypedProperties)this.props, HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY) ? IncrSourceHelper.MissingCheckpointStrategy.valueOf(ConfigUtils.getStringWithAltKeys((TypedProperties)this.props, HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY)) : null;
        if (readLatestOnMissingCkpt) {
            missingCheckpointStrategy = IncrSourceHelper.MissingCheckpointStrategy.READ_LATEST;
        }
        Option<String> beginInstant = lastCkptStr.isPresent() ? (((String)lastCkptStr.get()).isEmpty() ? Option.empty() : lastCkptStr) : Option.empty();
        TimelineUtils.HollowCommitHandling handlingMode = IncrSourceHelper.getHollowCommitHandleMode(this.props);
        QueryInfo queryInfo = IncrSourceHelper.generateQueryInfo(this.sparkContext, srcPath, numInstantsPerFetch, beginInstant, missingCheckpointStrategy, handlingMode, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, null, false, (Option<String>)Option.empty());
        if (queryInfo.areStartAndEndInstantsEqual()) {
            LOG.info("Already caught up. No new data to process");
            return Pair.of((Object)Option.empty(), (Object)queryInfo.getEndInstant());
        }
        DataFrameReader reader = this.sparkSession.read().format("hudi");
        String datasourceOpts = ConfigUtils.getStringWithAltKeys((TypedProperties)this.props, HoodieIncrSourceConfig.HOODIE_INCREMENTAL_SPARK_DATASOURCE_OPTIONS, (boolean)true);
        if (!StringUtils.isNullOrEmpty((String)datasourceOpts)) {
            Map<String, String> optionsMap = Arrays.stream(datasourceOpts.split(",")).map(option -> Pair.of((Object)option.split("=")[0], (Object)option.split("=")[1])).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            reader = reader.options(optionsMap);
        }
        if (queryInfo.isIncremental()) {
            source = reader.option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME().key(), queryInfo.getStartInstant()).option(DataSourceReadOptions.END_INSTANTTIME().key(), queryInfo.getEndInstant()).option(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN().key(), this.props.getString(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN().key(), (String)DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN().defaultValue())).option(DataSourceReadOptions.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key(), handlingMode.name()).load(srcPath);
        } else {
            Dataset snapshot = reader.option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(srcPath);
            if (this.snapshotLoadQuerySplitter.isPresent()) {
                queryInfo = ((SnapshotLoadQuerySplitter)this.snapshotLoadQuerySplitter.get()).getNextCheckpoint((Dataset<Row>)snapshot, queryInfo);
            }
            source = snapshot.filter(String.format("%s > '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryInfo.getStartInstant())).filter(String.format("%s <= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryInfo.getEndInstant()));
        }
        HoodieRecord.HoodieRecordType recordType = UtilHelpers.createRecordMerger((Properties)this.props).getRecordType();
        boolean shouldDropMetaFields = ConfigUtils.getBooleanWithAltKeys((Properties)this.props, HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE) || recordType == HoodieRecord.HoodieRecordType.SPARK;
        String[] colsToDrop = shouldDropMetaFields ? (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().toArray(String[]::new) : (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().filter(x -> !x.equals(HoodieRecord.PARTITION_PATH_METADATA_FIELD)).toArray(String[]::new);
        Dataset src = source.drop(colsToDrop);
        return Pair.of((Object)Option.of((Object)src), (Object)queryInfo.getEndInstant());
    }

    public static class Config {
        @Deprecated
        public static final String HOODIE_SRC_BASE_PATH = HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH.key();
        @Deprecated
        static final String NUM_INSTANTS_PER_FETCH = HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH.key();
        @Deprecated
        static final Integer DEFAULT_NUM_INSTANTS_PER_FETCH = (Integer)HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH.defaultValue();
        @Deprecated
        static final String HOODIE_SRC_PARTITION_FIELDS = HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_FIELDS.key();
        @Deprecated
        static final String HOODIE_SRC_PARTITION_EXTRACTORCLASS = HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_EXTRACTORCLASS.key();
        @Deprecated
        static final String DEFAULT_HOODIE_SRC_PARTITION_EXTRACTORCLASS = (String)HoodieIncrSourceConfig.HOODIE_SRC_PARTITION_EXTRACTORCLASS.defaultValue();
        @Deprecated
        public static final String READ_LATEST_INSTANT_ON_MISSING_CKPT = HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT.key();
        @Deprecated
        public static final Boolean DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT = (Boolean)HoodieIncrSourceConfig.READ_LATEST_INSTANT_ON_MISSING_CKPT.defaultValue();
        @Deprecated
        public static final String MISSING_CHECKPOINT_STRATEGY = HoodieIncrSourceConfig.MISSING_CHECKPOINT_STRATEGY.key();
        @Deprecated
        static final String SOURCE_FILE_FORMAT = HoodieIncrSourceConfig.SOURCE_FILE_FORMAT.key();
        @Deprecated
        static final String DEFAULT_SOURCE_FILE_FORMAT = (String)HoodieIncrSourceConfig.SOURCE_FILE_FORMAT.defaultValue();
        @Deprecated
        static final String HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE.key();
        @Deprecated
        public static final Boolean DEFAULT_HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = (Boolean)HoodieIncrSourceConfig.HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE.defaultValue();
    }
}

