/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieErrorTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.utilities.streamer.BaseErrorTableWriter;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;

public final class ErrorTableUtils {
    public static Option<BaseErrorTableWriter> getErrorTableWriter(HoodieStreamer.Config cfg, SparkSession sparkSession, TypedProperties props, HoodieSparkEngineContext hoodieSparkContext, FileSystem fileSystem) {
        String errorTableWriterClass = props.getString(HoodieErrorTableConfig.ERROR_TABLE_WRITE_CLASS.key());
        ValidationUtils.checkState((!StringUtils.isNullOrEmpty((String)errorTableWriterClass) ? 1 : 0) != 0, (String)("Missing error table config " + HoodieErrorTableConfig.ERROR_TABLE_WRITE_CLASS));
        Object[] argClassArr = new Class[]{HoodieStreamer.Config.class, SparkSession.class, TypedProperties.class, HoodieSparkEngineContext.class, FileSystem.class};
        String errMsg = "Unable to instantiate ErrorTableWriter with arguments type " + Arrays.toString(argClassArr);
        ValidationUtils.checkArgument((boolean)ReflectionUtils.hasConstructor((String)BaseErrorTableWriter.class.getName(), (Class[])argClassArr, (boolean)false), (String)errMsg);
        try {
            return Option.of((Object)((BaseErrorTableWriter)ReflectionUtils.getClass((String)errorTableWriterClass).getConstructor((Class<?>[])argClassArr).newInstance(cfg, sparkSession, props, hoodieSparkContext, fileSystem)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException(errMsg, (Throwable)e);
        }
    }

    public static HoodieErrorTableConfig.ErrorWriteFailureStrategy getErrorWriteFailureStrategy(TypedProperties props) {
        String writeFailureStrategy = props.getString(HoodieErrorTableConfig.ERROR_TABLE_WRITE_FAILURE_STRATEGY.key(), (String)HoodieErrorTableConfig.ERROR_TABLE_WRITE_FAILURE_STRATEGY.defaultValue());
        return HoodieErrorTableConfig.ErrorWriteFailureStrategy.valueOf((String)writeFailureStrategy);
    }

    public static void validate(Dataset<Row> dataset) {
        if (!ErrorTableUtils.isErrorTableCorruptRecordColumnPresent(dataset)) {
            throw new HoodieValidationException(String.format("Invalid condition, columnName=%s is not present in transformer output schema", BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME));
        }
    }

    public static Dataset<Row> addNullValueErrorTableCorruptRecordColumn(Dataset<Row> dataset) {
        if (!ErrorTableUtils.isErrorTableCorruptRecordColumnPresent(dataset)) {
            dataset = dataset.withColumn(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME, functions.lit(null));
        }
        return dataset;
    }

    private static boolean isErrorTableCorruptRecordColumnPresent(Dataset<Row> dataset) {
        return Arrays.stream(dataset.columns()).anyMatch(col -> col.equals(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME));
    }
}

