/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTTLJob {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTTLJob.class);
    private final Config cfg;
    private final TypedProperties props;
    private final JavaSparkContext jsc;
    private HoodieTableMetaClient metaClient;

    public HoodieTTLJob(JavaSparkContext jsc, Config cfg) {
        this(jsc, cfg, UtilHelpers.buildProperties(jsc.hadoopConfiguration(), cfg.propsFilePath, cfg.configs), UtilHelpers.createMetaClient(jsc, cfg.basePath, true));
    }

    public HoodieTTLJob(JavaSparkContext jsc, Config cfg, TypedProperties props, HoodieTableMetaClient metaClient) {
        this.cfg = cfg;
        this.jsc = jsc;
        this.props = props;
        this.metaClient = metaClient;
        LOG.info("Creating TTL job with configs : " + props.toString());
        this.props.put((Object)HoodieCleanConfig.ASYNC_CLEAN.key(), (Object)false);
        if (this.metaClient.getTableConfig().isMetadataTableAvailable()) {
            UtilHelpers.addLockOptions(cfg.basePath, this.metaClient.getBasePath().toUri().getScheme(), this.props);
        }
    }

    public void run() {
        this.props.put((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), (Object)"true");
        try (SparkRDDWriteClient<HoodieRecordPayload> client = UtilHelpers.createHoodieClient(this.jsc, this.cfg.basePath, "", this.cfg.parallelism, (Option<String>)Option.empty(), this.props);){
            client.managePartitionTTL(client.createNewInstantTime());
        }
    }

    private HoodieWriteConfig getHoodieClientConfig() {
        return HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(this.cfg.basePath).withAutoCommit(true).withProps((Map)this.props).build();
    }

    public static void main(String[] args) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            throw new HoodieException("Failed to run ttl for " + cfg.basePath);
        }
        String dirName = new Path(cfg.basePath).getName();
        JavaSparkContext jssc = UtilHelpers.buildSparkContext("hoodie-ttl-job-" + dirName, cfg.sparkMaster);
        try {
            new HoodieTTLJob(jssc, cfg).run();
        }
        catch (Throwable throwable) {
            throw new HoodieException("Failed to run ttl for " + cfg.basePath, throwable);
        }
        finally {
            jssc.stop();
        }
        LOG.info("Hoodie TTL job ran successfully");
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--base-path", "-sp"}, description="Base path for the table", required=true)
        public String basePath = null;
        @Parameter(names={"--parallelism", "-pl"}, description="Parallelism for hoodie insert/upsert/delete", required=false)
        public int parallelism = 1500;
        @Parameter(names={"--spark-master", "-ms"}, description="Spark master")
        public String sparkMaster = null;
        @Parameter(names={"--spark-memory", "-sm"}, description="spark memory to use", required=false)
        public String sparkMemory = null;
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for clustering")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
    }
}

