/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import org.apache.hudi.common.util.StringUtils;

public class SqlQueryBuilder {
    private final StringBuilder sqlBuilder;

    private SqlQueryBuilder(StringBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public static SqlQueryBuilder select(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("No columns provided with SELECT statement. Please mention column names or '*' to select all columns.");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ");
        sqlBuilder.append(String.join((CharSequence)", ", columns));
        return new SqlQueryBuilder(sqlBuilder);
    }

    public SqlQueryBuilder from(String ... tables) {
        if (tables == null || tables.length == 0) {
            throw new IllegalArgumentException("No table name provided with FROM clause. Please provide a table name to select from.");
        }
        this.sqlBuilder.append(" from ");
        this.sqlBuilder.append(String.join((CharSequence)", ", tables));
        return this;
    }

    public SqlQueryBuilder join(String table) {
        if (StringUtils.isNullOrEmpty((String)table)) {
            throw new IllegalArgumentException("No table name provided with JOIN clause. Please provide a table name to join with.");
        }
        this.sqlBuilder.append(" join ");
        this.sqlBuilder.append(table);
        return this;
    }

    public SqlQueryBuilder on(String predicate) {
        if (StringUtils.isNullOrEmpty((String)predicate)) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" on ");
        this.sqlBuilder.append(predicate);
        return this;
    }

    public SqlQueryBuilder where(String predicate) {
        if (StringUtils.isNullOrEmpty((String)predicate)) {
            throw new IllegalArgumentException("No predicate provided with WHERE clause. Please provide a predicate to filter records.");
        }
        this.sqlBuilder.append(" where ");
        this.sqlBuilder.append(predicate);
        return this;
    }

    public SqlQueryBuilder orderBy(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("No columns provided with ORDER BY clause. Please provide a column name to order records.");
        }
        this.sqlBuilder.append(" order by ");
        this.sqlBuilder.append(String.join((CharSequence)", ", columns));
        return this;
    }

    public SqlQueryBuilder limit(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Please provide a positive integer for the LIMIT clause.");
        }
        this.sqlBuilder.append(" limit ");
        this.sqlBuilder.append(count);
        return this;
    }

    public String toString() {
        return this.sqlBuilder.toString();
    }
}

