/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

@ConfigClassProperty(name="Kafka Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of Kafka source in Hudi Streamer.")
@Immutable
public class KafkaSourceConfig
extends HoodieConfig {
    public static final String KAFKA_CHECKPOINT_TYPE_STRING = "string";
    public static final String KAFKA_CHECKPOINT_TYPE_TIMESTAMP = "timestamp";
    public static final String KAFKA_CHECKPOINT_TYPE_SINGLE_OFFSET = "single_offset";
    private static final String PREFIX = "hoodie.streamer.source.kafka.";
    private static final String OLD_PREFIX = "hoodie.deltastreamer.source.kafka.";
    public static final ConfigProperty<String> KAFKA_CHECKPOINT_TYPE = ConfigProperty.key((String)"hoodie.streamer.source.kafka.checkpoint.type").defaultValue((Object)"string").withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.checkpoint.type"}).markAdvanced().withDocumentation("Kafka checkpoint type. Value must be one of the following: string, timestamp, single_offset. Default type is string. For type string, checkpoint should be provided as: topicName,0:offset0,1:offset1,2:offset2. For type timestamp, checkpoint should be provided as long value of desired timestamp. For type single_offset, we assume that topic consists of a single partition, so checkpoint should be provided as long value of desired offset.");
    public static final ConfigProperty<String> KAFKA_AVRO_VALUE_DESERIALIZER_CLASS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.value.deserializer.class").defaultValue((Object)"io.confluent.kafka.serializers.KafkaAvroDeserializer").withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.value.deserializer.class"}).markAdvanced().sinceVersion("0.9.0").withDocumentation("This class is used by kafka client to deserialize the records.");
    public static final ConfigProperty<String> KAFKA_VALUE_DESERIALIZER_SCHEMA = ConfigProperty.key((String)"hoodie.streamer.source.kafka.value.deserializer.schema").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.value.deserializer.schema"}).markAdvanced().withDocumentation("Schema to deserialize the records.");
    @Deprecated
    public static final ConfigProperty<Long> KAFKA_FETCH_PARTITION_TIME_OUT = ConfigProperty.key((String)"hoodie.streamer.source.kafka.fetch_partition.time.out").defaultValue((Object)300000L).withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.fetch_partition.time.out"}).markAdvanced().withDocumentation("Time out for fetching partitions. 5min by default");
    public static final ConfigProperty<Boolean> ENABLE_KAFKA_COMMIT_OFFSET = ConfigProperty.key((String)"hoodie.streamer.source.kafka.enable.commit.offset").defaultValue((Object)false).withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.enable.commit.offset"}).markAdvanced().withDocumentation("Automatically submits offset to kafka.");
    public static final ConfigProperty<Boolean> ENABLE_FAIL_ON_DATA_LOSS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.enable.failOnDataLoss").defaultValue((Object)false).withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.enable.failOnDataLoss"}).markAdvanced().withDocumentation("Fail when checkpoint goes out of bounds instead of seeking to earliest offsets.");
    public static final ConfigProperty<Long> MAX_EVENTS_FROM_KAFKA_SOURCE = ConfigProperty.key((String)"hoodie.streamer.kafka.source.maxEvents").defaultValue((Object)5000000L).withAlternatives(new String[]{"hoodie.deltastreamer.kafka.source.maxEvents"}).markAdvanced().withDocumentation("Maximum number of records obtained in each batch.");
    public static final ConfigProperty<Long> KAFKA_SOURCE_MIN_PARTITIONS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.minPartitions").defaultValue((Object)0L).withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.minPartitions"}).markAdvanced().sinceVersion("0.14.0").withDocumentation("Desired minimum number of partitions to read from Kafka. By default, Hudi has a 1-1 mapping of topicPartitions to Hudi partitions consuming from Kafka. If set this option to a value greater than topicPartitions, Hudi will divvy up large Kafka partitions to smaller pieces. Please note that this configuration is like a hint: the number of input tasks will be approximately minPartitions. It can be less or more depending on rounding errors or Kafka partitions that didn't receive any new data.");
    public static final ConfigProperty<String> KAFKA_TOPIC_NAME = ConfigProperty.key((String)"hoodie.streamer.source.kafka.topic").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.kafka.topic"}).withDocumentation("Kafka topic name.");
    public static final ConfigProperty<KafkaResetOffsetStrategies> KAFKA_AUTO_OFFSET_RESET = ConfigProperty.key((String)"auto.offset.reset").defaultValue((Object)KafkaResetOffsetStrategies.LATEST).markAdvanced().withDocumentation("Kafka consumer strategy for reading data.");
    public static final ConfigProperty<String> KAFKA_PROTO_VALUE_DESERIALIZER_CLASS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.proto.value.deserializer.class").defaultValue((Object)ByteArrayDeserializer.class.getName()).sinceVersion("0.15.0").withDocumentation("Kafka Proto Payload Deserializer Class");
    public static final ConfigProperty<Long> INITIAL_RETRY_INTERVAL_MS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.retry.initial_interval_ms").defaultValue((Object)100L).markAdvanced().sinceVersion("1.1.0").withDocumentation("Amount of time (in ms) to wait, before retry to do operations on KafkaConsumer.");
    public static final ConfigProperty<Long> MAX_RETRY_INTERVAL_MS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.retry.max_interval_ms").defaultValue((Object)2000L).markAdvanced().sinceVersion("1.1.0").withDocumentation("Maximum amount of time (in ms), to wait for next retry.");
    public static final ConfigProperty<Integer> MAX_RETRY_COUNT = ConfigProperty.key((String)"hoodie.streamer.source.kafka.retry.max_count").defaultValue((Object)4).markAdvanced().sinceVersion("1.1.0").withDocumentation("Maximum number of retry actions to perform, with exponential backoff.");
    public static final ConfigProperty<String> RETRY_EXCEPTIONS = ConfigProperty.key((String)"hoodie.streamer.source.kafka.retry.exceptions").defaultValue((Object)"").markAdvanced().sinceVersion("1.1.0").withDocumentation("The class name of the Exception that needs to be retried, separated by commas. Default is empty which means retry all the IOException and RuntimeException from KafkaConsumer");

    public static enum KafkaResetOffsetStrategies {
        LATEST,
        EARLIEST,
        GROUP;

    }
}

