/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="S3 Event-based Hudi Incremental Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of incremental pulling from S3 events meta information from Hudi table as a source in Hudi Streamer.")
@Immutable
public class S3EventsHoodieIncrSourceConfig
extends HoodieConfig {
    public static final ConfigProperty<Boolean> S3_INCR_ENABLE_EXISTS_CHECK = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.check.file.exists").defaultValue((Object)false).withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.check.file.exists"}).markAdvanced().withDocumentation("Control whether we do existence check for files before consuming them");
    @Deprecated
    public static final ConfigProperty<String> S3_KEY_PREFIX = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.key.prefix").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.key.prefix"}).markAdvanced().deprecatedAfter("0.15.0").withDocumentation("Control whether to filter the s3 objects starting with this prefix");
    public static final ConfigProperty<String> S3_FS_PREFIX = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.fs.prefix").defaultValue((Object)"s3").withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.fs.prefix"}).markAdvanced().withDocumentation("The file system prefix.");
    @Deprecated
    public static final ConfigProperty<String> S3_IGNORE_KEY_PREFIX = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.ignore.key.prefix").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.ignore.key.prefix"}).markAdvanced().deprecatedAfter("0.15.0").withDocumentation("Control whether to ignore the s3 objects starting with this prefix");
    @Deprecated
    public static final ConfigProperty<String> S3_IGNORE_KEY_SUBSTRING = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.ignore.key.substring").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.ignore.key.substring"}).markAdvanced().deprecatedAfter("0.15.0").withDocumentation("Control whether to ignore the s3 objects with this substring");
    public static final ConfigProperty<String> SPARK_DATASOURCE_OPTIONS = ConfigProperty.key((String)"hoodie.streamer.source.s3incr.spark.datasource.options").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.source.s3incr.spark.datasource.options"}).markAdvanced().withDocumentation("Json string, passed to the reader while loading dataset. Example Hudi Streamer conf \n --hoodie-conf hoodie.streamer.source.s3incr.spark.datasource.options={\"header\":\"true\",\"encoding\":\"UTF-8\"}");
}

