/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.sources.SnapshotLoadQuerySplitter;

public class QueryInfo {
    private final String queryType;
    private final String previousInstant;
    private final String startInstant;
    private final String endInstant;
    private final String predicateFilter;
    private final String orderColumn;
    private final String keyColumn;
    private final String limitColumn;
    private final List<String> orderByColumns;

    public QueryInfo(String queryType, String previousInstant, String startInstant, String endInstant, String orderColumn, String keyColumn, String limitColumn) {
        this(queryType, previousInstant, startInstant, endInstant, "", orderColumn, keyColumn, limitColumn);
    }

    public QueryInfo(String queryType, String previousInstant, String startInstant, String endInstant, String predicateFilter, String orderColumn, String keyColumn, String limitColumn) {
        this.queryType = queryType;
        this.previousInstant = previousInstant;
        this.startInstant = startInstant;
        this.endInstant = endInstant;
        this.predicateFilter = predicateFilter;
        this.orderColumn = orderColumn;
        this.keyColumn = keyColumn;
        this.limitColumn = limitColumn;
        this.orderByColumns = Arrays.asList(orderColumn, keyColumn);
    }

    public boolean areStartAndEndInstantsEqual() {
        return this.getStartInstant().equals(this.getEndInstant());
    }

    public boolean isIncremental() {
        return DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL().equals(this.queryType);
    }

    public boolean isSnapshot() {
        return DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL().equals(this.queryType);
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getPreviousInstant() {
        return this.previousInstant;
    }

    public String getStartInstant() {
        return this.startInstant;
    }

    public String getEndInstant() {
        return this.endInstant;
    }

    public String getOrderColumn() {
        return this.orderColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getLimitColumn() {
        return this.limitColumn;
    }

    public List<String> getOrderByColumns() {
        return this.orderByColumns;
    }

    public Option<String> getPredicateFilter() {
        if (!StringUtils.isNullOrEmpty((String)this.predicateFilter)) {
            return Option.of((Object)this.predicateFilter);
        }
        return Option.empty();
    }

    public QueryInfo withUpdatedEndInstant(String newEndInstant) {
        return new QueryInfo(this.queryType, this.previousInstant, this.startInstant, newEndInstant, this.orderColumn, this.keyColumn, this.limitColumn);
    }

    public QueryInfo withUpdatedCheckpoint(SnapshotLoadQuerySplitter.CheckpointWithPredicates checkpointWithPredicates) {
        return new QueryInfo(this.queryType, this.previousInstant, this.startInstant, checkpointWithPredicates.getEndCompletionTime(), checkpointWithPredicates.getPredicateFilter(), this.orderColumn, this.keyColumn, this.limitColumn);
    }

    public String toString() {
        return "Query information for Incremental Source queryType: " + this.queryType + ", previousInstant: " + this.previousInstant + ", startInstant: " + this.startInstant + ", endInstant: " + this.endInstant + ", orderColumn: " + this.orderColumn + ", keyColumn: " + this.keyColumn + ", limitColumn: " + this.limitColumn + ", orderByColumns: " + this.orderByColumns;
    }
}

