/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="S3 Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of S3 source in Hudi Streamer.")
@Immutable
public class S3SourceConfig
extends HoodieConfig {
    private static final String S3_SOURCE_PREFIX = "hoodie.streamer.s3.source.";
    private static final String OLD_S3_SOURCE_PREFIX = "hoodie.deltastreamer.s3.source.";
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_URL = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.url").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.url"}).withDocumentation("Queue url for cloud object events");
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_REGION = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.region").noDefaultValue().withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.region"}).markAdvanced().withDocumentation("Case-sensitive region name of the cloud provider for the queue. For example, \"us-east-1\".");
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_FS = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.fs").defaultValue((Object)"s3").withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.fs"}).markAdvanced().withDocumentation("File system corresponding to queue. For example, for AWS SQS it is s3/s3a.");
    public static final ConfigProperty<String> S3_QUEUE_LONG_POLL_WAIT = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.long.poll.wait").defaultValue((Object)"20").withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.long.poll.wait"}).markAdvanced().withDocumentation("Long poll wait time in seconds, If set as 0 then client will fetch on short poll basis.");
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_MAX_MESSAGES_PER_BATCH = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.max.messages.per.batch").defaultValue((Object)"5").withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.max.messages.per.batch"}).markAdvanced().withDocumentation("Max messages for each batch of Hudi Streamer run. Source will process these maximum number of message at a time.");
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_MAX_MESSAGES_PER_REQUEST = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.max.messages.per.request").defaultValue((Object)"10").withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.max.messages.per.request"}).markAdvanced().withDocumentation("Max messages for each request");
    public static final ConfigProperty<String> S3_SOURCE_QUEUE_VISIBILITY_TIMEOUT = ConfigProperty.key((String)"hoodie.streamer.s3.source.queue.visibility.timeout").defaultValue((Object)"30").withAlternatives(new String[]{"hoodie.deltastreamer.s3.source.queue.visibility.timeout"}).markAdvanced().withDocumentation("Visibility timeout for messages in queue. After we consume the message, queue will move the consumed messages to in-flight state, these messages can't be consumed again by source for this timeout period.");
}

