/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.AvroSource;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;

public class AvroDFSSource
extends AvroSource {
    private final DFSPathSelector pathSelector;

    public AvroDFSSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) throws IOException {
        super(props, sparkContext, sparkSession, schemaProvider);
        sparkContext.hadoopConfiguration().set("avro.schema.input.key", schemaProvider.getSourceSchema().toString());
        this.pathSelector = DFSPathSelector.createSourceSelector(props, sparkContext.hadoopConfiguration());
    }

    @Override
    protected InputBatch<JavaRDD<GenericRecord>> readFromCheckpoint(Option<Checkpoint> lastCheckpoint, long sourceLimit) {
        Pair<Option<String>, Checkpoint> selectPathsWithMaxModificationTime = this.pathSelector.getNextFilePathsAndMaxModificationTime(this.sparkContext, lastCheckpoint, sourceLimit);
        return (InputBatch)((Option)selectPathsWithMaxModificationTime.getLeft()).map(pathStr -> new InputBatch(Option.of(this.fromFiles((String)pathStr)), (Checkpoint)selectPathsWithMaxModificationTime.getRight())).orElseGet(() -> new InputBatch(Option.empty(), (Checkpoint)selectPathsWithMaxModificationTime.getRight()));
    }

    private JavaRDD<GenericRecord> fromFiles(String pathStr) {
        this.sparkContext.setJobGroup(this.getClass().getSimpleName(), "Fetch Avro data from files");
        JavaPairRDD avroRDD = this.sparkContext.newAPIHadoopFile(pathStr, AvroKeyInputFormat.class, AvroKey.class, NullWritable.class, this.sparkContext.hadoopConfiguration());
        return avroRDD.keys().map((Function & Serializable)r -> (GenericRecord)r.datum());
    }
}

