/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import com.google.pubsub.v1.ReceivedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.CloudSourceConfig;
import org.apache.hudi.utilities.config.GCSEventsSourceConfig;
import org.apache.hudi.utilities.exception.HoodieReadFromSourceException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.helpers.gcs.MessageBatch;
import org.apache.hudi.utilities.sources.helpers.gcs.MessageValidity;
import org.apache.hudi.utilities.sources.helpers.gcs.MetadataMessage;
import org.apache.hudi.utilities.sources.helpers.gcs.PubsubMessagesFetcher;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsEventsSource
extends RowSource {
    private final PubsubMessagesFetcher pubsubMessagesFetcher;
    private final SchemaProvider schemaProvider;
    private final boolean ackMessages;
    private final List<String> messagesToAck = new ArrayList<String>();
    private static final Checkpoint CHECKPOINT_VALUE_ZERO = new StreamerCheckpointV2("0");
    private static final Logger LOG = LoggerFactory.getLogger(GcsEventsSource.class);

    public GcsEventsSource(TypedProperties props, JavaSparkContext jsc, SparkSession spark, SchemaProvider schemaProvider) {
        this(props, jsc, spark, schemaProvider, new PubsubMessagesFetcher(ConfigUtils.getStringWithAltKeys((Properties)props, GCSEventsSourceConfig.GOOGLE_PROJECT_ID), ConfigUtils.getStringWithAltKeys((Properties)props, GCSEventsSourceConfig.PUBSUB_SUBSCRIPTION_ID), ConfigUtils.getIntWithAltKeys((TypedProperties)props, CloudSourceConfig.BATCH_SIZE_CONF), ConfigUtils.getIntWithAltKeys((TypedProperties)props, CloudSourceConfig.MAX_NUM_MESSAGES_PER_SYNC), ConfigUtils.getIntWithAltKeys((TypedProperties)props, CloudSourceConfig.MAX_FETCH_TIME_PER_SYNC_SECS)));
    }

    public GcsEventsSource(TypedProperties props, JavaSparkContext jsc, SparkSession spark, SchemaProvider schemaProvider, PubsubMessagesFetcher pubsubMessagesFetcher) {
        super(props, jsc, spark, schemaProvider);
        this.pubsubMessagesFetcher = pubsubMessagesFetcher;
        this.ackMessages = ConfigUtils.getBooleanWithAltKeys((Properties)props, CloudSourceConfig.ACK_MESSAGES);
        this.schemaProvider = schemaProvider;
        LOG.info("Created GcsEventsSource");
    }

    @Override
    protected Pair<Option<Dataset<Row>>, Checkpoint> fetchNextBatch(Option<Checkpoint> lastCheckpoint, long sourceLimit) {
        MessageBatch messageBatch;
        LOG.info("fetchNextBatch(): Input checkpoint: " + lastCheckpoint);
        try {
            messageBatch = this.fetchFileMetadata();
        }
        catch (HoodieException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HoodieReadFromSourceException("Failed to fetch file metadata from GCS events source", e);
        }
        if (messageBatch.isEmpty()) {
            LOG.info("No new data. Returning empty batch with checkpoint value: " + CHECKPOINT_VALUE_ZERO);
            return Pair.of((Object)Option.empty(), (Object)CHECKPOINT_VALUE_ZERO);
        }
        Dataset eventRecords = this.sparkSession.createDataset(messageBatch.getMessages(), Encoders.STRING());
        LOG.info("Returning checkpoint value: " + CHECKPOINT_VALUE_ZERO);
        StructType sourceSchema = UtilHelpers.getSourceSchema(this.schemaProvider);
        if (sourceSchema != null) {
            return Pair.of((Object)Option.of((Object)this.sparkSession.read().schema(sourceSchema).json(eventRecords)), (Object)CHECKPOINT_VALUE_ZERO);
        }
        return Pair.of((Object)Option.of((Object)this.sparkSession.read().json(eventRecords)), (Object)CHECKPOINT_VALUE_ZERO);
    }

    @Override
    public void onCommit(String lastCkptStr) {
        LOG.info("onCommit(): Checkpoint: " + lastCkptStr);
        if (this.ackMessages) {
            this.ackOutstandingMessages();
        } else {
            LOG.warn("Not acknowledging messages. Can result in repeated redeliveries.");
        }
    }

    MessageBatch fetchFileMetadata() {
        List<ReceivedMessage> receivedMessages = this.pubsubMessagesFetcher.fetchMessages();
        return this.processMessages(receivedMessages);
    }

    private MessageBatch processMessages(List<ReceivedMessage> receivedMessages) {
        ArrayList<String> messages = new ArrayList<String>();
        long skippedMsgCount = 0L;
        for (ReceivedMessage received : receivedMessages) {
            MetadataMessage message = new MetadataMessage(received.getMessage());
            String msgStr = message.toStringUtf8();
            this.logDetails(message, msgStr);
            this.messagesToAck.add(received.getAckId());
            MessageValidity messageValidity = message.shouldBeProcessed();
            if (messageValidity.getDecision() == MessageValidity.ProcessingDecision.DO_SKIP) {
                LOG.debug("Skipping message: {}", messageValidity.getDescription());
                ++skippedMsgCount;
                continue;
            }
            messages.add(msgStr);
        }
        LOG.info("Messages received: {}, toBeProcessed: {}, skipped: {}", new Object[]{receivedMessages.size(), messages.size(), skippedMsgCount});
        return new MessageBatch(messages);
    }

    private void ackOutstandingMessages() {
        if (this.messagesToAck.isEmpty()) {
            return;
        }
        try {
            this.pubsubMessagesFetcher.sendAcks(this.messagesToAck);
            this.messagesToAck.clear();
        }
        catch (IOException e) {
            throw new HoodieReadFromSourceException("Error when acknowledging messages from Pubsub", e);
        }
    }

    private void logDetails(MetadataMessage message, String msgStr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("eventType: {}, objectId: {}", (Object)message.getEventType(), (Object)message.getObjectId());
            LOG.debug("msg: " + msgStr);
        }
    }
}

