/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class HoodieRetryingKafkaConsumer
extends KafkaConsumer {
    private final long maxRetryIntervalMs;
    private final int maxRetryCount;
    private final long initialRetryIntervalMs;
    private final String retryExceptionsList;

    public HoodieRetryingKafkaConsumer(TypedProperties config, Map<String, Object> kafkaParams) {
        super(kafkaParams);
        this.maxRetryIntervalMs = config.getLong(KafkaSourceConfig.MAX_RETRY_INTERVAL_MS.key(), ((Long)KafkaSourceConfig.MAX_RETRY_INTERVAL_MS.defaultValue()).longValue());
        this.maxRetryCount = config.getInteger(KafkaSourceConfig.MAX_RETRY_COUNT.key(), ((Integer)KafkaSourceConfig.MAX_RETRY_COUNT.defaultValue()).intValue());
        this.initialRetryIntervalMs = config.getLong(KafkaSourceConfig.INITIAL_RETRY_INTERVAL_MS.key(), ((Long)KafkaSourceConfig.INITIAL_RETRY_INTERVAL_MS.defaultValue()).longValue());
        this.retryExceptionsList = config.getString(KafkaSourceConfig.RETRY_EXCEPTIONS.key(), (String)KafkaSourceConfig.RETRY_EXCEPTIONS.defaultValue());
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection partitions) {
        return (Map)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.beginningOffsets(partitions));
    }

    public Map<TopicPartition, Long> endOffsets(Collection partitions) {
        return (Map)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.endOffsets(partitions));
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return (List)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.partitionsFor(topic));
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map timestampsToSearch) {
        return (Map)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.offsetsForTimes(timestampsToSearch));
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return (Map)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.listTopics());
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return (OffsetAndMetadata)new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start((RetryHelper.CheckedFunction & Serializable)() -> super.committed(partition));
    }
}

