/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.avro.processors.DateLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DecimalLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DurationLogicalTypeProcessor;
import org.apache.hudi.avro.processors.EnumTypeProcessor;
import org.apache.hudi.avro.processors.FixedTypeProcessor;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimestampMicroLogicalTypeProcessor;
import org.apache.hudi.avro.processors.TimestampMilliLogicalTypeProcessor;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.exception.HoodieJsonToRowConversionException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import scala.collection.JavaConverters;

public class MercifulJsonToRowConverter
extends MercifulJsonConverter {
    public MercifulJsonToRowConverter(boolean shouldSanitize, String invalidCharMask) {
        this(new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS), shouldSanitize, invalidCharMask);
    }

    public MercifulJsonToRowConverter(ObjectMapper mapper, boolean shouldSanitize, String invalidCharMask) {
        super(mapper, shouldSanitize, invalidCharMask);
    }

    public Row convertToRow(String json, Schema schema) {
        try {
            Map jsonObjectMap = (Map)this.mapper.readValue(json, Map.class);
            return this.convertJsonToRow(jsonObjectMap, schema);
        }
        catch (IOException | HoodieException e) {
            throw new HoodieJsonToRowConversionException("Failed to convert json to row", e);
        }
    }

    private Row convertJsonToRow(Map<String, Object> inputJson, Schema schema) {
        List fields = schema.getFields();
        ArrayList<Object> values = new ArrayList<Object>(Collections.nCopies(fields.size(), null));
        for (Schema.Field f : fields) {
            Object val = this.shouldSanitize ? MercifulJsonToRowConverter.getFieldFromJson((Schema.Field)f, inputJson, (String)schema.getFullName(), (String)this.invalidCharMask) : inputJson.get(f.name());
            if (val == null) continue;
            values.set(f.pos(), this.convertJsonField(val, f.name(), f.schema()));
        }
        return RowFactory.create((Object[])values.toArray());
    }

    protected JsonFieldProcessor generateDecimalLogicalTypeHandler() {
        return new DecimalToRowLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateDateLogicalTypeHandler() {
        return new DateToRowLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateDurationLogicalTypeHandler() {
        return new DurationToRowLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateBytesTypeHandler() {
        return new JsonFieldProcessor(){

            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of((Object)true, (Object)value.toString().getBytes());
            }
        };
    }

    protected JsonFieldProcessor generateFixedTypeHandler() {
        return new FixedToRowTypeProcessor();
    }

    protected JsonFieldProcessor generateEnumTypeHandler() {
        return new EnumToRowTypeProcessor();
    }

    protected JsonFieldProcessor generateRecordTypeHandler() {
        return new JsonFieldProcessor(){

            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of((Object)true, (Object)MercifulJsonToRowConverter.this.convertJsonToRow((Map)value, schema));
            }
        };
    }

    protected JsonFieldProcessor generateTimestampMilliLogicalTypeHandler() {
        return new TimestampMilliToRowLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateTimestampMicroLogicalTypeHandler() {
        return new TimestampMicroToRowLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateArrayTypeHandler() {
        return new JsonFieldProcessor(){

            private List<Object> convertToJavaObject(Object value, String name, Schema schema) {
                Schema elementSchema = schema.getElementType();
                ArrayList<Object> listRes = new ArrayList<Object>();
                for (Object v : (List)value) {
                    listRes.add(MercifulJsonToRowConverter.this.convertJsonField(v, name, elementSchema));
                }
                return listRes;
            }

            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of((Object)true, (Object)this.convertToJavaObject(value, name, schema).toArray());
            }
        };
    }

    protected JsonFieldProcessor generateMapTypeHandler() {
        return new JsonFieldProcessor(){

            public Map<String, Object> convertToJavaObject(Object value, String name, Schema schema) {
                Schema valueSchema = schema.getValueType();
                HashMap<String, Object> mapRes = new HashMap<String, Object>();
                for (Map.Entry v : ((Map)value).entrySet()) {
                    mapRes.put((String)v.getKey(), MercifulJsonToRowConverter.this.convertJsonField(v.getValue(), name, valueSchema));
                }
                return mapRes;
            }

            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of((Object)true, (Object)JavaConverters.mapAsScalaMapConverter(this.convertToJavaObject(value, name, schema)).asScala());
            }
        };
    }

    private static class TimestampMicroToRowLogicalTypeProcessor
    extends TimestampMicroLogicalTypeProcessor {
        private TimestampMicroToRowLogicalTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            Pair result = this.convertCommon((Parser)new Parser.LongParser(){

                public Pair<Boolean, Object> handleStringValue(String value) {
                    return this.convertDateTime(value, null, time -> Instant.EPOCH.until((Temporal)time, ChronoField.MICRO_OF_SECOND.getBaseUnit()));
                }
            }, value, schema);
            if (((Boolean)result.getLeft()).booleanValue()) {
                return Pair.of((Object)true, (Object)new Timestamp((Long)result.getRight() / 1000L));
            }
            return Pair.of((Object)false, null);
        }
    }

    private static class TimestampMilliToRowLogicalTypeProcessor
    extends TimestampMilliLogicalTypeProcessor {
        private TimestampMilliToRowLogicalTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            Pair result = this.convertCommon((Parser)new Parser.LongParser(){

                public Pair<Boolean, Object> handleStringValue(String value) {
                    return this.convertDateTime(value, null, time -> Instant.EPOCH.until((Temporal)time, ChronoField.MILLI_OF_SECOND.getBaseUnit()));
                }
            }, value, schema);
            if (((Boolean)result.getLeft()).booleanValue()) {
                return Pair.of((Object)true, (Object)new Timestamp((Long)result.getRight()));
            }
            return Pair.of((Object)false, null);
        }
    }

    private static class EnumToRowTypeProcessor
    extends EnumTypeProcessor {
        private EnumToRowTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return Pair.of((Object)true, (Object)this.convertToJavaObject(value, name, schema));
        }
    }

    private static class FixedToRowTypeProcessor
    extends FixedTypeProcessor {
        private FixedToRowTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return Pair.of((Object)true, (Object)this.convertToJavaObject(value, name, schema));
        }
    }

    private static class DateToRowLogicalTypeProcessor
    extends DateLogicalTypeProcessor {
        private DateToRowLogicalTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return this.convertCommon((Parser)new Parser.DateParser(), value, schema);
        }
    }

    private static class DurationToRowLogicalTypeProcessor
    extends DurationLogicalTypeProcessor {
        private DurationToRowLogicalTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            throw new HoodieJsonToRowConversionException("Duration type is not supported in Row object");
        }
    }

    private class DecimalToRowLogicalTypeProcessor
    extends DecimalLogicalTypeProcessor {
        private DecimalToRowLogicalTypeProcessor() {
        }

        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            JsonFieldProcessor processor;
            Pair fixedTypeResult;
            if (!DecimalToRowLogicalTypeProcessor.isValidDecimalTypeConfig((Schema)schema)) {
                return Pair.of((Object)false, null);
            }
            if (schema.getType() == Schema.Type.FIXED && value instanceof List && ((Boolean)(fixedTypeResult = (processor = MercifulJsonToRowConverter.this.generateFixedTypeHandler()).convert(value, name, schema)).getLeft()).booleanValue()) {
                byte[] byteArray = (byte[])fixedTypeResult.getRight();
                GenericData.Fixed fixedValue = new GenericData.Fixed(schema, byteArray);
                return Pair.of((Object)true, (Object)new Conversions.DecimalConversion().fromFixed((GenericFixed)fixedValue, schema, schema.getLogicalType()));
            }
            Pair parseResult = DecimalToRowLogicalTypeProcessor.parseObjectToBigDecimal((Object)value, (Schema)schema);
            return Pair.of((Object)parseResult.getLeft(), (Object)parseResult.getRight());
        }
    }
}

