/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import com.codahale.metrics.Timer;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;

public class HoodieStreamerMetrics
extends HoodieIngestionMetrics {
    private Metrics metrics;
    private String overallTimerName;
    private String hiveSyncTimerName;
    private String metaSyncTimerName;
    private String errorTableWriteTimerName;
    private transient Timer overallTimer;
    private transient Timer hiveSyncTimer;
    private transient Timer metaSyncTimer;
    private transient Timer errorTableWriteTimer;

    public HoodieStreamerMetrics(HoodieWriteConfig writeConfig, HoodieStorage storage) {
        this(writeConfig.getMetricsConfig(), storage);
    }

    public HoodieStreamerMetrics(HoodieMetricsConfig writeConfig, HoodieStorage storage) {
        super(writeConfig, storage);
        if (writeConfig.isMetricsOn()) {
            this.metrics = Metrics.getInstance((HoodieMetricsConfig)writeConfig, (HoodieStorage)storage);
            this.overallTimerName = this.getMetricsName("deltastreamer", "timer");
            this.hiveSyncTimerName = this.getMetricsName("deltastreamer", "deltastreamerHiveSync.timer");
            this.metaSyncTimerName = this.getMetricsName("deltastreamer", "deltastreamerMetaSync.timer");
            this.errorTableWriteTimerName = this.getMetricsName("deltastreamer", "errorTableWrite.timer");
        }
    }

    @VisibleForTesting
    Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Timer.Context getOverallTimerContext() {
        if (this.writeConfig.isMetricsOn() && this.overallTimer == null) {
            this.overallTimer = this.createTimer(this.overallTimerName);
        }
        return this.overallTimer == null ? null : this.overallTimer.time();
    }

    @Override
    public Timer.Context getHiveSyncTimerContext() {
        if (this.writeConfig.isMetricsOn() && this.hiveSyncTimer == null) {
            this.hiveSyncTimer = this.createTimer(this.hiveSyncTimerName);
        }
        return this.hiveSyncTimer == null ? null : this.hiveSyncTimer.time();
    }

    @Override
    public Timer.Context getMetaSyncTimerContext() {
        if (this.writeConfig.isMetricsOn() && this.metaSyncTimer == null) {
            this.metaSyncTimer = this.createTimer(this.metaSyncTimerName);
        }
        return this.metaSyncTimer == null ? null : this.metaSyncTimer.time();
    }

    @Override
    public Timer.Context getErrorTableWriteTimerContext() {
        if (this.writeConfig.isMetricsOn() && this.errorTableWriteTimer == null) {
            this.errorTableWriteTimer = this.createTimer(this.errorTableWriteTimerName);
        }
        return this.errorTableWriteTimer == null ? null : this.errorTableWriteTimer.time();
    }

    private Timer createTimer(String name) {
        return this.writeConfig.isMetricsOn() ? this.metrics.getRegistry().timer(name) : null;
    }

    private String getMetricsName(String action, String metric) {
        return String.format("%s.%s.%s", this.writeConfig.getMetricReporterMetricsNamePrefix(), action, metric);
    }

    @Override
    public void updateStreamerMetrics(long durationInNs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "duration"), HoodieStreamerMetrics.getDurationInMs(durationInNs));
        }
    }

    @Override
    public void updateStreamerMetaSyncMetrics(String syncClassShortName, long syncNs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", syncClassShortName), HoodieStreamerMetrics.getDurationInMs(syncNs));
        }
    }

    @Override
    public void updateStreamerSyncMetrics(long syncEpochTimeInMs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "lastSync"), syncEpochTimeInMs);
        }
    }

    @Override
    public void updateErrorTableCommitDuration(long durationInNs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "errorTableCommitDuration"), HoodieStreamerMetrics.getDurationInMs(durationInNs));
        }
    }

    public void updateNumSuccessfulSyncs(long numSuccessfulSyncs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "numSuccessfulSyncs"), numSuccessfulSyncs);
        }
    }

    public void updateNumFailedSyncs(long numFailedSyncs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "numFailedSyncs"), numFailedSyncs);
        }
    }

    public void updateNumConsecutiveFailures(int numConsecutiveFailures) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "numConsecutiveFailures"), (long)numConsecutiveFailures);
        }
    }

    public void updateTotalSourceBytesAvailableForIngest(long totalSourceBytesAvailable) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "totalSourceBytesAvailable"), totalSourceBytesAvailable);
        }
    }

    public void updateTotalSyncDurationMs(long totalSyncDurationMs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "totalSyncDurationMs"), totalSyncDurationMs);
        }
    }

    public void updateActualSyncDurationMs(long actualSyncDurationMs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "actualSyncDurationMs"), actualSyncDurationMs);
        }
    }

    @Override
    public void updateStreamerHeartbeatTimestamp(long heartbeatTimestampMs) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "heartbeatTimestampMs"), heartbeatTimestampMs);
        }
    }

    @Override
    public void updateStreamerSourceDelayCount(String sourceMetricName, long sourceDelayCount) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", sourceMetricName), sourceDelayCount);
        }
    }

    @Override
    public void updateStreamerSourceNewMessageCount(String sourceMetricName, long sourceNewMessageCount) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", sourceMetricName), sourceNewMessageCount);
        }
    }

    @Override
    public void updateStreamerSourceParallelism(int sourceParallelism) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "sourceParallelism"), (long)sourceParallelism);
        }
    }

    @Override
    public void updateStreamerSourceBytesToBeIngestedInSyncRound(long sourceBytesToBeIngested) {
        if (this.writeConfig.isMetricsOn()) {
            this.metrics.registerGauge(this.getMetricsName("deltastreamer", "sourceBytesToBeIngestedInSyncRound"), sourceBytesToBeIngested);
        }
    }

    @Override
    public void shutdown() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    private static long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }
}

