/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.testutils.HiveTestUtil;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.utilities.HiveIncrementalPuller;
import org.apache.hudi.utilities.exception.HoodieIncrementalPullSQLException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestHiveIncrementalPuller {
    private final HiveIncrementalPuller.Config config = new HiveIncrementalPuller.Config();
    @TempDir
    Path tempDir;

    @AfterAll
    public static void cleanUpClass() throws Exception {
        HiveTestUtil.shutdown();
    }

    @BeforeEach
    public void setUp() throws Exception {
        HiveTestUtil.setUp((Option)Option.empty(), (boolean)true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        HiveTestUtil.clear();
    }

    @Test
    public void testInitHiveIncrementalPuller() {
        Assertions.assertDoesNotThrow(() -> new HiveIncrementalPuller(this.config), (String)"Unexpected exception while initializing HiveIncrementalPuller.");
    }

    private HiveIncrementalPuller.Config getHivePullerConfig(String incrementalSql) throws IOException {
        this.config.hiveJDBCUrl = HiveTestUtil.hiveSyncProps.getString(HiveSyncConfigHolder.HIVE_URL.key());
        this.config.hiveUsername = HiveTestUtil.hiveSyncProps.getString(HiveSyncConfigHolder.HIVE_USER.key());
        this.config.hivePassword = HiveTestUtil.hiveSyncProps.getString(HiveSyncConfigHolder.HIVE_PASS.key());
        this.config.hoodieTmpDir = this.tempDir.resolve("hivePullerTest").toAbsolutePath().toString();
        this.config.sourceDb = HiveTestUtil.hiveSyncProps.getString(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key());
        this.config.sourceTable = HiveTestUtil.hiveSyncProps.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME.key());
        this.config.targetDb = "tgtdb";
        this.config.targetTable = "test2";
        this.config.tmpDb = "tmp_db";
        this.config.fromCommitTime = "100";
        this.createIncrementalSqlFile(incrementalSql, this.config);
        return this.config;
    }

    private void createIncrementalSqlFile(String text, HiveIncrementalPuller.Config cfg) throws IOException {
        Path path = Paths.get(cfg.hoodieTmpDir + "/incremental_pull.txt", new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.createFile(path, new FileAttribute[0]);
        try (FileWriter fr = new FileWriter(new File(path.toUri()));){
            fr.write(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cfg.incrementalSQLFile = path.toString();
    }

    private void createSourceTable() throws IOException, URISyntaxException {
        String instantTime = "101";
        HiveTestUtil.createCOWTable((String)instantTime, (int)5, (boolean)true);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), "jdbc");
        try (HiveSyncTool tool = new HiveSyncTool((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());){
            tool.syncHoodieTable();
        }
    }

    private void createTargetTable() throws IOException, URISyntaxException {
        String instantTime = "100";
        String targetBasePath = this.tempDir.resolve("target_table").toAbsolutePath().toString();
        HiveTestUtil.createCOWTable((String)instantTime, (int)5, (boolean)true, (String)targetBasePath, (String)"tgtdb", (String)"test2");
        try (HiveSyncTool tool = new HiveSyncTool((Properties)this.getTargetHiveSyncConfig(targetBasePath), (Configuration)HiveTestUtil.getHiveConf());){
            tool.syncHoodieTable();
        }
    }

    private TypedProperties getTargetHiveSyncConfig(String basePath) {
        TypedProperties targetHiveSyncProps = TypedProperties.copy((Properties)HiveTestUtil.hiveSyncProps);
        targetHiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "tgtdb");
        targetHiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "test2");
        targetHiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), basePath);
        targetHiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), "jdbc");
        return targetHiveSyncProps;
    }

    private TypedProperties getAssertionSyncConfig(String databaseName) {
        TypedProperties assertHiveSyncProps = TypedProperties.copy((Properties)HiveTestUtil.hiveSyncProps);
        assertHiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), databaseName);
        return assertHiveSyncProps;
    }

    private void createTables() throws IOException, URISyntaxException {
        this.createSourceTable();
        this.createTargetTable();
    }

    @Test
    public void testPullerWithoutIncrementalClause() throws IOException, URISyntaxException {
        this.createTables();
        HiveIncrementalPuller puller = new HiveIncrementalPuller(this.getHivePullerConfig("select name from testdb.test1"));
        Exception e = (Exception)Assertions.assertThrows(HoodieIncrementalPullSQLException.class, () -> ((HiveIncrementalPuller)puller).saveDelta(), (String)"Should fail when incremental clause not provided!");
        Assertions.assertTrue((boolean)e.getMessage().contains("Incremental SQL does not have clause `_hoodie_commit_time` > '%s', which means its not pulling incrementally"));
    }

    @Test
    public void testPullerWithoutSourceInSql() throws IOException, URISyntaxException {
        this.createTables();
        HiveIncrementalPuller puller = new HiveIncrementalPuller(this.getHivePullerConfig("select name from tgtdb.test2 where `_hoodie_commit_time` > '%s'"));
        Exception e = (Exception)Assertions.assertThrows(HoodieIncrementalPullSQLException.class, () -> ((HiveIncrementalPuller)puller).saveDelta(), (String)"Should fail when source db and table names not provided!");
        Assertions.assertTrue((boolean)e.getMessage().contains("Incremental SQL does not have testdb.test1"));
    }

    @Test
    @Disabled(value="Disable due to hive not support avro 1.10.2.")
    public void testPuller() throws IOException, URISyntaxException {
        this.createTables();
        HiveIncrementalPuller.Config cfg = this.getHivePullerConfig("select name from testdb.test1 where `_hoodie_commit_time` > '%s'");
        HoodieHiveSyncClient hiveClient = new HoodieHiveSyncClient(new HiveSyncConfig((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf()), (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        hiveClient.createDatabase(cfg.tmpDb);
        HiveIncrementalPuller puller = new HiveIncrementalPuller(cfg);
        puller.saveDelta();
        HoodieHiveSyncClient assertingClient = new HoodieHiveSyncClient(new HiveSyncConfig((Properties)this.getAssertionSyncConfig(cfg.tmpDb), (Configuration)HiveTestUtil.getHiveConf()), (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        String tmpTable = cfg.targetTable + "__" + cfg.sourceTable;
        Assertions.assertTrue((boolean)assertingClient.tableExists(tmpTable));
    }
}

