/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jodd.io.FileUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerators;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TestStringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.hudi.utilities.HoodieMetadataTableValidator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestHoodieMetadataTableValidator
extends HoodieSparkClientTestBase {
    private static final Random RANDOM = new Random();
    private final int logDetailMaxLength;

    public TestHoodieMetadataTableValidator() {
        this.logDetailMaxLength = new HoodieMetadataTableValidator.Config().logDetailMaxLength;
    }

    private static Stream<Arguments> lastNFileSlicesTestArgs() {
        return Stream.of(-1, 1, 3, 4, 5).flatMap(i -> Stream.of(Arguments.of((Object[])new Object[]{i, true}), Arguments.of((Object[])new Object[]{i, false})));
    }

    private static Stream<Arguments> viewStorageArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, false}), Arguments.of((Object[])new Object[]{FileSystemViewStorageType.MEMORY.name(), FileSystemViewStorageType.MEMORY.name(), true}), Arguments.of((Object[])new Object[]{FileSystemViewStorageType.SPILLABLE_DISK.name(), FileSystemViewStorageType.SPILLABLE_DISK.name(), false}), Arguments.of((Object[])new Object[]{FileSystemViewStorageType.MEMORY.name(), FileSystemViewStorageType.SPILLABLE_DISK.name(), true}));
    }

    @Test
    public void testValidationWithoutDataTable() throws IOException {
        this.storage.deleteDirectory(this.metaClient.getBasePath());
        this.validateSecondaryIndex();
    }

    @Test
    public void testAggregateColumnStats() {
        HoodieColumnRangeMetadata fileColumn1Range1 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)"col1", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5), (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieColumnRangeMetadata fileColumn1Range2 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)"col1", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10), (long)5L, (long)10L, (long)100L, (long)200L);
        HoodieColumnRangeMetadata fileColumn2Range1 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)"col2", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        HoodieColumnRangeMetadata fileColumn2Range2 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)"col2", (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9), (long)4L, (long)5L, (long)80L, (long)150L);
        ArrayList<HoodieColumnRangeMetadata> colStats = new ArrayList<HoodieColumnRangeMetadata>();
        colStats.add(fileColumn1Range1);
        colStats.add(fileColumn1Range2);
        colStats.add(fileColumn2Range1);
        colStats.add(fileColumn2Range2);
        int col1Count = 0;
        int col2Count = 0;
        TreeSet aggregatedStats = HoodieMetadataTableValidator.aggregateColumnStats((String)"path/to/file1", colStats);
        Assertions.assertEquals((int)2, (int)aggregatedStats.size());
        for (HoodieColumnRangeMetadata stat : aggregatedStats) {
            if (stat.getColumnName().equals("col1")) {
                Assertions.assertEquals((Object)1, (Object)stat.getMinValue());
                Assertions.assertEquals((Object)10, (Object)stat.getMaxValue());
                ++col1Count;
            } else if (stat.getColumnName().equals("col2")) {
                Assertions.assertEquals((Object)3, (Object)stat.getMinValue());
                Assertions.assertEquals((Object)9, (Object)stat.getMaxValue());
                ++col2Count;
            }
            Assertions.assertEquals((long)5L, (long)stat.getNullCount());
            Assertions.assertEquals((long)20L, (long)stat.getValueCount());
            Assertions.assertEquals((long)200L, (long)stat.getTotalSize());
            Assertions.assertEquals((long)400L, (long)stat.getTotalUncompressedSize());
        }
        Assertions.assertEquals((int)1, (int)col1Count);
        Assertions.assertEquals((int)1, (int)col2Count);
    }

    @ParameterizedTest
    @MethodSource(value={"viewStorageArgs"})
    public void testMetadataTableValidation(String viewStorageTypeForFSListing, String viewStorageTypeForMDTListing, boolean includeUncommittedLogFiles) throws Exception {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset updates = this.makeUpdateDf("001", 5).cache();
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        if (includeUncommittedLogFiles) {
            for (StoragePathInfo storagePathInfo : this.storage.listFiles(new StoragePath(this.basePath))) {
                StoragePath path = storagePathInfo.getPath();
                if (!FSUtils.isLogFile((StoragePath)path)) continue;
                String modifiedPath = path.toString().substring(0, path.toString().lastIndexOf("-") + 1) + "000";
                FileSystem fs = HadoopFSUtils.getFs((StoragePath)path, (Configuration)new Configuration(false));
                fs.copyFromLocalFile(new org.apache.hadoop.fs.Path(path.toString()), new org.apache.hadoop.fs.Path(modifiedPath));
                break;
            }
        }
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        if (viewStorageTypeForFSListing != null && viewStorageTypeForMDTListing != null) {
            config.viewStorageTypeForFSListing = viewStorageTypeForFSListing;
            config.viewStorageTypeForMetadata = viewStorageTypeForMDTListing;
        }
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    @Test
    void missingLogFileFailsValidation() throws Exception {
        FileSystem fs = HadoopFSUtils.getFs((String)this.tempDir.toString(), (Configuration)new Configuration(false));
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Overwrite).save(this.basePath);
        String metadataPath = this.basePath + "/.hoodie/metadata";
        String backupDir = this.tempDir.resolve("backup").toString();
        org.apache.hadoop.fs.FileUtil.copy((FileSystem)fs, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(metadataPath), (FileSystem)fs, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(backupDir), (boolean)false, (Configuration)fs.getConf());
        Dataset updates = this.makeUpdateDf("001", 5).cache();
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        fs.delete(new org.apache.hadoop.fs.Path(metadataPath), true);
        org.apache.hadoop.fs.FileUtil.copy((FileSystem)fs, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(backupDir), (FileSystem)fs, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(metadataPath), (boolean)true, (Configuration)fs.getConf());
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        config.ignoreFailed = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertFalse((boolean)validator.run());
        Assertions.assertTrue((boolean)validator.hasValidationFailure());
        Assertions.assertFalse((boolean)validator.getThrowables().isEmpty());
    }

    @Test
    public void testSecondaryIndexValidation() throws IOException {
        this.storage.deleteDirectory(this.metaClient.getBasePath());
        this.sparkSession.sql("create table tbl (ts bigint, record_key_col string, not_record_key_col string, partition_key_col string ) using hudi options (primaryKey = 'record_key_col', type = 'mor', hoodie.metadata.enable = 'true', hoodie.metadata.record.index.enable = 'true', hoodie.datasource.write.recordkey.field = 'record_key_col', hoodie.enable.data.skipping = 'true', hoodie.datasource.write.precombine.field = 'ts', hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.OverwriteWithLatestAvroPayload') partitioned by(partition_key_col) location '" + this.basePath + "'");
        Dataset<Row> rows = this.getRowDataset(1, "row1", "abc", "p1");
        rows.write().mode(SaveMode.Append).save(this.basePath);
        rows = this.getRowDataset(2, "row2", "ghi", "p2");
        rows.write().mode(SaveMode.Append).save(this.basePath);
        rows = this.getRowDataset(3, "row3", "def", "p2");
        rows.write().format("hudi").mode(SaveMode.Append).save(this.basePath);
        this.sparkSession.sql("create index idx_not_record_key_col on tbl (not_record_key_col)");
        this.validateSecondaryIndex();
        rows = this.getRowDataset(1, "row1", "cde", "p1");
        rows.write().format("hudi").option("hoodie.metadata.enable", "true").option("hoodie.metadata.record.index.enable", "true").option("hoodie.metadata.index.column.stats.enable", "false").mode(SaveMode.Append).save(this.basePath);
        this.validateSecondaryIndex();
    }

    @Test
    public void testGetFSSecondaryKeyToRecordKeys() throws IOException {
        this.storage.deleteDirectory(this.metaClient.getBasePath());
        this.sparkSession.sql("create table tbl (ts bigint, record_key_col string, not_record_key_col string, partition_key_col string ) using hudi options (primaryKey = 'record_key_col', type = 'mor', hoodie.metadata.enable = 'true', hoodie.metadata.record.index.enable = 'true', hoodie.datasource.write.recordkey.field = 'record_key_col', hoodie.enable.data.skipping = 'true', hoodie.datasource.write.precombine.field = 'ts') partitioned by(partition_key_col) location '" + this.basePath + "'");
        Dataset<Row> rows = this.getRowDataset(1, "row1", "abc", "p1");
        rows.write().format("hudi").mode(SaveMode.Append).save(this.basePath);
        rows = this.getRowDataset(2, "row2", "cde", "p2");
        rows.write().format("hudi").mode(SaveMode.Append).save(this.basePath);
        rows = this.getRowDataset(3, "row3", "def", "p2");
        rows.write().format("hudi").mode(SaveMode.Append).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        config.ignoreFailed = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        int i = 1;
        for (String secKey : new String[]{"abc", "cde", "def"}) {
            String recKey = "row" + i++;
            Set recKeys = (Set)validator.getFSSecondaryKeyToRecordKeys(new HoodieSparkEngineContext(this.jsc, this.sqlContext), this.basePath, ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).requestedTime(), "not_record_key_col", Collections.singletonList(secKey)).get(secKey);
            Assertions.assertEquals(Collections.singleton(recKey), (Object)recKeys);
        }
    }

    private Dataset<Row> getRowDataset(Object ... rowValues) {
        List<Row> values = Collections.singletonList(RowFactory.create((Object[])rowValues));
        Dataset rows = this.sparkSession.createDataFrame(values, new StructType().add(new StructField("ts", DataTypes.IntegerType, true, Metadata.empty())).add(new StructField("record_key_col", DataTypes.StringType, true, Metadata.empty())).add(new StructField("not_record_key_col", DataTypes.StringType, true, Metadata.empty())).add(new StructField("partition_key_col", DataTypes.StringType, true, Metadata.empty())));
        return rows;
    }

    @ParameterizedTest
    @ValueSource(strings={"MERGE_ON_READ", "COPY_ON_WRITE"})
    public void testColumnStatsValidation(String tableType) {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), tableType);
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        writeOptions.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "true");
        Dataset<Row> inserts = this.makeInsertDf("000", 5);
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).mode(SaveMode.Overwrite).save(this.basePath);
        this.validateColumnStats();
        Dataset<Row> updates = this.makeUpdateDf("001", 5);
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).mode(SaveMode.Append).save(this.basePath);
        this.validateColumnStats();
    }

    @ParameterizedTest
    @ValueSource(strings={"MERGE_ON_READ", "COPY_ON_WRITE"})
    public void testPartitionStatsValidation(String tableType) {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), tableType);
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        writeOptions.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "true");
        Dataset<Row> inserts = this.makeInsertDf("000", 5);
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        this.validatePartitionStats();
        Dataset<Row> updates = this.makeUpdateDf("001", 5);
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key(), "true").mode(SaveMode.Append).save(this.basePath);
        this.validatePartitionStats();
    }

    private void validateColumnStats() {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = false;
        config.validateAllFileGroups = false;
        config.validateAllColumnStats = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    private void validatePartitionStats() {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = false;
        config.validateAllFileGroups = false;
        config.validatePartitionStats = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    private void validateSecondaryIndex() {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = false;
        config.validateAllFileGroups = false;
        config.validateSecondaryIndex = true;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAdditionalPartitionsinMDT(boolean testFailureCase) throws IOException, InterruptedException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).mode(SaveMode.Overwrite).save(this.basePath);
        String partition1 = "PARTITION1";
        String partition2 = "PARTITION2";
        String partition3 = "PARTITION3";
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieHadoopStorage.class);
        Mockito.when((Object)metaClient.getStorage()).thenReturn((Object)storage);
        Mockito.when((Object)storage.exists(new StoragePath(this.basePath + "/" + partition1))).thenReturn((Object)true);
        Mockito.when((Object)storage.exists(new StoragePath(this.basePath + "/" + partition2))).thenReturn((Object)true);
        Mockito.when((Object)storage.exists(new StoragePath(this.basePath + "/" + partition3))).thenReturn((Object)true);
        List<String> mdtPartitions = Arrays.asList(partition1, partition2, partition3);
        validator.setMetadataPartitionsToReturn(mdtPartitions);
        List<String> fsPartitions = Arrays.asList(partition1, partition2);
        validator.setFsPartitionsToReturn(fsPartitions);
        HoodieTimeline commitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        HoodieTimeline completedTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)metaClient.getCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.filterCompletedInstants()).thenReturn((Object)completedTimeline);
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)HoodieTimeGeneratorConfig.defaultConfig((String)this.basePath), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration()));
        StoragePath baseStoragePath = new StoragePath(this.basePath);
        if (testFailureCase) {
            String partition3CreationTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
            Thread.sleep(100L);
            String lastIntantCreationTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
            HoodieInstant lastInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", lastIntantCreationTime);
            Mockito.when((Object)completedTimeline.lastInstant()).thenReturn((Object)Option.of((Object)lastInstant));
            validator.setPartitionCreationTime((Option<String>)Option.of((Object)partition3CreationTime));
            Assertions.assertThrows(HoodieValidationException.class, () -> validator.validatePartitions(engineContext, baseStoragePath, metaClient));
        } else {
            HoodieInstant lastInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator));
            Mockito.when((Object)completedTimeline.lastInstant()).thenReturn((Object)Option.of((Object)lastInstant));
            Thread.sleep(100L);
            validator.setPartitionCreationTime((Option<String>)Option.of((Object)TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator)));
            Assertions.assertEquals(mdtPartitions, (Object)validator.validatePartitions(engineContext, baseStoragePath, metaClient));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"lastNFileSlicesTestArgs"})
    public void testAdditionalFilesInMetadata(Integer lastNFileSlices, boolean ignoreFailed) throws IOException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "2");
        Dataset inserts = this.makeInsertDf("000", 10).cache();
        inserts.write().format("hudi").options(writeOptions).mode(SaveMode.Overwrite).save(this.basePath);
        for (int i = 0; i < 6; ++i) {
            inserts.write().format("hudi").options(writeOptions).mode(SaveMode.Append).save(this.basePath);
        }
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        validator.run();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(engineContext.getStorageConf()).build();
        Path tempFolderNioPath = this.tempDir.resolve("temp_folder");
        Files.createDirectories(tempFolderNioPath, new FileAttribute[0]);
        String tempFolder = tempFolderNioPath.toAbsolutePath().toString();
        org.apache.hadoop.fs.Path tempFolderPath = new org.apache.hadoop.fs.Path(tempFolder);
        HoodieTableFileSystemView fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)this.context, (HoodieTableMetaClient)metaClient, (HoodieTimeline)metaClient.getActiveTimeline().filterCompletedAndCompactionInstants(), (boolean)false);
        FileSlice latestFileSlice = (FileSlice)fsView.getLatestFileSlices("").filter(fileSlice -> fileSlice.getLogFiles().count() > 0L).collect(Collectors.toList()).get(0);
        HoodieLogFile latestLogFile = (HoodieLogFile)latestFileSlice.getLogFiles().collect(Collectors.toList()).get(0);
        FileSystem fs = HadoopFSUtils.getFs((org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(latestLogFile.getPath().toString()), (Configuration)new Configuration(false));
        fs.moveFromLocalFile(new org.apache.hadoop.fs.Path(latestLogFile.getPath().toString()), tempFolderPath);
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator localValidator = new HoodieMetadataTableValidator(this.jsc, config);
        if (ignoreFailed) {
            localValidator.run();
            Assertions.assertTrue((boolean)localValidator.hasValidationFailure());
            Assertions.assertTrue((boolean)(localValidator.getThrowables().get(0) instanceof HoodieValidationException));
        } else {
            Assertions.assertThrows(HoodieValidationException.class, () -> ((HoodieMetadataTableValidator)localValidator).run());
        }
        fs.moveFromLocalFile(new org.apache.hadoop.fs.Path(tempFolderPath + "/" + latestLogFile.getFileName()), new org.apache.hadoop.fs.Path(this.basePath));
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.ignoreFailed = ignoreFailed;
        localValidator = new HoodieMetadataTableValidator(this.jsc, config);
        localValidator.run();
        fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)this.context, (HoodieTableMetaClient)metaClient, (HoodieTimeline)metaClient.getActiveTimeline().filterCompletedAndCompactionInstants(), (boolean)false);
        HoodieFileGroup fileGroup = (HoodieFileGroup)fsView.getAllFileGroups("").collect(Collectors.toList()).get(0);
        List allFileSlices = fileGroup.getAllFileSlices().collect(Collectors.toList());
        FileSlice earliestFileSlice = (FileSlice)allFileSlices.get(allFileSlices.size() - 1);
        HoodieLogFile earliestLogFile = (HoodieLogFile)earliestFileSlice.getLogFiles().collect(Collectors.toList()).get(0);
        fs.delete(new org.apache.hadoop.fs.Path(earliestLogFile.getPath().toString()));
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator.Config finalConfig = config;
        localValidator = new HoodieMetadataTableValidator(this.jsc, finalConfig);
        if (ignoreFailed) {
            localValidator.run();
            Assertions.assertTrue((boolean)localValidator.hasValidationFailure());
            Assertions.assertTrue((boolean)(localValidator.getThrowables().get(0) instanceof HoodieValidationException));
        } else {
            Assertions.assertThrows(HoodieValidationException.class, () -> ((HoodieMetadataTableValidator)localValidator).run());
        }
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        if (lastNFileSlices != -1) {
            config.validateLastNFileSlices = lastNFileSlices;
        }
        config.ignoreFailed = ignoreFailed;
        validator = new HoodieMetadataTableValidator(this.jsc, config);
        if (lastNFileSlices != -1 && lastNFileSlices < 4) {
            validator.run();
            Assertions.assertFalse((boolean)validator.hasValidationFailure());
        } else if (ignoreFailed) {
            validator.run();
            Assertions.assertTrue((boolean)validator.hasValidationFailure());
            Assertions.assertTrue((boolean)(validator.getThrowables().get(0) instanceof HoodieValidationException));
        } else {
            Assertions.assertThrows(HoodieValidationException.class, () -> ((HoodieMetadataTableValidator)validator).run());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAdditionalPartitionsinMdtEndToEnd(boolean ignoreFailed) throws IOException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        writeOptions.put(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "2");
        Dataset inserts = this.makeInsertDf("000", 100).cache();
        inserts.write().format("hudi").options(writeOptions).mode(SaveMode.Overwrite).save(this.basePath);
        for (int i = 0; i < 6; ++i) {
            inserts.write().format("hudi").options(writeOptions).mode(SaveMode.Append).save(this.basePath);
        }
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        validator.run();
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath, (Configuration)new Configuration(false));
        fs.delete(new org.apache.hadoop.fs.Path(this.basePath + "/" + "2015/03/16"));
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator localValidator = new HoodieMetadataTableValidator(this.jsc, config);
        if (ignoreFailed) {
            localValidator.run();
            Assertions.assertTrue((boolean)localValidator.hasValidationFailure());
            Assertions.assertTrue((boolean)(localValidator.getThrowables().get(0) instanceof HoodieValidationException));
        } else {
            Assertions.assertThrows(HoodieValidationException.class, () -> ((HoodieMetadataTableValidator)localValidator).run());
        }
    }

    @Test
    void testHasCommittedLogFiles() throws IOException, InterruptedException {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getBasePath()).thenReturn((Object)new StoragePath(this.tempDir.toString()));
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)HoodieTimeGeneratorConfig.defaultConfig((String)this.basePath), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration()));
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        HashMap<String, Set<String>> committedFilesMap = new HashMap<String, Set<String>>();
        String baseInstantTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        String logInstantTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        String newInstantTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        Assertions.assertEquals((Object)Pair.of((Object)false, (Object)""), (Object)validator.hasCommittedLogFiles(this.storage, Collections.emptySet(), metaClient, committedFilesMap));
        HoodieLogFile logFile = new HoodieLogFile(new StoragePath(this.tempDir.toString(), FSUtils.makeLogFileName((String)UUID.randomUUID().toString(), (String)".log", (String)logInstantTime, (int)1, (String)"1-0-1")));
        this.storage.create(logFile.getPath()).close();
        this.prepareTimelineAndValidate(metaClient, validator, Collections.emptyList(), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)false, (Object)""));
        logFile = this.prepareLogFile(UUID.randomUUID().toString(), baseInstantTime, logInstantTime, false);
        this.prepareTimelineAndValidate(metaClient, validator, Collections.emptyList(), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)false, (Object)""));
        logFile = this.prepareLogFile(UUID.randomUUID().toString(), baseInstantTime, logInstantTime, true);
        committedFilesMap.put(logInstantTime, Collections.emptySet());
        this.prepareTimelineAndValidate(metaClient, validator, Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", logInstantTime)), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)false, (Object)""));
        committedFilesMap.put(logInstantTime, new HashSet<String>(Collections.singletonList(logFile.getPath().getName())));
        this.prepareTimelineAndValidate(metaClient, validator, Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", logInstantTime)), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)true, (Object)String.format("Log file is committed in an instant in active timeline: instantTime=%s %s", logInstantTime, logFile.getPath().toString())));
        committedFilesMap.clear();
        this.prepareTimelineAndValidate(metaClient, validator, Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", newInstantTime)), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)true, (Object)String.format("Log file is committed in an instant in archived timeline: instantTime=%s %s", logInstantTime, logFile.getPath().toString())));
        this.prepareTimelineAndValidate(metaClient, validator, Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", logInstantTime)), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)false, (Object)""));
        this.prepareTimelineAndValidate(metaClient, validator, Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", baseInstantTime)), logFile, committedFilesMap, (Pair<Boolean, String>)Pair.of((Object)false, (Object)""));
    }

    private void prepareTimelineAndValidate(HoodieTableMetaClient metaClient, MockHoodieMetadataTableValidator validator, List<HoodieInstant> instantList, HoodieLogFile logFile, Map<String, Set<String>> committedFilesMap, Pair<Boolean, String> expected) {
        ActiveTimelineV2 timeline = new ActiveTimelineV2();
        timeline.setInstants(instantList);
        Mockito.when((Object)metaClient.getCommitsTimeline()).thenReturn((Object)timeline);
        Assertions.assertEquals(expected, (Object)validator.hasCommittedLogFiles(this.storage, new HashSet<String>(Collections.singletonList(logFile.getPath().toString())), metaClient, committedFilesMap));
    }

    private HoodieLogFile prepareLogFile(String fileId, String baseInstantTime, String instantTime, boolean writeDataBlock) throws IOException, InterruptedException {
        try (HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(new StoragePath(this.tempDir.toString())).withFileExtension(".log").withFileId(fileId).withInstantTime(instantTime).withStorage(this.storage).withSizeThreshold(Long.MAX_VALUE).build();){
            EnumMap<HoodieLogBlock.HeaderMetadataType, String> header = new EnumMap<HoodieLogBlock.HeaderMetadataType, String>(HoodieLogBlock.HeaderMetadataType.class);
            if (writeDataBlock) {
                header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, instantTime);
                header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, SchemaTestUtil.getSimpleSchema().toString());
                writer.appendBlock((HoodieLogBlock)new HoodieAvroDataBlock(Collections.emptyList(), header, HoodieRecord.RECORD_KEY_METADATA_FIELD));
            } else {
                header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, instantTime);
                header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, baseInstantTime);
                header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK.ordinal()));
                writer.appendBlock((HoodieLogBlock)new HoodieCommandBlock(header));
            }
            HoodieLogFile hoodieLogFile = writer.getLogFile();
            return hoodieLogFile;
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testValidate(boolean oversizeList) {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        int listSize = oversizeList ? 5000 : 100;
        String partition = "partition10";
        String label = "metadata item";
        Pair<List<HoodieBaseFile>, List<HoodieBaseFile>> filelistPair = this.generateTwoEqualBaseFileList(listSize);
        this.runValidateAndVerify(validator, oversizeList, partition, label, (List)filelistPair.getLeft(), (List)filelistPair.getRight(), this.generateRandomBaseFile().getLeft());
        Pair<List<HoodieColumnRangeMetadata<Comparable>>, List<HoodieColumnRangeMetadata<Comparable>>> statsListPair = this.generateTwoEqualColumnStatsList(listSize);
        this.runValidateAndVerify(validator, oversizeList, partition, label, (List)statsListPair.getLeft(), (List)statsListPair.getRight(), this.generateRandomColumnStats().getLeft());
    }

    private <T> void runValidateAndVerify(HoodieMetadataTableValidator validator, boolean oversizeList, String partition, String label, List<T> listMdt, List<T> listFs, T newItem) {
        Assertions.assertEquals((Object)oversizeList, (Object)(StringUtils.toStringWithThreshold(listMdt, (int)Integer.MAX_VALUE).length() > this.logDetailMaxLength ? 1 : 0));
        Assertions.assertEquals((Object)oversizeList, (Object)(StringUtils.toStringWithThreshold(listFs, (int)Integer.MAX_VALUE).length() > this.logDetailMaxLength ? 1 : 0));
        Assertions.assertDoesNotThrow(() -> validator.validate(listMdt, listFs, partition, label));
        listFs.add(newItem);
        Exception exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validate(listMdt, listFs, partition, label));
        Assertions.assertEquals((Object)String.format("Validation of %s for partition %s failed for table: %s. Number of %s based on the file system does not match that based on the metadata table. File system-based listing (%s): %s; MDT-based listing (%s): %s.", label, partition, this.basePath, label, listFs.size(), StringUtils.toStringWithThreshold(listFs, (int)this.logDetailMaxLength), listMdt.size(), StringUtils.toStringWithThreshold(listMdt, (int)this.logDetailMaxLength)), (Object)exception.getMessage());
        listFs.remove(listFs.size() - 1);
        int i = 35;
        listFs.set(i, newItem);
        exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validate(listMdt, listFs, partition, label));
        Assertions.assertEquals((Object)String.format("Validation of %s for partition %s failed for table: %s. %s mismatch. File slice from file system-based listing: %s; File slice from MDT-based listing: %s.", label, partition, this.basePath, label, listFs.get(i), listMdt.get(i)), (Object)exception.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testValidateFileSlices(boolean oversizeList) {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)HoodieTimeGeneratorConfig.defaultConfig((String)this.basePath), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration()));
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        int listSize = oversizeList ? 500 : 50;
        String partition = "partition10";
        String label = "metadata item";
        Pair<List<FileSlice>, List<FileSlice>> filelistPair = this.generateTwoEqualFileSliceList(listSize, timeGenerator);
        List listMdt = (List)filelistPair.getLeft();
        List listFs = (List)filelistPair.getRight();
        Assertions.assertDoesNotThrow(() -> validator.validateFileSlices(listMdt, listFs, partition, this.metaClient, label));
        listFs.add(this.generateRandomFileSlice(TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator), TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator), TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator)).getLeft());
        Assertions.assertEquals((Object)oversizeList, (Object)(StringUtils.toStringWithThreshold((List)listMdt, (int)Integer.MAX_VALUE).length() > this.logDetailMaxLength ? 1 : 0));
        Assertions.assertEquals((Object)oversizeList, (Object)(StringUtils.toStringWithThreshold((List)listFs, (int)Integer.MAX_VALUE).length() > this.logDetailMaxLength ? 1 : 0));
        Exception exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validateFileSlices(listMdt, listFs, partition, this.metaClient, label));
        Assertions.assertEquals((Object)String.format("Validation of %s for partition %s failed for table: %s. Number of file slices based on the file system does not match that based on the metadata table. File system-based listing (%s file slices): %s; MDT-based listing (%s file slices): %s.", label, partition, this.basePath, listFs.size(), StringUtils.toStringWithThreshold((List)listFs, (int)this.logDetailMaxLength), listMdt.size(), StringUtils.toStringWithThreshold((List)listMdt, (int)this.logDetailMaxLength)), (Object)exception.getMessage());
        listFs.remove(listFs.size() - 1);
        int i = 35;
        FileSlice originalFileSlice = (FileSlice)listMdt.get(i);
        FileSlice mismatchFileSlice = new FileSlice(originalFileSlice.getFileGroupId(), TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator), (HoodieBaseFile)originalFileSlice.getBaseFile().get(), originalFileSlice.getLogFiles().collect(Collectors.toList()));
        listMdt.set(i, mismatchFileSlice);
        exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validateFileSlices(listMdt, listFs, partition, this.metaClient, label));
        Assertions.assertEquals((Object)String.format("Validation of %s for partition %s failed for table: %s. File group ID (missing a file group in MDT) or base instant time mismatches. File slice from file system-based listing: %s; File slice from MDT-based listing: %s.", label, partition, this.basePath, listFs.get(i), listMdt.get(i)), (Object)exception.getMessage());
        mismatchFileSlice = new FileSlice(originalFileSlice.getFileGroupId(), originalFileSlice.getBaseInstantTime(), (HoodieBaseFile)this.generateRandomBaseFile().getLeft(), originalFileSlice.getLogFiles().collect(Collectors.toList()));
        listMdt.set(i, mismatchFileSlice);
        exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validateFileSlices(listMdt, listFs, partition, this.metaClient, label));
        Assertions.assertEquals((Object)String.format("Validation of %s for partition %s failed for table: %s. Base files mismatch. File slice from file system-based listing: %s; File slice from MDT-based listing: %s.", label, partition, this.basePath, listFs.get(i), listMdt.get(i)), (Object)exception.getMessage());
    }

    Pair<List<HoodieBaseFile>, List<HoodieBaseFile>> generateTwoEqualBaseFileList(int size) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        IntStream.range(0, size).forEach(i -> {
            Pair<HoodieBaseFile, HoodieBaseFile> pair = this.generateRandomBaseFile();
            list1.add(pair.getLeft());
            list2.add(pair.getRight());
        });
        return Pair.of(list1.stream().sorted(new HoodieMetadataTableValidator.HoodieBaseFileComparator()).collect(Collectors.toList()), list2.stream().sorted(new HoodieMetadataTableValidator.HoodieBaseFileComparator()).collect(Collectors.toList()));
    }

    Pair<List<HoodieColumnRangeMetadata<Comparable>>, List<HoodieColumnRangeMetadata<Comparable>>> generateTwoEqualColumnStatsList(int size) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        IntStream.range(0, size).forEach(i -> {
            Pair<HoodieColumnRangeMetadata, HoodieColumnRangeMetadata> pair = this.generateRandomColumnStats();
            list1.add(pair.getLeft());
            list2.add(pair.getRight());
        });
        return Pair.of(list1.stream().sorted(new HoodieMetadataTableValidator.HoodieColumnRangeMetadataComparator()).collect(Collectors.toList()), list2.stream().sorted(new HoodieMetadataTableValidator.HoodieColumnRangeMetadataComparator()).collect(Collectors.toList()));
    }

    Pair<List<FileSlice>, List<FileSlice>> generateTwoEqualFileSliceList(int size, TimeGenerator timeGenerator) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        String baseInstantTime = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        String logInstantTime1 = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        String logInstantTime2 = TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator);
        IntStream.range(0, size).forEach(i -> {
            Pair<FileSlice, FileSlice> pair = this.generateRandomFileSlice(baseInstantTime, logInstantTime1, logInstantTime2);
            list1.add(pair.getLeft());
            list2.add(pair.getRight());
        });
        return Pair.of(list1.stream().sorted(new HoodieMetadataTableValidator.FileSliceComparator()).collect(Collectors.toList()), list2.stream().sorted(new HoodieMetadataTableValidator.FileSliceComparator()).collect(Collectors.toList()));
    }

    private Pair<HoodieBaseFile, HoodieBaseFile> generateRandomBaseFile() {
        String filePath = "/dummy/base/" + FSUtils.makeBaseFileName((String)"001", (String)"1-0-1", (String)UUID.randomUUID().toString(), (String)HoodieFileFormat.PARQUET.getFileExtension());
        return Pair.of((Object)new HoodieBaseFile(filePath), (Object)new HoodieBaseFile(new String(filePath)));
    }

    private Pair<HoodieColumnRangeMetadata, HoodieColumnRangeMetadata> generateRandomColumnStats() {
        long count = RANDOM.nextLong();
        long size = RANDOM.nextLong();
        switch (RANDOM.nextInt(3)) {
            case 0: {
                HoodieColumnRangeMetadata intMetadata = HoodieColumnRangeMetadata.create((String)TestStringUtils.generateRandomString((int)30), (String)TestStringUtils.generateRandomString((int)5), (Comparable)Integer.valueOf(RANDOM.nextInt() % 30), (Comparable)Integer.valueOf(RANDOM.nextInt() % 1000000000 + 30), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L));
                return Pair.of((Object)intMetadata, (Object)HoodieColumnRangeMetadata.create((String)new String(intMetadata.getFilePath()), (String)new String(intMetadata.getColumnName()), (Comparable)((Integer)intMetadata.getMinValue()), (Comparable)((Integer)intMetadata.getMaxValue()), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L)));
            }
            case 1: {
                HoodieColumnRangeMetadata longMetadata = HoodieColumnRangeMetadata.create((String)TestStringUtils.generateRandomString((int)30), (String)TestStringUtils.generateRandomString((int)5), (Comparable)Long.valueOf(RANDOM.nextLong() % 30L), (Comparable)Long.valueOf((long)RANDOM.nextInt() % 1000000000000000L + 30L), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L));
                return Pair.of((Object)longMetadata, (Object)HoodieColumnRangeMetadata.create((String)new String(longMetadata.getFilePath()), (String)new String(longMetadata.getColumnName()), (Comparable)((Long)longMetadata.getMinValue()), (Comparable)((Long)longMetadata.getMaxValue()), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L)));
            }
        }
        String stringValue1 = TestStringUtils.generateRandomString((int)20);
        String stringValue2 = TestStringUtils.generateRandomString((int)20);
        HoodieColumnRangeMetadata stringMetadata = HoodieColumnRangeMetadata.create((String)TestStringUtils.generateRandomString((int)30), (String)TestStringUtils.generateRandomString((int)5), (Comparable)((Object)stringValue1), (Comparable)((Object)stringValue2), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L));
        return Pair.of((Object)stringMetadata, (Object)HoodieColumnRangeMetadata.create((String)new String(stringMetadata.getFilePath()), (String)new String(stringMetadata.getColumnName()), (Comparable)((Object)new String(stringValue1)), (Comparable)((Object)new String(stringValue2)), (long)(count / 3L), (long)count, (long)size, (long)(size / 8L)));
    }

    private Pair<FileSlice, FileSlice> generateRandomFileSlice(String baseInstantTime, String logInstantTime1, String logInstantTime2) {
        String partition = "partition";
        String fileId = UUID.randomUUID().toString();
        Pair<HoodieBaseFile, HoodieBaseFile> baseFilePair = this.generateRandomBaseFile();
        ArrayList<HoodieLogFile> logFileList = new ArrayList<HoodieLogFile>();
        logFileList.add(this.generateRandomLogFile(fileId, logInstantTime1));
        logFileList.add(this.generateRandomLogFile(fileId, logInstantTime2));
        FileSlice fileSlice = new FileSlice(new HoodieFileGroupId(partition, fileId), baseInstantTime, (HoodieBaseFile)baseFilePair.getLeft(), logFileList);
        return Pair.of((Object)fileSlice, (Object)new FileSlice(new HoodieFileGroupId(partition, fileId), new String(baseInstantTime), (HoodieBaseFile)baseFilePair.getRight(), logFileList.stream().map(HoodieLogFile::new).collect(Collectors.toList())));
    }

    private HoodieLogFile generateRandomLogFile(String fileId, String instantTime) {
        return new HoodieLogFile("/dummy/base/" + FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)1, (String)"1-0-1"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRecordIndexMismatch(boolean ignoreFailed) throws IOException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "COPY_ON_WRITE");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.OPERATION().key(), "bulk_insert");
        writeOptions.put(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true");
        Dataset inserts = this.makeInsertDf("000", 50).cache();
        inserts.write().format("hudi").options(writeOptions).mode(SaveMode.Overwrite).save(this.basePath);
        for (int i = 0; i < 6; ++i) {
            this.makeInsertDf("000", (i + 1) * 100).write().format("hudi").options(writeOptions).mode(SaveMode.Append).save(this.basePath);
        }
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator validator = new HoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(engineContext.getStorageConf()).build();
        validator.run();
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        HoodieTableFileSystemView fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieTimeline)metaClient.getActiveTimeline().filterCompletedAndCompactionInstants(), (boolean)false);
        List allBaseFiles = fsView.getLatestBaseFiles("").collect(Collectors.toList());
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath, (Configuration)new Configuration(false));
        fs.copyFromLocalFile(new org.apache.hadoop.fs.Path(((HoodieBaseFile)allBaseFiles.get(0)).getStoragePath().toString()), new org.apache.hadoop.fs.Path(((HoodieBaseFile)allBaseFiles.get(1)).getStoragePath().toString()));
        config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateRecordIndexContent = true;
        config.ignoreFailed = ignoreFailed;
        HoodieMetadataTableValidator localValidator = new HoodieMetadataTableValidator(this.jsc, config);
        if (ignoreFailed) {
            localValidator.run();
            Assertions.assertTrue((boolean)localValidator.hasValidationFailure());
            Assertions.assertTrue((boolean)(localValidator.getThrowables().get(0) instanceof HoodieValidationException));
        } else {
            Assertions.assertThrows(HoodieValidationException.class, () -> ((HoodieMetadataTableValidator)localValidator).run());
        }
    }

    @Test
    public void testRliValidationFalsePositiveCase() throws IOException {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 5).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset updates = this.makeUpdateDf("001", 5).cache();
        updates.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.UPSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        Dataset inserts2 = this.makeInsertDf("002", 5).cache();
        inserts2.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).option(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true").option(HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key(), "1").option(HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key(), "1").mode(SaveMode.Append).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file://" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.jsc.hadoopConfiguration())).build();
        HoodieInstant lastInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get();
        String latestCompletedCommitMetaFile = this.basePath + "/.hoodie/timeline/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(lastInstant);
        String tempDir = this.getTempLocation();
        String destFilePath = tempDir + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(lastInstant);
        FileUtil.move((String)latestCompletedCommitMetaFile, (String)destFilePath);
        MockHoodieMetadataTableValidatorForRli validator = new MockHoodieMetadataTableValidatorForRli(this.jsc, config);
        validator.setOriginalFilePath(latestCompletedCommitMetaFile);
        validator.setDestFilePath(destFilePath);
        Assertions.assertTrue((boolean)validator.run());
        Assertions.assertFalse((boolean)validator.hasValidationFailure());
        Assertions.assertTrue((boolean)validator.getThrowables().isEmpty());
    }

    private String getTempLocation() {
        try {
            String folderName = "temp_location";
            Path tempPath = this.tempDir.resolve(folderName);
            Files.createDirectories(tempPath, new FileAttribute[0]);
            return tempPath.toAbsolutePath().toString();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected Dataset<Row> makeInsertDf(String instantTime, Integer n) {
        List records = this.dataGen.generateInserts(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
        JavaRDD rdd = this.jsc.parallelize(records);
        return this.sparkSession.read().json(rdd);
    }

    protected Dataset<Row> makeUpdateDf(String instantTime, Integer n) {
        try {
            List records = this.dataGen.generateUpdates(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
            JavaRDD rdd = this.jsc.parallelize(records);
            return this.sparkSession.read().json(rdd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void testLogDetailMaxLength() {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put(DataSourceWriteOptions.TABLE_NAME().key(), "test_table");
        writeOptions.put("hoodie.table.name", "test_table");
        writeOptions.put(DataSourceWriteOptions.TABLE_TYPE().key(), "MERGE_ON_READ");
        writeOptions.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        writeOptions.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        writeOptions.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
        Dataset inserts = this.makeInsertDf("000", 1000).cache();
        inserts.write().format("hudi").options(writeOptions).option(DataSourceWriteOptions.OPERATION().key(), WriteOperationType.BULK_INSERT.value()).mode(SaveMode.Overwrite).save(this.basePath);
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = "file:" + this.basePath;
        config.validateLatestFileSlices = true;
        config.validateAllFileGroups = true;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)HoodieTimeGeneratorConfig.defaultConfig((String)this.basePath), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration()));
        Pair<List<FileSlice>, List<FileSlice>> filelistPair = this.generateTwoEqualFileSliceList(500, timeGenerator);
        List listMdt = (List)filelistPair.getLeft();
        ArrayList<Object> listFs = new ArrayList<Object>((Collection)filelistPair.getRight());
        listFs.add(this.generateRandomFileSlice(TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator), TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator), TimelineUtils.generateInstantTime((boolean)true, (TimeGenerator)timeGenerator)).getLeft());
        MockHoodieMetadataTableValidator finalValidator = validator;
        Exception exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> finalValidator.validateFileSlices(listMdt, listFs, "partition", this.metaClient, "test"));
        Assertions.assertTrue((exception.getMessage().length() <= 201000 ? 1 : 0) != 0);
        config.logDetailMaxLength = 1000;
        MockHoodieMetadataTableValidator finalValidator1 = validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> finalValidator1.validateFileSlices(listMdt, listFs, "partition", this.metaClient, "test"));
        Assertions.assertTrue((exception.getMessage().length() <= 3000 ? 1 : 0) != 0);
        config.logDetailMaxLength = 200000;
        MockHoodieMetadataTableValidator finalValidator2 = validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        exception = (Exception)Assertions.assertThrows(HoodieValidationException.class, () -> finalValidator2.validateFileSlices(listMdt, listFs, "partition", this.metaClient, "test"));
        Assertions.assertTrue((exception.getMessage().length() <= 401000 ? 1 : 0) != 0);
    }

    @Test
    void testValidatePartitionsTruncation() throws IOException {
        int i;
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.logDetailMaxLength = 100;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieStorage fs = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        ArrayList<String> mdtPartitions = new ArrayList<String>();
        ArrayList<String> fsPartitions = new ArrayList<String>();
        for (i = 0; i < 20; ++i) {
            mdtPartitions.add("partition_" + TestStringUtils.generateRandomString((int)20));
        }
        for (i = 0; i < 15; ++i) {
            fsPartitions.add("partition_" + TestStringUtils.generateRandomString((int)20));
        }
        Mockito.when((Object)metaClient.getStorage()).thenReturn((Object)fs);
        for (String partition : mdtPartitions) {
            Mockito.when((Object)fs.exists(new StoragePath(this.basePath + "/" + partition))).thenReturn((Object)true);
        }
        HoodieTimeline commitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        HoodieTimeline completedTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)metaClient.getCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.filterCompletedInstants()).thenReturn((Object)completedTimeline);
        validator.setMetadataPartitionsToReturn(mdtPartitions);
        validator.setFsPartitionsToReturn(fsPartitions);
        HoodieValidationException exception = (HoodieValidationException)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validatePartitions(engineContext, new StoragePath(this.basePath), metaClient));
        String errorMsg = exception.getMessage();
        Assertions.assertTrue((boolean)errorMsg.contains("..."));
        Assertions.assertTrue((errorMsg.length() <= config.logDetailMaxLength * 2 + 1000 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)errorMsg.contains(String.format("Additional %d partitions from FS, but missing from MDT : ", fsPartitions.size())));
        Assertions.assertTrue((boolean)errorMsg.contains(String.format("additional %d partitions from MDT, but missing from FS listing :", mdtPartitions.size())));
    }

    @Test
    void testValidateFileSlicesTruncation() {
        HoodieMetadataTableValidator.Config config = new HoodieMetadataTableValidator.Config();
        config.basePath = this.basePath;
        config.logDetailMaxLength = 100;
        MockHoodieMetadataTableValidator validator = new MockHoodieMetadataTableValidator(this.jsc, config);
        String partition = "partition_" + TestStringUtils.generateRandomString((int)10);
        ArrayList<FileSlice> mdtFileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> fsFileSlices = new ArrayList<FileSlice>();
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)HoodieTimeGeneratorConfig.defaultConfig((String)this.basePath), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration()));
        for (int i = 0; i < 20; ++i) {
            String fileId = UUID.randomUUID().toString();
            String baseInstantTime = this.metaClient.createNewInstantTime();
            HoodieBaseFile baseFile = new HoodieBaseFile(FSUtils.makeBaseFileName((String)baseInstantTime, (String)"1-0-1", (String)fileId, (String)HoodieFileFormat.PARQUET.getFileExtension()));
            List<HoodieLogFile> logFiles = Arrays.asList(new HoodieLogFile(FSUtils.makeLogFileName((String)fileId, (String)".log", (String)baseInstantTime, (int)1, (String)"1-0-1")), new HoodieLogFile(FSUtils.makeLogFileName((String)fileId, (String)".log", (String)baseInstantTime, (int)2, (String)"1-0-1")));
            FileSlice slice = new FileSlice(new HoodieFileGroupId(partition, fileId), baseInstantTime);
            slice.setBaseFile(baseFile);
            logFiles.forEach(arg_0 -> ((FileSlice)slice).addLogFile(arg_0));
            mdtFileSlices.add(slice);
            if (i >= 15) continue;
            fsFileSlices.add(new FileSlice(slice));
        }
        HoodieValidationException exception = (HoodieValidationException)Assertions.assertThrows(HoodieValidationException.class, () -> validator.validateFileSlices(mdtFileSlices, fsFileSlices, partition, this.metaClient, "test"));
        String errorMsg = exception.getMessage();
        Assertions.assertTrue((boolean)errorMsg.contains("..."));
        Assertions.assertTrue((errorMsg.length() <= config.logDetailMaxLength * 2 + 1000 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)errorMsg.contains(String.format("Number of file slices based on the file system does not match that based on the metadata table. File system-based listing (%d file slices)", fsFileSlices.size())));
        Assertions.assertTrue((boolean)errorMsg.contains(String.format("MDT-based listing (%d file slices)", mdtFileSlices.size())));
    }

    static class MockHoodieMetadataTableValidatorForRli
    extends HoodieMetadataTableValidator {
        private String destFilePath;
        private String originalFilePath;

        public MockHoodieMetadataTableValidatorForRli(JavaSparkContext jsc, HoodieMetadataTableValidator.Config cfg) {
            super(jsc, cfg);
        }

        JavaPairRDD<String, Pair<String, String>> getRecordLocationsFromRLI(HoodieSparkEngineContext sparkEngineContext, String basePath, String latestCompletedCommit) {
            try {
                FileUtil.move((String)this.destFilePath, (String)this.originalFilePath);
                return super.getRecordLocationsFromRLI(sparkEngineContext, basePath, latestCompletedCommit);
            }
            catch (IOException e) {
                throw new HoodieException("Move should not have failed");
            }
        }

        public void setDestFilePath(String destFilePath) {
            this.destFilePath = destFilePath;
        }

        public void setOriginalFilePath(String originalFilePath) {
            this.originalFilePath = originalFilePath;
        }
    }

    class MockHoodieMetadataTableValidator
    extends HoodieMetadataTableValidator {
        private List<String> metadataPartitionsToReturn;
        private List<String> fsPartitionsToReturn;
        private Option<String> partitionCreationTime;

        public MockHoodieMetadataTableValidator(JavaSparkContext jsc, HoodieMetadataTableValidator.Config cfg) {
            super(jsc, cfg);
        }

        void setMetadataPartitionsToReturn(List<String> metadataPartitionsToReturn) {
            this.metadataPartitionsToReturn = metadataPartitionsToReturn;
        }

        void setFsPartitionsToReturn(List<String> fsPartitionsToReturn) {
            this.fsPartitionsToReturn = fsPartitionsToReturn;
        }

        void setPartitionCreationTime(Option<String> partitionCreationTime) {
            this.partitionCreationTime = partitionCreationTime;
        }

        List<String> getPartitionsFromFileSystem(HoodieEngineContext engineContext, StoragePath basePath, HoodieStorage storage, HoodieTimeline completedTimeline) {
            return this.fsPartitionsToReturn;
        }

        List<String> getPartitionsFromMDT(HoodieEngineContext engineContext, StoragePath basePath, HoodieStorage storage) {
            return this.metadataPartitionsToReturn;
        }

        Option<String> getPartitionCreationInstant(HoodieStorage storage, StoragePath basePath, String partition) {
            return this.partitionCreationTime;
        }
    }
}

