/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.providers.SparkProvider;
import org.apache.hudi.utilities.HoodieRepairTool;
import org.apache.spark.HoodieSparkKryoRegistrar$;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieRepairTool
extends HoodieCommonTestHarness
implements SparkProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieRepairTool.class);
    private static final Map<String, List<Pair<String, String>>> BASE_FILE_INFO = new HashMap<String, List<Pair<String, String>>>();
    private static final Map<String, List<Pair<String, String>>> LOG_FILE_INFO = new HashMap<String, List<Pair<String, String>>>();
    private static final List<String> DANGLING_DATA_FILE_LIST = new ArrayList<String>();
    private static transient SparkSession spark;
    private static transient SQLContext sqlContext;
    private static transient JavaSparkContext jsc;
    private static transient HoodieSparkEngineContext context;
    private final Map<String, Map<String, List<Pair<String, String>>>> instantInfoMap = new HashMap<String, Map<String, List<Pair<String, String>>>>();
    private final List<String> allFileAbsolutePathList = new ArrayList<String>();
    private java.nio.file.Path backupTempDir;

    @BeforeAll
    static void initFileInfo() {
        HoodieTestCommitGenerator.initCommitInfoForRepairTests(BASE_FILE_INFO, LOG_FILE_INFO);
        TestHoodieRepairTool.initDanglingDataFileList();
    }

    @BeforeEach
    public void initWithCleanState() throws IOException {
        boolean initialized;
        boolean bl = initialized = spark != null;
        if (!initialized) {
            SparkConf sparkConf = this.conf();
            HoodieSparkKryoRegistrar$.MODULE$.register(sparkConf);
            SparkRDDReadClient.addHoodieSupport((SparkConf)sparkConf);
            spark = SparkSession.builder().config(sparkConf).getOrCreate();
            sqlContext = spark.sqlContext();
            jsc = new JavaSparkContext(spark.sparkContext());
            context = new HoodieSparkEngineContext(jsc);
        }
        this.initPath();
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)this.getTableType());
        this.backupTempDir = this.tempDir.resolve("backup");
        this.cleanUpDanglingDataFilesInFS();
        this.cleanUpBackupTempDir();
        HoodieTestCommitGenerator.setupTimelineInFS((String)this.basePath, BASE_FILE_INFO, LOG_FILE_INFO, this.instantInfoMap);
        this.allFileAbsolutePathList.clear();
        this.allFileAbsolutePathList.addAll(this.instantInfoMap.entrySet().stream().flatMap(e -> ((Map)e.getValue()).entrySet().stream().flatMap(partition -> ((List)partition.getValue()).stream().map(fileInfo -> new Path(new Path(this.basePath, (String)partition.getKey()), (String)fileInfo.getValue()).toString()).collect(Collectors.toList()).stream()).collect(Collectors.toList()).stream()).collect(Collectors.toList()));
    }

    @AfterEach
    public void cleanUp() throws IOException {
        this.cleanUpDanglingDataFilesInFS();
        this.cleanUpBackupTempDir();
    }

    @AfterAll
    public static synchronized void resetSpark() {
        if (spark != null) {
            spark.close();
            spark = null;
        }
    }

    private void cleanUpDanglingDataFilesInFS() {
        HoodieStorage storage = this.metaClient.getStorage();
        DANGLING_DATA_FILE_LIST.forEach(relativeFilePath -> {
            StoragePath path = new StoragePath(this.basePath, relativeFilePath);
            try {
                if (storage.exists(path)) {
                    storage.deleteFile(path);
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to delete file: " + path);
            }
        });
    }

    private void cleanUpBackupTempDir() throws IOException {
        HoodieStorage storage = this.metaClient.getStorage();
        storage.deleteDirectory(new StoragePath(this.backupTempDir.toAbsolutePath().toString()));
    }

    private static void initDanglingDataFileList() {
        DANGLING_DATA_FILE_LIST.add(new Path("2022/01/01", HoodieTestCommitGenerator.getBaseFilename((String)"000", (String)UUID.randomUUID().toString())).toString());
        DANGLING_DATA_FILE_LIST.add(new Path("2022/01/06", HoodieTestCommitGenerator.getLogFilename((String)"001", (String)UUID.randomUUID().toString())).toString());
    }

    private Stream<Arguments> configPathParams() {
        Object[][] data = new Object[][]{{null, this.basePath, -1}, {this.basePath + "/backup", this.basePath, -1}, {"/tmp/backup", this.basePath, 0}};
        return Stream.of(data).map(Arguments::of);
    }

    @Test
    public void testCheckBackupPathAgainstBasePath() {
        this.configPathParams().forEach(arguments -> {
            Object[] args = arguments.get();
            String backupPath = (String)args[0];
            String basePath = (String)args[1];
            int expectedResult = (Integer)args[2];
            HoodieRepairTool.Config config = new HoodieRepairTool.Config();
            config.backupPath = backupPath;
            config.basePath = basePath;
            HoodieRepairTool tool = new HoodieRepairTool(jsc, config);
            Assertions.assertEquals((int)expectedResult, (int)tool.checkBackupPathAgainstBasePath());
        });
    }

    private Stream<Arguments> configPathParamsWithFS() throws IOException {
        SecureRandom random = new SecureRandom();
        long randomLong = random.nextLong();
        String emptyBackupPath = "/tmp/empty_backup_" + randomLong;
        FSUtils.createPathIfNotExists((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(emptyBackupPath));
        String nonEmptyBackupPath = "/tmp/nonempty_backup_" + randomLong;
        FSUtils.createPathIfNotExists((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(nonEmptyBackupPath));
        FSUtils.createPathIfNotExists((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(nonEmptyBackupPath, ".hoodie"));
        Object[][] data = new Object[][]{{null, this.basePath, 0}, {"/tmp/backup", this.basePath, 0}, {emptyBackupPath, this.basePath, 0}, {this.basePath + "/backup", this.basePath, -1}, {nonEmptyBackupPath, this.basePath, -1}};
        return Stream.of(data).map(Arguments::of);
    }

    @Test
    public void testCheckBackupPathForRepair() throws IOException {
        for (Arguments arguments : this.configPathParamsWithFS().collect(Collectors.toList())) {
            Object[] args = arguments.get();
            String backupPath = (String)args[0];
            String basePath = (String)args[1];
            int expectedResult = (Integer)args[2];
            HoodieRepairTool.Config config = new HoodieRepairTool.Config();
            config.backupPath = backupPath;
            config.basePath = basePath;
            HoodieRepairTool tool = new HoodieRepairTool(jsc, config);
            Assertions.assertEquals((int)expectedResult, (int)tool.checkBackupPathForRepair());
            if (backupPath != null) continue;
            Assertions.assertNotNull((Object)config.backupPath);
        }
    }

    @Test
    public void testRepairWithIntactInstants() throws IOException {
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.REPAIR.toString(), this.backupTempDir.toAbsolutePath().toString(), true, this.allFileAbsolutePathList, Collections.emptyList());
    }

    @Test
    public void testRepairWithBrokenInstants() throws IOException {
        List<String> tableDanglingFileList = this.createDanglingDataFilesInFS(this.basePath);
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        List backupDanglingFileList = DANGLING_DATA_FILE_LIST.stream().map(filePath -> new Path(backupPath, filePath).toString()).collect(Collectors.toList());
        ArrayList<String> existingFileList = new ArrayList<String>(this.allFileAbsolutePathList);
        existingFileList.addAll(backupDanglingFileList);
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.REPAIR.toString(), backupPath, true, existingFileList, tableDanglingFileList);
    }

    @Test
    public void testRepairWithOneBrokenInstant() throws IOException {
        List<String> tableDanglingFileList = this.createDanglingDataFilesInFS(this.basePath);
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        List backupDanglingFileList = DANGLING_DATA_FILE_LIST.subList(1, 2).stream().map(filePath -> new Path(backupPath, filePath).toString()).collect(Collectors.toList());
        ArrayList<String> existingFileList = new ArrayList<String>(this.allFileAbsolutePathList);
        existingFileList.addAll(backupDanglingFileList);
        existingFileList.addAll(tableDanglingFileList.subList(0, 1));
        this.testRepairToolWithMode((Option<String>)Option.of((Object)"001"), (Option<String>)Option.empty(), HoodieRepairTool.Mode.REPAIR.toString(), backupPath, true, existingFileList, tableDanglingFileList.subList(1, 2));
    }

    @Test
    public void testDryRunWithBrokenInstants() throws IOException {
        List<String> tableDanglingFileList = this.createDanglingDataFilesInFS(this.basePath);
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        List<String> backupDanglingFileList = DANGLING_DATA_FILE_LIST.stream().map(filePath -> new Path(backupPath, filePath).toString()).collect(Collectors.toList());
        ArrayList<String> existingFileList = new ArrayList<String>(this.allFileAbsolutePathList);
        existingFileList.addAll(tableDanglingFileList);
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.DRY_RUN.toString(), backupPath, true, existingFileList, backupDanglingFileList);
    }

    @Test
    public void testDryRunWithOneBrokenInstant() throws IOException {
        List<String> tableDanglingFileList = this.createDanglingDataFilesInFS(this.basePath);
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        List<String> backupDanglingFileList = DANGLING_DATA_FILE_LIST.stream().map(filePath -> new Path(backupPath, filePath).toString()).collect(Collectors.toList());
        ArrayList<String> existingFileList = new ArrayList<String>(this.allFileAbsolutePathList);
        existingFileList.addAll(tableDanglingFileList);
        this.testRepairToolWithMode((Option<String>)Option.of((Object)"001"), (Option<String>)Option.empty(), HoodieRepairTool.Mode.DRY_RUN.toString(), backupPath, true, existingFileList, backupDanglingFileList);
    }

    @Test
    public void testUndoWithNonExistentBackupPath() throws IOException {
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        this.metaClient.getStorage().deleteDirectory(new StoragePath(backupPath));
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.UNDO.toString(), backupPath, false, this.allFileAbsolutePathList, Collections.emptyList());
    }

    @Test
    public void testUndoWithExistingBackupPath() throws IOException {
        String backupPath = this.backupTempDir.toAbsolutePath().toString();
        List<String> backupDanglingFileList = this.createDanglingDataFilesInFS(backupPath);
        List<String> restoreDanglingFileList = DANGLING_DATA_FILE_LIST.stream().map(filePath -> new Path(this.basePath, filePath).toString()).collect(Collectors.toList());
        ArrayList<String> existingFileList = new ArrayList<String>(this.allFileAbsolutePathList);
        existingFileList.addAll(backupDanglingFileList);
        existingFileList.addAll(restoreDanglingFileList);
        this.verifyFilesInFS(this.allFileAbsolutePathList, restoreDanglingFileList);
        this.verifyFilesInFS(backupDanglingFileList, Collections.emptyList());
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.UNDO.toString(), backupPath, true, existingFileList, Collections.emptyList());
        this.testRepairToolWithMode((Option<String>)Option.empty(), (Option<String>)Option.empty(), HoodieRepairTool.Mode.UNDO.toString(), backupPath, false, existingFileList, Collections.emptyList());
    }

    private void testRepairToolWithMode(Option<String> startingInstantOption, Option<String> endingInstantOption, String runningMode, String backupPath, boolean isRunSuccessful, List<String> existFilePathList, List<String> nonExistFilePathList) throws IOException {
        HoodieRepairTool.Config config = new HoodieRepairTool.Config();
        config.backupPath = backupPath;
        config.basePath = this.basePath;
        if (startingInstantOption.isPresent()) {
            config.startingInstantTime = (String)startingInstantOption.get();
        }
        if (endingInstantOption.isPresent()) {
            config.endingInstantTime = (String)endingInstantOption.get();
        }
        config.runningMode = runningMode;
        HoodieRepairTool tool = new HoodieRepairTool(jsc, config);
        Assertions.assertEquals((Object)isRunSuccessful, (Object)tool.run());
        this.verifyFilesInFS(existFilePathList, nonExistFilePathList);
    }

    private void verifyFilesInFS(List<String> existFilePathList, List<String> nonExistFilePathList) throws IOException {
        HoodieStorage storage = this.metaClient.getStorage();
        for (String filePath : existFilePathList) {
            Assertions.assertTrue((boolean)storage.exists(new StoragePath(filePath)), (String)String.format("File %s should exist but it's not in the file system", filePath));
        }
        for (String filePath : nonExistFilePathList) {
            Assertions.assertFalse((boolean)storage.exists(new StoragePath(filePath)), (String)String.format("File %s should not exist but it's in the file system", filePath));
        }
    }

    private List<String> createDanglingDataFilesInFS(String parentPath) {
        HoodieStorage storage = this.metaClient.getStorage();
        return DANGLING_DATA_FILE_LIST.stream().map(relativeFilePath -> {
            StoragePath path = new StoragePath(parentPath, relativeFilePath);
            try {
                storage.createDirectory(path.getParent());
                if (!storage.exists(path)) {
                    storage.create(path, false);
                }
            }
            catch (IOException e) {
                LOG.error("Error creating file: " + path);
            }
            return path.toString();
        }).collect(Collectors.toList());
    }

    public HoodieEngineContext context() {
        return context;
    }

    public SparkSession spark() {
        return spark;
    }

    public SQLContext sqlContext() {
        return sqlContext;
    }

    public JavaSparkContext jsc() {
        return jsc;
    }
}

