/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import org.apache.hudi.utilities.SqlQueryBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlQueryBuilder {
    @Test
    public void testSelect() {
        String sql = SqlQueryBuilder.select((String[])new String[]{"id", "rider", "time"}).from(new String[]{"trips"}).join("users").on("trips.rider = users.id").where("(trips.time > 100 or trips.time < 200)").orderBy(new String[]{"id", "time"}).limit(10L).toString();
        Assertions.assertEquals((Object)"select id, rider, time from trips join users on trips.rider = users.id where (trips.time > 100 or trips.time < 200) order by id, time limit 10", (Object)sql);
    }

    @Test
    public void testIncorrectQueries() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[0]).toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"*"}).from(new String[0]).toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"id"}).from(new String[]{"trips"}).where("").toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"id"}).from(new String[]{"trips"}).join("").toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"id"}).from(new String[]{"trips"}).join("riders").on("").toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"id"}).from(new String[]{"trips"}).join("riders").where("id > 0").orderBy(new String[0]).toString());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlQueryBuilder.select((String[])new String[]{"id"}).from(new String[]{"trips"}).join("riders").where("id > 0").orderBy(new String[]{"id"}).limit(-1L).toString());
    }
}

