/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.streamer.ConfigurationHotUpdateStrategy;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockConfigurationHotUpdateStrategy
extends ConfigurationHotUpdateStrategy
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MockConfigurationHotUpdateStrategy.class);

    public MockConfigurationHotUpdateStrategy(HoodieDeltaStreamer.Config cfg, TypedProperties properties) {
        super((HoodieStreamer.Config)cfg, properties);
    }

    public Option<TypedProperties> updateProperties(TypedProperties currentProps) {
        if (currentProps.containsKey((Object)HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key())) {
            long upsertShuffleParallelism = currentProps.getLong(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key());
            TypedProperties newProps = TypedProperties.copy((Properties)currentProps);
            newProps.setProperty(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), String.valueOf(upsertShuffleParallelism + 5L));
            LOG.info("update {} from [{}] to [{}]", new Object[]{HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), upsertShuffleParallelism, upsertShuffleParallelism + 5L});
            return Option.of((Object)newProps);
        }
        return Option.empty();
    }
}

