/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.utilities.config.HoodieSchemaProviderConfig;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerTestBase;
import org.apache.hudi.utilities.deltastreamer.HoodieMultiTableDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.TestHoodieDeltaStreamer;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.apache.hudi.utilities.sources.JsonKafkaSource;
import org.apache.hudi.utilities.sources.ParquetDFSSource;
import org.apache.hudi.utilities.sources.TestDataSource;
import org.apache.hudi.utilities.streamer.TableExecutionContext;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieMultiTableDeltaStreamer
extends HoodieDeltaStreamerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieMultiTableDeltaStreamer.class);

    @Test
    public void testEmptyTransformerProps() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-source1.properties", basePath + "/config", TestDataSource.class.getName(), false, false, null);
        HoodieDeltaStreamer.Config dsConfig = new HoodieDeltaStreamer.Config();
        TypedProperties tblProperties = new TypedProperties();
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        Assertions.assertNull((Object)cfg.transformerClassNames);
    }

    @Test
    public void testMetaSyncConfig() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-source1.properties", basePath + "/config", TestDataSource.class.getName(), true, true, null);
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        TableExecutionContext executionContext = (TableExecutionContext)streamer.getTableExecutionContexts().get(1);
        Assertions.assertEquals((Object)"com.example.DummySyncTool1,com.example.DummySyncTool2", (Object)executionContext.getConfig().syncClientToolClassNames);
    }

    @Test
    public void testInvalidHiveSyncProps() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-invalid-hive-sync-source1.properties", basePath + "/config", TestDataSource.class.getName(), true, true, null);
        Exception e = (Exception)Assertions.assertThrows(HoodieException.class, () -> new HoodieMultiTableDeltaStreamer(cfg, jsc), (String)"Should fail when hive sync table not provided with enableHiveSync flag");
        LOG.debug("Expected error when creating table execution objects", (Throwable)e);
        Assertions.assertTrue((boolean)e.getMessage().contains("Meta sync table field not provided!"));
    }

    @Test
    public void testInvalidPropsFilePath() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-invalid-props.properties", basePath + "/config", TestDataSource.class.getName(), true, true, null);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieMultiTableDeltaStreamer(cfg, jsc), (String)"Should fail when invalid props file is provided");
        LOG.debug("Expected error when creating table execution objects", (Throwable)e);
        Assertions.assertTrue((boolean)e.getMessage().contains("Please provide valid common config file path!"));
    }

    @Test
    public void testInvalidTableConfigFilePath() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-invalid-table-config.properties", basePath + "/config", TestDataSource.class.getName(), true, true, null);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieMultiTableDeltaStreamer(cfg, jsc), (String)"Should fail when invalid table config props file path is provided");
        LOG.debug("Expected error when creating table execution objects", (Throwable)e);
        Assertions.assertTrue((boolean)e.getMessage().contains("Please provide valid table config file path!"));
    }

    @Test
    public void testCustomConfigProps() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-source1.properties", basePath + "/config", TestDataSource.class.getName(), false, false, SchemaRegistryProvider.class);
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        TableExecutionContext executionContext = (TableExecutionContext)streamer.getTableExecutionContexts().get(1);
        Assertions.assertEquals((int)2, (int)streamer.getTableExecutionContexts().size());
        Assertions.assertEquals((Object)(basePath + "/multi_table_dataset/uber_db/dummy_table_uber"), (Object)executionContext.getConfig().targetBasePath);
        Assertions.assertEquals((Object)"uber_db.dummy_table_uber", (Object)executionContext.getConfig().targetTableName);
        Assertions.assertEquals((Object)"topic1", (Object)ConfigUtils.getStringWithAltKeys((Properties)executionContext.getProperties(), (ConfigProperty)HoodieStreamerConfig.KAFKA_TOPIC));
        Assertions.assertEquals((Object)"_row_key", (Object)ConfigUtils.getStringWithAltKeys((Properties)executionContext.getProperties(), (ConfigProperty)DataSourceWriteOptions.RECORDKEY_FIELD()));
        Assertions.assertEquals((Object)TestHoodieDeltaStreamer.TestGenerator.class.getName(), (Object)ConfigUtils.getStringWithAltKeys((Properties)executionContext.getProperties(), (ConfigProperty)DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME()));
        Assertions.assertEquals((Object)"uber_hive_dummy_table", (Object)ConfigUtils.getStringWithAltKeys((Properties)executionContext.getProperties(), (ConfigProperty)HoodieSyncConfig.META_SYNC_TABLE_NAME));
        Assertions.assertEquals((Object)"http://localhost:8081/subjects/random-value/versions/latest", (Object)ConfigUtils.getStringWithAltKeys((Properties)executionContext.getProperties(), (ConfigProperty)HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL));
        Assertions.assertEquals((Object)"http://localhost:8081/subjects/topic2-value/versions/latest", (Object)ConfigUtils.getStringWithAltKeys((Properties)((TableExecutionContext)streamer.getTableExecutionContexts().get(0)).getProperties(), (ConfigProperty)HoodieSchemaProviderConfig.SRC_SCHEMA_REGISTRY_URL));
    }

    @Test
    public void testMultiTableExecutionWithKafkaSource() throws IOException {
        String topicName1 = "topic" + testNum++;
        String topicName2 = "topic" + testNum;
        this.testUtils.createTopic(topicName1, 2);
        this.testUtils.createTopic(topicName2, 2);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        this.testUtils.sendMessages(topicName1, UtilitiesTestBase.Helpers.jsonifyRecords(dataGenerator.generateInsertsAsPerSchema("000", Integer.valueOf(5), "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}")));
        this.testUtils.sendMessages(topicName2, UtilitiesTestBase.Helpers.jsonifyRecords(dataGenerator.generateInsertsAsPerSchema("000", Integer.valueOf(10), "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}")));
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-source1.properties", basePath + "/config", JsonKafkaSource.class.getName(), false, false, null);
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        List executionContexts = streamer.getTableExecutionContexts();
        TypedProperties properties = ((TableExecutionContext)executionContexts.get(1)).getProperties();
        properties.setProperty("hoodie.streamer.schemaprovider.source.schema.file", basePath + "/source_uber.avsc");
        properties.setProperty("hoodie.streamer.schemaprovider.target.schema.file", basePath + "/target_uber.avsc");
        properties.setProperty("hoodie.datasource.write.partitionpath.field", "timestamp");
        properties.setProperty("hoodie.streamer.source.kafka.topic", topicName2);
        ((TableExecutionContext)executionContexts.get(1)).setProperties(properties);
        TypedProperties properties1 = ((TableExecutionContext)executionContexts.get(0)).getProperties();
        properties1.setProperty("hoodie.streamer.schemaprovider.source.schema.file", basePath + "/source_short_trip_uber.avsc");
        properties1.setProperty("hoodie.streamer.schemaprovider.target.schema.file", basePath + "/target_short_trip_uber.avsc");
        properties1.setProperty("hoodie.datasource.write.partitionpath.field", "timestamp");
        properties1.setProperty("hoodie.streamer.source.kafka.topic", topicName1);
        ((TableExecutionContext)executionContexts.get(0)).setProperties(properties1);
        String targetBasePath1 = ((TableExecutionContext)executionContexts.get((int)0)).getConfig().targetBasePath;
        String targetBasePath2 = ((TableExecutionContext)executionContexts.get((int)1)).getConfig().targetBasePath;
        streamer.sync();
        this.assertRecordCount(5L, targetBasePath1, sqlContext);
        this.assertRecordCount(10L, targetBasePath2, sqlContext);
        this.testUtils.sendMessages(topicName1, UtilitiesTestBase.Helpers.jsonifyRecords(dataGenerator.generateUpdatesAsPerSchema("001", Integer.valueOf(5), "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}")));
        this.testUtils.sendMessages(topicName2, UtilitiesTestBase.Helpers.jsonifyRecords(dataGenerator.generateUpdatesAsPerSchema("001", Integer.valueOf(10), "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}")));
        streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        ((TableExecutionContext)streamer.getTableExecutionContexts().get(1)).setProperties(properties);
        ((TableExecutionContext)streamer.getTableExecutionContexts().get(0)).setProperties(properties1);
        streamer.sync();
        Assertions.assertEquals((int)2, (int)streamer.getSuccessTables().size());
        Assertions.assertTrue((boolean)streamer.getFailedTables().isEmpty());
        this.assertRecordCount(5L, targetBasePath1, sqlContext);
        this.assertRecordCount(10L, targetBasePath2, sqlContext);
        ++testNum;
    }

    @Test
    public void testMultiTableExecutionWithParquetSource() throws IOException {
        String parquetSourceRoot1 = basePath + "/parquetSrcPath1/";
        TestHoodieMultiTableDeltaStreamer.prepareParquetDFSFiles(10, parquetSourceRoot1);
        String parquetSourceRoot2 = basePath + "/parquetSrcPath2/";
        TestHoodieMultiTableDeltaStreamer.prepareParquetDFSFiles(5, parquetSourceRoot2);
        String parquetPropsFile = this.populateCommonPropsAndWriteToFile();
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig(parquetPropsFile, basePath + "/config", ParquetDFSSource.class.getName(), false, false, false, "multi_table_parquet", null);
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        List executionContexts = streamer.getTableExecutionContexts();
        this.ingestPerParquetSourceProps(executionContexts, Arrays.asList(parquetSourceRoot1, parquetSourceRoot2));
        String targetBasePath1 = ((TableExecutionContext)executionContexts.get((int)0)).getConfig().targetBasePath;
        String targetBasePath2 = ((TableExecutionContext)executionContexts.get((int)1)).getConfig().targetBasePath;
        this.syncAndVerify(streamer, targetBasePath1, targetBasePath2, 10L, 5L);
        int totalTable1Records = 10;
        int totalTable2Records = 5;
        for (int i = 0; i < 3; ++i) {
            int table1Records = 10 + RANDOM.nextInt(100);
            int table2Records = 15 + RANDOM.nextInt(100);
            TestHoodieMultiTableDeltaStreamer.prepareParquetDFSFiles(table1Records, parquetSourceRoot1, i + 2 + ".parquet", false, null, null);
            TestHoodieMultiTableDeltaStreamer.prepareParquetDFSFiles(table2Records, parquetSourceRoot2, i + 2 + ".parquet", false, null, null);
            this.syncAndVerify(streamer, targetBasePath1, targetBasePath2, totalTable1Records += table1Records, totalTable2Records += table2Records);
        }
    }

    @Test
    public void testTableLevelProperties() throws IOException {
        HoodieMultiTableDeltaStreamer.Config cfg = TestHelpers.getConfig("test-source1.properties", basePath + "/config", TestDataSource.class.getName(), false, false, null);
        HoodieMultiTableDeltaStreamer streamer = new HoodieMultiTableDeltaStreamer(cfg, jsc);
        List tableExecutionContexts = streamer.getTableExecutionContexts();
        tableExecutionContexts.forEach(tableExecutionContext -> {
            switch (tableExecutionContext.getTableName()) {
                case "dummy_table_short_trip": {
                    String tableLevelKeyGeneratorClass = tableExecutionContext.getProperties().getString(DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME().key());
                    Assertions.assertEquals((Object)TestHoodieDeltaStreamer.TestGenerator.class.getName(), (Object)tableLevelKeyGeneratorClass);
                    List transformerClass = tableExecutionContext.getConfig().transformerClassNames;
                    Assertions.assertEquals((int)1, (int)transformerClass.size());
                    Assertions.assertEquals((Object)"org.apache.hudi.utilities.deltastreamer.TestHoodieDeltaStreamer$TestIdentityTransformer", transformerClass.get(0));
                    break;
                }
                default: {
                    String defaultKeyGeneratorClass = tableExecutionContext.getProperties().getString(DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME().key());
                    Assertions.assertEquals((Object)TestHoodieDeltaStreamer.TestGenerator.class.getName(), (Object)defaultKeyGeneratorClass);
                    Assertions.assertNull((Object)tableExecutionContext.getConfig().transformerClassNames);
                }
            }
        });
    }

    private String populateCommonPropsAndWriteToFile() throws IOException {
        TypedProperties commonProps = new TypedProperties();
        TestHoodieMultiTableDeltaStreamer.populateCommonProps(commonProps, basePath);
        UtilitiesTestBase.Helpers.savePropsToDFS(commonProps, storage, basePath + "/" + "test-parquet-dfs-source.properties");
        return "test-parquet-dfs-source.properties";
    }

    private TypedProperties getParquetProps(String parquetSourceRoot) {
        TypedProperties props = new TypedProperties();
        props.setProperty("include", "base.properties");
        props.setProperty("hoodie.datasource.write.recordkey.field", "_row_key");
        props.setProperty("hoodie.datasource.write.partitionpath.field", "partition_path");
        props.setProperty("hoodie.streamer.source.dfs.root", parquetSourceRoot);
        return props;
    }

    private void ingestPerParquetSourceProps(List<TableExecutionContext> executionContexts, List<String> parquetSourceRoots) {
        int counter = 0;
        for (String parquetSourceRoot : parquetSourceRoots) {
            TypedProperties properties = executionContexts.get(counter).getProperties();
            TypedProperties parquetProps = this.getParquetProps(parquetSourceRoot);
            parquetProps.forEach((k, v) -> properties.setProperty(k.toString(), v.toString()));
            executionContexts.get(counter).setProperties(properties);
            ++counter;
        }
    }

    private void syncAndVerify(HoodieMultiTableDeltaStreamer streamer, String targetBasePath1, String targetBasePath2, long table1ExpectedRecords, long table2ExpectedRecords) {
        streamer.sync();
        this.assertRecordCount(table1ExpectedRecords, targetBasePath1, sqlContext);
        this.assertRecordCount(table2ExpectedRecords, targetBasePath2, sqlContext);
    }

    static class TestHelpers {
        TestHelpers() {
        }

        static HoodieMultiTableDeltaStreamer.Config getConfig(String fileName, String configFolder, String sourceClassName, boolean enableHiveSync, boolean enableMetaSync, Class<?> clazz) {
            return TestHelpers.getConfig(fileName, configFolder, sourceClassName, enableHiveSync, enableMetaSync, true, "multi_table_dataset", clazz);
        }

        static HoodieMultiTableDeltaStreamer.Config getConfig(String fileName, String configFolder, String sourceClassName, boolean enableHiveSync, boolean enableMetaSync, boolean setSchemaProvider, String basePathPrefix, Class<?> clazz) {
            HoodieMultiTableDeltaStreamer.Config config = new HoodieMultiTableDeltaStreamer.Config();
            config.configFolder = configFolder;
            config.targetTableName = "dummy_table";
            config.basePathPrefix = basePath + "/" + basePathPrefix;
            config.propsFilePath = basePath + "/" + fileName;
            config.tableType = "COPY_ON_WRITE";
            config.sourceClassName = sourceClassName;
            config.sourceOrderingField = "timestamp";
            if (setSchemaProvider) {
                config.schemaProviderClassName = clazz != null ? clazz.getName() : FilebasedSchemaProvider.class.getName();
            }
            config.enableHiveSync = enableHiveSync;
            config.enableMetaSync = enableMetaSync;
            config.syncClientToolClassNames = "com.example.DummySyncTool1,com.example.DummySyncTool2";
            return config;
        }
    }
}

