/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.net.URI;
import java.util.Map;
import org.apache.hudi.SparkConfigs;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.hudi.utilities.streamer.SchedulerConfGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchedulerConfGenerator {
    @Test
    public void testGenerateSparkSchedulingConf() throws Exception {
        HoodieStreamer.Config cfg = new HoodieStreamer.Config();
        Map configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieStreamer.Config)cfg);
        Assertions.assertNull(configs.get(SparkConfigs.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()), (String)"spark.scheduler.mode not set");
        System.setProperty("spark.scheduler.mode", "FAIR");
        cfg.continuousMode = false;
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieStreamer.Config)cfg);
        Assertions.assertNull(configs.get(SparkConfigs.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()), (String)"continuousMode is false");
        cfg.continuousMode = true;
        cfg.tableType = HoodieTableType.COPY_ON_WRITE.name();
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieStreamer.Config)cfg);
        Assertions.assertNull(configs.get(SparkConfigs.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()), (String)"table type is not MERGE_ON_READ");
        cfg.tableType = HoodieTableType.MERGE_ON_READ.name();
        configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieStreamer.Config)cfg);
        Assertions.assertNotNull(configs.get(SparkConfigs.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()), (String)"all satisfies");
    }

    @Test
    public void testGenerateConfig() {
        String targetConfig = "<?xml version=\"1.0\"?>\n<allocations>\n    <pool name=\"hoodiedeltasync\">\n        <schedulingMode>FAIR</schedulingMode>\n        <weight>1</weight>\n        <minShare>2</minShare>\n    </pool>\n    <pool name=\"hoodiecompact\">\n        <schedulingMode>FAIR</schedulingMode>\n        <weight>3</weight>\n        <minShare>4</minShare>\n    </pool>\n    <pool name=\"hoodiecluster\">\n        <schedulingMode>FAIR</schedulingMode>\n        <weight>5</weight>\n        <minShare>6</minShare>\n    </pool>\n</allocations>";
        String generatedConfig = SchedulerConfGenerator.generateConfig((Integer)1, (Integer)3, (Integer)2, (Integer)4, (Integer)5, (Integer)6);
        Assertions.assertEquals((Object)targetConfig, (Object)generatedConfig);
    }

    @Test
    public void testGeneratedConfigFileScheme() throws Exception {
        System.setProperty("spark.scheduler.mode", "FAIR");
        HoodieStreamer.Config cfg = new HoodieStreamer.Config();
        cfg.continuousMode = true;
        cfg.tableType = HoodieTableType.MERGE_ON_READ.name();
        Map configs = SchedulerConfGenerator.getSparkSchedulingConfigs((HoodieStreamer.Config)cfg);
        URI schedulerFile = URI.create((String)configs.get(SparkConfigs.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()));
        Assertions.assertNotNull((Object)schedulerFile.getScheme());
    }
}

