/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerTestBase;
import org.apache.hudi.utilities.sources.ParquetDFSSource;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTransformer
extends HoodieDeltaStreamerTestBase {
    @Test
    public void testMultipleTransformersWithIdentifiers() throws Exception {
        String[] arr = new String[]{"1:" + TimestampTransformer.class.getName(), "2:" + TimestampTransformer.class.getName(), "3:" + TimestampTransformer.class.getName()};
        List<String> transformerClassNames = Arrays.asList(arr);
        boolean useSchemaProvider = true;
        PARQUET_SOURCE_ROOT = basePath + "/parquetFilesDfs" + testNum;
        int parquetRecordsCount = 10;
        TestTransformer.prepareParquetDFSFiles(parquetRecordsCount, PARQUET_SOURCE_ROOT, "1.parquet", false, null, null);
        this.prepareParquetDFSSource(useSchemaProvider, true, "source.avsc", "source.avsc", "test-parquet-dfs-source.properties", PARQUET_SOURCE_ROOT, false, "partition_path", "");
        String tableBasePath = basePath + "/testMultipleTransformersWithIdentifiers" + testNum;
        HoodieDeltaStreamer deltaStreamer = new HoodieDeltaStreamer(HoodieDeltaStreamerTestBase.TestHelpers.makeConfig(tableBasePath, WriteOperationType.INSERT, ParquetDFSSource.class.getName(), transformerClassNames, "test-parquet-dfs-source.properties", false, useSchemaProvider, 100000, false, null, null, "timestamp", null), jsc);
        TypedProperties properties = ((HoodieStreamer.StreamSyncService)deltaStreamer.getIngestionService()).getProps();
        properties.setProperty("timestamp.transformer.increment.1", "10");
        properties.setProperty("timestamp.transformer.increment.3", "30");
        properties.setProperty("timestamp.transformer.increment", "20");
        properties.setProperty("timestamp.transformer.multiplier", "2");
        properties.setProperty("transformer.suffix", ".1,.2,.3");
        deltaStreamer.sync();
        this.assertRecordCount(parquetRecordsCount, tableBasePath, sqlContext);
        Assertions.assertEquals((long)0L, (long)sqlContext.read().format("org.apache.hudi").load(tableBasePath).where("timestamp != 110").count());
        ++testNum;
    }

    public static class TimestampTransformer
    implements Transformer {
        public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
            String[] suffixes;
            for (String suffix : suffixes = ((String)properties.get((Object)"transformer.suffix")).split(",")) {
                properties.keySet().forEach(k -> Assertions.assertFalse((boolean)((String)k).endsWith(suffix)));
            }
            int multiplier = Integer.parseInt((String)properties.get((Object)"timestamp.transformer.multiplier"));
            int increment = Integer.parseInt((String)properties.get((Object)"timestamp.transformer.increment"));
            return rowDataset.withColumn("timestamp", functions.col((String)"timestamp").multiply((Object)multiplier).plus((Object)increment));
        }
    }
}

