/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieErrorTableConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.exception.HoodieTransformException;
import org.apache.hudi.utilities.streamer.BaseErrorTableWriter;
import org.apache.hudi.utilities.transform.ErrorTableAwareChainedTransformer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestErrorTableAwareChainedTransformer
extends SparkClientFunctionalTestHarness {
    @Test
    public void testForErrorTableConfig() {
        Dataset<Row> original = this.getTestDataset();
        Transformer t1 = this.getErrorEventHandlerTransformer();
        Transformer t2 = (jsc, sparkSession, dataset, properties) -> dataset.withColumn("foo", dataset.col("foo").cast(DataTypes.IntegerType));
        ErrorTableAwareChainedTransformer transformer = new ErrorTableAwareChainedTransformer(Arrays.asList(t1, t2));
        TypedProperties properties2 = new TypedProperties();
        properties2.setProperty(HoodieErrorTableConfig.ERROR_TABLE_ENABLED.key(), "true");
        Dataset transformed = transformer.apply(this.jsc(), this.spark(), original, properties2);
        List rows = transformed.collectAsList();
        Assertions.assertArrayEquals((Object[])new String[]{"foo", BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME}, (Object[])transformed.columns());
        Assert.assertEquals((long)2L, (long)transformed.filter(new Column(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME).isNotNull()).count());
        Assert.assertEquals((int)100, (int)((Row)rows.get(0)).getInt(0));
        Assert.assertEquals((int)200, (int)((Row)rows.get(1)).getInt(0));
    }

    @Test
    public void testForErrorRecordColumn() {
        Dataset<Row> original = this.getTestDataset();
        Transformer t1 = this.getErrorEventHandlerTransformer();
        Transformer t2 = this.getErrorRecordColumnDropTransformer();
        Transformer t3 = (jsc, sparkSession, dataset, properties) -> dataset.withColumn("foo", dataset.col("foo").cast(DataTypes.IntegerType));
        TypedProperties properties2 = new TypedProperties();
        properties2.setProperty(HoodieErrorTableConfig.ERROR_TABLE_ENABLED.key(), "true");
        ErrorTableAwareChainedTransformer transformer = new ErrorTableAwareChainedTransformer(Arrays.asList(t1, t2, t3));
        Assertions.assertThrows(HoodieValidationException.class, () -> transformer.apply(this.jsc(), this.spark(), original, properties2));
    }

    private Dataset<Row> getTestDataset() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"foo", (DataType)DataTypes.StringType, (boolean)false)});
        Row r1 = RowFactory.create((Object[])new Object[]{"100"});
        Row r2 = RowFactory.create((Object[])new Object[]{"200"});
        return this.spark().sqlContext().createDataFrame(Arrays.asList(r1, r2), schema);
    }

    private Transformer getErrorEventHandlerTransformer() {
        return (jsc, sparkSession, dataset, properties) -> {
            boolean isErrorTableEnabledInTransformer = properties.getBoolean(HoodieErrorTableConfig.ERROR_TABLE_ENABLED.key(), ((Boolean)HoodieErrorTableConfig.ERROR_TABLE_ENABLED.defaultValue()).booleanValue());
            if (isErrorTableEnabledInTransformer) {
                dataset = dataset.withColumn(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME, functions.when((Column)new Column(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME).isNull(), (Object)functions.lit((Object)"true")).otherwise((Object)new Column(BaseErrorTableWriter.ERROR_TABLE_CURRUPT_RECORD_COL_NAME)));
            }
            return dataset;
        };
    }

    private Transformer getErrorRecordColumnDropTransformer() {
        return (jsc, sparkSession, dataset, properties) -> dataset.select("foo", new String[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={":org.apache.hudi.utilities.transform.FlatteningTransformer,T2:org.apache.hudi.utilities.transform.FlatteningTransformer", "T1:org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer", "T1::org.apache.hudi.utilities.transform.FlatteningTransformer", "org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer"})
    public void testErrorTableAwareChainedTransformerValidationFails(String transformerName) {
        Assertions.assertThrows(HoodieTransformException.class, () -> new ErrorTableAwareChainedTransformer(Arrays.asList(transformerName.split(",")), Option::empty));
    }

    @ParameterizedTest
    @ValueSource(strings={"T1:org.apache.hudi.utilities.transform.FlatteningTransformer,T2:org.apache.hudi.utilities.transform.FlatteningTransformer", "T2:org.apache.hudi.utilities.transform.FlatteningTransformer,T1:org.apache.hudi.utilities.transform.FlatteningTransformer", "abc:org.apache.hudi.utilities.transform.FlatteningTransformer,def:org.apache.hudi.utilities.transform.FlatteningTransformer", "org.apache.hudi.utilities.transform.FlatteningTransformer,org.apache.hudi.utilities.transform.FlatteningTransformer"})
    public void testErrorTableAwareChainedTransformerValidationPasses(String transformerName) {
        ErrorTableAwareChainedTransformer transformer = new ErrorTableAwareChainedTransformer(Arrays.asList(transformerName.split(",")), Option::empty);
        Assert.assertNotNull((Object)transformer);
    }
}

