/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.offlinejob;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieOfflineJobTestBase
extends UtilitiesTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(UtilitiesTestBase.class);
    protected HoodieTestDataGenerator dataGen;
    protected SparkRDDWriteClient client;
    protected HoodieTableMetaClient metaClient;

    @BeforeAll
    public static void initClass() throws Exception {
        UtilitiesTestBase.initTestServices(false, false, false);
    }

    @Override
    @BeforeEach
    public void setup() {
        this.dataGen = new HoodieTestDataGenerator();
    }

    @Override
    @AfterEach
    public void teardown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected Properties getPropertiesForKeyGen(boolean populateMetaFields) {
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.POPULATE_META_FIELDS.key(), String.valueOf(populateMetaFields));
        properties.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        properties.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
        properties.put(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
        return properties;
    }

    protected List<WriteStatus> writeData(boolean isUpsert, String instant, int numRecords, boolean doCommit) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        JavaRDD records = jsc.parallelize(this.dataGen.generateInserts(instant, Integer.valueOf(numRecords)), 2);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.client.startCommitWithTime(instant);
        List writeStatuses = isUpsert ? this.client.upsert(records, instant).collect() : this.client.insert(records, instant).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        if (doCommit) {
            List writeStats = writeStatuses.stream().map(WriteStatus::getStat).collect(Collectors.toList());
            boolean committed = this.client.commitStats(instant, writeStats, Option.empty(), this.metaClient.getCommitActionType());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)committed);
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return writeStatuses;
    }

    static class TestHelpers {
        TestHelpers() {
        }

        static void assertNCompletedCommits(int expected, String tablePath) {
            HoodieTableMetaClient meta = HoodieTestUtils.createMetaClient((HoodieStorage)storage, (String)tablePath);
            HoodieTimeline timeline = meta.getActiveTimeline().getWriteTimeline().filterCompletedInstants();
            LOG.info("Timeline Instants=" + meta.getActiveTimeline().getInstants());
            int numCommits = timeline.countInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)numCommits, (String)("Got=" + numCommits + ", exp =" + expected));
        }

        static void assertNCleanCommits(int expected, String tablePath) {
            HoodieTableMetaClient meta = HoodieTestUtils.createMetaClient((HoodieStorage)storage, (String)tablePath);
            HoodieTimeline timeline = meta.getActiveTimeline().getCleanerTimeline().filterCompletedInstants();
            LOG.info("Timeline Instants=" + meta.getActiveTimeline().getInstants());
            int numCleanCommits = timeline.countInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)numCleanCommits, (String)("Got=" + numCleanCommits + ", exp =" + expected));
        }

        static void assertNClusteringCommits(int expected, String tablePath) {
            HoodieTableMetaClient meta = HoodieTestUtils.createMetaClient((HoodieStorage)storage, (String)tablePath);
            HoodieTimeline timeline = meta.getActiveTimeline().getCompletedReplaceTimeline();
            LOG.info("Timeline Instants=" + meta.getActiveTimeline().getInstants());
            int numCommits = timeline.countInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)numCommits, (String)("Got=" + numCommits + ", exp =" + expected));
        }
    }
}

