/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.offlinejob;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.hudi.utilities.HoodieCompactor;
import org.apache.hudi.utilities.offlinejob.HoodieOfflineJobTestBase;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieCompactorJob
extends HoodieOfflineJobTestBase {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testHoodieCompactorWithOptionalClean(boolean skipClean) throws Exception {
        String tableBasePath = basePath + "/asyncCompaction_" + skipClean;
        Properties props = this.getPropertiesForKeyGen(true);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().forTable("asyncCompaction").withPath(tableBasePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).withAutoCommit(false).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).withScheduleInlineCompaction(Boolean.valueOf(false)).build()).withStorageConfig(HoodieStorageConfig.newBuilder().logFileMaxSize(1024L).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).withAutoClean(Boolean.valueOf(false)).withAsyncClean(Boolean.valueOf(false)).build()).withLayoutConfig(HoodieLayoutConfig.newBuilder().withLayoutType(HoodieStorageLayout.LayoutType.BUCKET.name()).withLayoutPartitioner(SparkBucketIndexPartitioner.class.getName()).build()).withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketNum("1").build()).build();
        props.putAll((Map<?, ?>)config.getProps());
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.MERGE_ON_READ).setPayloadClass(HoodieAvroPayload.class).fromProperties(props).initTable(HadoopFSUtils.getStorageConfWithCopy((Configuration)jsc.hadoopConfiguration()), tableBasePath);
        this.client = new SparkRDDWriteClient((HoodieEngineContext)context, config);
        this.writeData(true, this.client.createNewInstantTime(), 100, true);
        this.writeData(true, this.client.createNewInstantTime(), 100, true);
        HoodieCompactor hoodieCompactorSchedule = this.init(tableBasePath, true, "SCHEDULE", skipClean);
        hoodieCompactorSchedule.compact(0);
        HoodieOfflineJobTestBase.TestHelpers.assertNCompletedCommits(2, tableBasePath);
        HoodieOfflineJobTestBase.TestHelpers.assertNCleanCommits(0, tableBasePath);
        this.writeData(true, this.client.createNewInstantTime(), 100, true);
        this.writeData(true, this.client.createNewInstantTime(), 100, true);
        HoodieCompactor hoodieCompactorExecute = this.init(tableBasePath, false, "EXECUTE", skipClean);
        hoodieCompactorExecute.compact(0);
        HoodieOfflineJobTestBase.TestHelpers.assertNCompletedCommits(5, tableBasePath);
        if (!skipClean) {
            HoodieOfflineJobTestBase.TestHelpers.assertNCleanCommits(1, tableBasePath);
        }
    }

    private HoodieCompactor init(String tableBasePath, boolean runSchedule, String scheduleAndExecute, boolean skipClean) {
        HoodieCompactor.Config compactionConfig = this.buildCompactionConfig(tableBasePath, runSchedule, scheduleAndExecute, skipClean);
        return new HoodieCompactor(jsc, compactionConfig);
    }

    private HoodieCompactor.Config buildCompactionConfig(String basePath, boolean runSchedule, String runningMode, boolean skipClean) {
        HoodieCompactor.Config config = new HoodieCompactor.Config();
        config.basePath = basePath;
        config.runSchedule = runSchedule;
        config.runningMode = runningMode;
        config.configs.add("hoodie.metadata.enable=false");
        config.skipClean = skipClean;
        config.configs.add(String.format("%s=%s", HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key(), 1));
        config.configs.add(String.format("%s=%s", HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), 1));
        return config;
    }
}

