/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.utilities.schema.KafkaOffsetPostProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestKafkaOffsetPostProcessor {
    private static final List<String> EXPECTED_FIELD_NAMES = Arrays.asList("existing_field", "_hoodie_kafka_source_offset", "_hoodie_kafka_source_partition", "_hoodie_kafka_source_timestamp", "_hoodie_kafka_source_key");

    TestKafkaOffsetPostProcessor() {
    }

    @ParameterizedTest
    @MethodSource(value={"cases"})
    void testProcessSchema(Schema inputSchema) {
        KafkaOffsetPostProcessor kafkaOffsetPostProcessor = new KafkaOffsetPostProcessor(null, null);
        Schema actual = kafkaOffsetPostProcessor.processSchema(inputSchema);
        List actualFieldNames = actual.getFields().stream().map(Schema.Field::name).collect(Collectors.toList());
        Assertions.assertEquals(EXPECTED_FIELD_NAMES, actualFieldNames);
    }

    private static Stream<Arguments> cases() {
        String offsetField = "{\"name\": \"_hoodie_kafka_source_offset\", \"type\": \"long\", \"doc\": \"offset column\", \"default\": 0}";
        String partitionField = "{\"name\": \"_hoodie_kafka_source_partition\", \"type\": \"int\", \"doc\": \"partition column\", \"default\": 0}";
        String timestampField = "{\"name\": \"_hoodie_kafka_source_timestamp\", \"type\": \"long\", \"doc\": \"timestamp column\", \"default\": 0}";
        String keyField = "{\"name\": \"_hoodie_kafka_source_key\", \"type\": [\"null\", \"string\"], \"doc\": \"kafka key column\", \"default\": null}";
        return Stream.of(Arguments.of((Object[])new Object[]{new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"example\", \"fields\": [{\"name\": \"existing_field\", \"type\": \"string\"}]}")}), Arguments.of((Object[])new Object[]{new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"example\", \"fields\": [{\"name\": \"existing_field\", \"type\": \"string\"}, " + offsetField + "]}")}), Arguments.of((Object[])new Object[]{new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"example\", \"fields\": [{\"name\": \"existing_field\", \"type\": \"string\"}, " + offsetField + ", " + partitionField + "]}")}), Arguments.of((Object[])new Object[]{new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"example\", \"fields\": [{\"name\": \"existing_field\", \"type\": \"string\"}, " + offsetField + ", " + partitionField + ", " + timestampField + "]}")}), Arguments.of((Object[])new Object[]{new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"example\", \"fields\": [{\"name\": \"existing_field\", \"type\": \"string\"}, " + offsetField + ", " + partitionField + ", " + timestampField + ", " + keyField + "]}")}));
    }
}

