/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestSchemaRegistryProvider {
    private static final String BASIC_AUTH = "foo:bar";
    private static final String RAW_SCHEMA = "{\"type\": \"record\", \"namespace\": \"example\", \"name\": \"FullName\",\"fields\": [{ \"name\": \"first\", \"type\": \"string\" }]}";
    private static final String CONVERTED_SCHEMA = "{\"type\": \"record\", \"namespace\": \"com.example.hoodie\", \"name\": \"FullName\",\"fields\": [{ \"name\": \"first\", \"type\": \"string\" }]}";
    private final SchemaRegistryProvider.SchemaConverter mockSchemaConverter = (SchemaRegistryProvider.SchemaConverter)Mockito.mock(SchemaRegistryProvider.SchemaConverter.class);
    private final RestService mockRestService = (RestService)Mockito.mock(RestService.class);
    private final SchemaRegistryClient mockRegistryClient = (SchemaRegistryClient)Mockito.mock(SchemaRegistryClient.class);

    TestSchemaRegistryProvider() {
    }

    private static Schema getExpectedSchema() {
        return new Schema.Parser().parse(RAW_SCHEMA);
    }

    private static Schema getExpectedConvertedSchema() {
        return new Schema.Parser().parse(CONVERTED_SCHEMA);
    }

    private static TypedProperties getProps() {
        return new TypedProperties(){
            {
                this.put("hoodie.deltastreamer.schemaprovider.registry.baseUrl", "http://foo:bar@localhost");
                this.put("hoodie.deltastreamer.schemaprovider.registry.urlSuffix", "-value");
                this.put("hoodie.deltastreamer.schemaprovider.registry.url", "http://foo:bar@localhost/subjects/test/versions/latest");
                this.put("hoodie.deltastreamer.source.kafka.topic", "foo");
            }
        };
    }

    private SchemaRegistryProvider getUnderTest(TypedProperties props, int version, boolean useConverter) throws Exception {
        SerializableFunctionUnchecked mockRestServiceFactory = (SerializableFunctionUnchecked)Mockito.mock(SerializableFunctionUnchecked.class);
        Mockito.when((Object)mockRestServiceFactory.apply((Object)"http://localhost/")).thenReturn((Object)this.mockRestService);
        SerializableFunctionUnchecked mockRegistryClientFactory = (SerializableFunctionUnchecked)Mockito.mock(SerializableFunctionUnchecked.class);
        Mockito.when((Object)mockRegistryClientFactory.apply((Object)this.mockRestService)).thenReturn((Object)this.mockRegistryClient);
        SchemaRegistryProvider underTest = new SchemaRegistryProvider(props, null, useConverter ? Option.of((Object)this.mockSchemaConverter) : Option.empty(), mockRestServiceFactory, mockRegistryClientFactory);
        SchemaMetadata metadata = new SchemaMetadata(1, 1, RAW_SCHEMA);
        if (version == -1) {
            Mockito.when((Object)this.mockRegistryClient.getLatestSchemaMetadata("test")).thenReturn((Object)metadata);
        } else {
            Mockito.when((Object)this.mockRegistryClient.getSchemaMetadata("test", version)).thenReturn((Object)metadata);
        }
        ParsedSchema mockParsedSchema = (ParsedSchema)Mockito.mock(ParsedSchema.class);
        Mockito.when((Object)this.mockRegistryClient.parseSchema("AVRO", RAW_SCHEMA, Collections.emptyList())).thenReturn(Optional.of(mockParsedSchema));
        if (useConverter) {
            Mockito.when((Object)this.mockSchemaConverter.convert(mockParsedSchema)).thenReturn((Object)CONVERTED_SCHEMA);
        } else {
            Mockito.when((Object)mockParsedSchema.canonicalString()).thenReturn((Object)RAW_SCHEMA);
        }
        return underTest;
    }

    @Test
    public void testGetSourceSchemaShouldRequestSchemaWithCreds() throws Exception {
        SchemaRegistryProvider underTest = this.getUnderTest(TestSchemaRegistryProvider.getProps(), -1, true);
        Schema actual = underTest.getSourceSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService)).setHttpHeaders(Collections.singletonMap("Authorization", "Basic " + Base64.getEncoder().encodeToString(BASIC_AUTH.getBytes())));
    }

    @Test
    public void testGetTargetSchemaShouldRequestSchemaWithCreds() throws Exception {
        SchemaRegistryProvider underTest = this.getUnderTest(TestSchemaRegistryProvider.getProps(), -1, true);
        Schema actual = underTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService)).setHttpHeaders(Collections.singletonMap("Authorization", "Basic " + Base64.getEncoder().encodeToString(BASIC_AUTH.getBytes())));
    }

    @Test
    public void testGetSourceSchemaShouldRequestSchemaWithoutCreds() throws Exception {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.deltastreamer.schemaprovider.registry.url", (Object)"http://localhost/subjects/test/versions/latest");
        SchemaRegistryProvider underTest = this.getUnderTest(props, -1, true);
        Schema actual = underTest.getSourceSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService, (VerificationMode)Mockito.never())).setHttpHeaders((Map)ArgumentMatchers.any());
    }

    @Test
    public void testGetTargetSchemaShouldRequestSchemaWithoutCreds() throws Exception {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.deltastreamer.schemaprovider.registry.url", (Object)"http://localhost/subjects/test/versions/latest");
        SchemaRegistryProvider underTest = this.getUnderTest(props, -1, true);
        Schema actual = underTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedConvertedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService, (VerificationMode)Mockito.never())).setHttpHeaders((Map)ArgumentMatchers.any());
    }

    @Test
    public void testGetTargetSchemaWithoutConverter() throws Exception {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.deltastreamer.schemaprovider.registry.url", (Object)"http://localhost/subjects/test/versions/latest");
        SchemaRegistryProvider underTest = this.getUnderTest(props, -1, false);
        Schema actual = underTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService, (VerificationMode)Mockito.never())).setHttpHeaders((Map)ArgumentMatchers.any());
    }

    @Test
    public void testUrlWithSpecificSchemaVerson() throws Exception {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        props.put((Object)"hoodie.deltastreamer.schemaprovider.registry.url", (Object)"http://localhost/subjects/test/versions/3");
        SchemaRegistryProvider underTest = this.getUnderTest(props, 3, false);
        Schema actual = underTest.getTargetSchema();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)TestSchemaRegistryProvider.getExpectedSchema(), (Object)actual);
        ((RestService)Mockito.verify((Object)this.mockRestService, (VerificationMode)Mockito.never())).setHttpHeaders((Map)ArgumentMatchers.any());
    }

    @Test
    public void testFallbackWhenIllegalAccessErrorThrown() throws Exception {
        TypedProperties props = TestSchemaRegistryProvider.getProps();
        SchemaRegistryProvider provider = this.getUnderTest(props, -1, false);
        ParsedSchema failingParsedSchema = (ParsedSchema)Mockito.mock(ParsedSchema.class);
        Mockito.when((Object)failingParsedSchema.canonicalString()).thenThrow(new Throwable[]{new IllegalAccessError("tried to access field org.apache.avro.Schema.FACTORY from class org.apache.avro.Schemas")});
        Mockito.when((Object)this.mockRegistryClient.parseSchema("AVRO", RAW_SCHEMA, Collections.emptyList())).thenReturn(Optional.of(failingParsedSchema));
        SchemaRegistryProvider spyProvider = (SchemaRegistryProvider)Mockito.spy((Object)provider);
        String FALLBACK_SCHEMA = "{\"type\": \"record\", \"namespace\": \"example.fallback\", \"name\": \"Fallback\", \"fields\": []}";
        ((SchemaRegistryProvider)Mockito.doReturn((Object)"{\"type\": \"record\", \"namespace\": \"example.fallback\", \"name\": \"Fallback\", \"fields\": []}").when((Object)spyProvider)).fetchSchemaUsingLegacyMethod(ArgumentMatchers.anyString());
        Schema schema = spyProvider.getSourceSchema();
        Assertions.assertEquals((Object)new Schema.Parser().parse("{\"type\": \"record\", \"namespace\": \"example.fallback\", \"name\": \"Fallback\", \"fields\": []}"), (Object)schema);
    }
}

