/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.utilities.schema.converter.JsonToAvroSchemaConverter;
import org.apache.hudi.utilities.schema.converter.JsonToAvroSchemaConverterConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class TestJsonToAvroSchemaConverter {
    TestJsonToAvroSchemaConverter() {
    }

    @ParameterizedTest
    @CsvSource(value={"enum-properties,", "example-address,", "example-calendar,", "example-card,", "example-geographical-location,", "multiple-properties,", "nested-properties,", "single-properties,", "schema-repeating-names,", "complex-json-union-types,", "not-null-default-value-schema,_no_stripping_quotes", "not-null-default-value-schema,_stripping_quotes", "array-with-item-type-union,", "kafka-decimal-simple,"})
    void testConvertJsonSchemaToAvroSchema(String inputCase, String avroSchemaFileSuffix) throws IOException {
        String jsonSchema = this.loadJsonSchema(inputCase);
        TypedProperties config = new TypedProperties();
        if ("_no_stripping_quotes".equals(avroSchemaFileSuffix)) {
            config.put((Object)JsonToAvroSchemaConverterConfig.STRIP_DEFAULT_VALUE_QUOTES.key(), (Object)"false");
        }
        String avroSchema = new JsonToAvroSchemaConverter(config).convert((ParsedSchema)new JsonSchema(jsonSchema));
        Schema schema = new Schema.Parser().parse(avroSchema);
        Schema expected = new Schema.Parser().parse(this.loadAvroSchema(inputCase, avroSchemaFileSuffix));
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void testStripQuotesFromStringValue() {
        Assertions.assertNull((Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue(null));
        Assertions.assertEquals((Object)"", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)""));
        Assertions.assertEquals((Object)"\"", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"\""));
        Assertions.assertEquals((Object)"", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"\"\""));
        Assertions.assertEquals((Object)"\"", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"\"\"\""));
        Assertions.assertEquals((Object)"123", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"123"));
        Assertions.assertEquals((Object)"123", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"\"123\""));
        Assertions.assertEquals((Object)"x", (Object)JsonToAvroSchemaConverter.stripQuotesFromStringValue((String)"x"));
    }

    private String loadJsonSchema(String inputCase) throws IOException {
        return FileIOUtils.readAsUTFString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format("schema-provider/json/%s/input.json", inputCase)));
    }

    private String loadAvroSchema(String inputCase, String avroSchemaFileSuffix) throws IOException {
        return FileIOUtils.readAsUTFString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format("schema-provider/json/%s/expected%s.json", inputCase, avroSchemaFileSuffix == null ? "" : avroSchemaFileSuffix)));
    }
}

