/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.config.ProtoClassBasedSchemaProviderConfig;
import org.apache.hudi.utilities.schema.converter.ProtoSchemaToAvroSchemaConverter;
import org.apache.hudi.utilities.test.proto.Parent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestProtoSchemaToAvroSchemaConverter {
    TestProtoSchemaToAvroSchemaConverter() {
    }

    @Test
    void testConvert() throws Exception {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME.key(), Parent.class.getName());
        Schema.Parser parser = new Schema.Parser();
        ProtobufSchema protobufSchema = new ProtobufSchema(this.getProtoSchemaString());
        String actual = new ProtoSchemaToAvroSchemaConverter(properties).convert((ParsedSchema)protobufSchema);
        Schema actualSchema = new Schema.Parser().parse(actual);
        Schema expectedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/parent_schema_recursive_default_limit.avsc"));
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }

    private String getProtoSchemaString() throws IOException, URISyntaxException {
        return new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("schema-provider/proto/recursive.proto").toURI())));
    }
}

