/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.function.BiFunction;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.checkpoint.UnresolvedStreamerCheckpointBasedOnCfg;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;

public class CheckpointValidator {
    public static final String VAL_INPUT_CKP = "valInputCkp";
    public static final String VAL_CKP_INSTANCE_OF = "VAL_CKP_INSTANCE_OF_KEY";
    public static final String VAL_CKP_KEY_EQ_VAL = "VAL_CKP_KEY_EQ_VAL_KEY";
    public static final String VAL_CKP_RESET_KEY_EQUALS = "VAL_CKP_RESET_KEY";
    public static final String VAL_CKP_RESET_KEY_IS_NULL = "VAL_CKP_RESET_KEY_IS_NULL";
    public static final String VAL_CKP_IGNORE_KEY_EQUALS = "VAL_CKP_IGNORE_KEY";
    public static final String VAL_CKP_IGNORE_KEY_IS_NULL = "VAL_CKP_IGNORE_KEY_IS_NULL";
    public static final String VAL_NON_EMPTY_CKP_ALL_MEMBERS = "VAL_NON_EMPTY_CKP_ALL_MEMBERS";
    public static final String VAL_EMPTY_CKP_KEY = "VAL_EMPTY_CKP_KEY";
    public static final String VAL_NO_INGESTION_HAPPENS = "VAL_NO_INGESTION_HAPPENS_KEY";
    public static final String VAL_NO_OP = "VAL_NO_OP";
    private static final BiFunction<Option<Checkpoint>, TypedProperties, Void> VAL_NON_EMPTY_CKP_WITH_FIXED_VALUE = (ckpOpt, props) -> {
        Assertions.assertFalse((boolean)ckpOpt.isEmpty());
        Checkpoint ckp = (Checkpoint)ckpOpt.get();
        CheckpointValidator.assertCheckpointIsInstanceOf(props, ckp);
        CheckpointValidator.assertCheckpointValueEqualsTo(props, ckp);
        return null;
    };
    private static final BiFunction<Option<Checkpoint>, TypedProperties, Void> VAL_EMPTY_CKP = (ckpOpt, props) -> {
        Assertions.assertTrue((boolean)ckpOpt.isEmpty());
        return null;
    };

    private static void assertCheckpointValueEqualsTo(TypedProperties props, Checkpoint ckp) {
        if (props.containsKey((Object)VAL_CKP_KEY_EQ_VAL)) {
            Assertions.assertEquals((Object)props.getString(VAL_CKP_KEY_EQ_VAL), (Object)ckp.getCheckpointKey());
        }
        if (props.containsKey((Object)VAL_CKP_RESET_KEY_EQUALS)) {
            Assertions.assertEquals((Object)ckp.getCheckpointResetKey(), (Object)props.getString(VAL_CKP_RESET_KEY_EQUALS));
        }
        if (props.containsKey((Object)VAL_CKP_RESET_KEY_IS_NULL)) {
            Assertions.assertNull((Object)ckp.getCheckpointResetKey());
        }
        if (props.containsKey((Object)VAL_CKP_IGNORE_KEY_EQUALS)) {
            Assertions.assertEquals((Object)ckp.getCheckpointIgnoreKey(), (Object)props.getString(VAL_CKP_IGNORE_KEY_EQUALS));
        }
        if (props.containsKey((Object)VAL_CKP_IGNORE_KEY_IS_NULL)) {
            Assertions.assertNull((Object)ckp.getCheckpointIgnoreKey());
        }
    }

    private static void assertCheckpointIsInstanceOf(TypedProperties props, Checkpoint ckp) {
        if (props.containsKey((Object)VAL_CKP_INSTANCE_OF)) {
            switch ((String)props.get((Object)VAL_CKP_INSTANCE_OF)) {
                case "org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1": {
                    Assertions.assertInstanceOf(StreamerCheckpointV1.class, (Object)ckp);
                    break;
                }
                case "org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2": {
                    Assertions.assertInstanceOf(StreamerCheckpointV2.class, (Object)ckp);
                    break;
                }
                case "org.apache.hudi.common.table.checkpoint.StreamerCheckpointFromCfgCkp": {
                    Assertions.assertInstanceOf(UnresolvedStreamerCheckpointBasedOnCfg.class, (Object)ckp);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown checkpoint class to validate " + props.get((Object)VAL_CKP_INSTANCE_OF));
                }
            }
        }
    }

    public static void validateCheckpointOption(Option<Checkpoint> lastCheckpoint, TypedProperties props) {
        String valType;
        switch (valType = props.getString(VAL_INPUT_CKP, VAL_NO_OP)) {
            case "VAL_NO_OP": {
                break;
            }
            case "VAL_NON_EMPTY_CKP_ALL_MEMBERS": {
                VAL_NON_EMPTY_CKP_WITH_FIXED_VALUE.apply(lastCheckpoint, props);
                break;
            }
            case "VAL_EMPTY_CKP_KEY": {
                VAL_EMPTY_CKP.apply(lastCheckpoint, props);
                break;
            }
            case "VAL_NO_INGESTION_HAPPENS_KEY": {
                throw new IllegalStateException(String.format("Expected no ingestion happening but the source is asked to resume from checkpoint %s with props %s", lastCheckpoint, props));
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation type: " + valType);
            }
        }
    }
}

