/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DummyOperationExecutor {
    public static final String OP_FETCH_NEXT_BATCH = "mockTestFetchNextBatchOp";
    public static final String OP_EMPTY_ROW_SET_NONE_NULL_CKP_V1_KEY = "OP_EMPTY_ROW_SET_NONE_NULL_CKP_V1_KEY";
    public static final String OP_EMPTY_ROW_SET_NONE_NULL_CKP_V2_KEY = "OP_EMPTY_ROW_SET_NONE_NULL_CKP_V2_KEY";
    public static final String OP_EMPTY_ROW_SET_NULL_CKP_KEY = "OP_EMPTY_ROW_SET_NULL_CKP";
    public static final String CUSTOM_CHECKPOINT1 = "custom-checkpoint1";
    public static final String RETURN_CHECKPOINT_KEY = "RETURN_CHECKPOINT_KEY";
    private static final OperationFunction EMPTY_ROW_SET_NONE_NULL_CKP_V1 = (checkpoint, limit, props) -> {
        Option empty = Option.empty();
        String returnCheckpoint = props.getString(RETURN_CHECKPOINT_KEY, CUSTOM_CHECKPOINT1);
        return Pair.of((Object)empty, (Object)new StreamerCheckpointV1(returnCheckpoint));
    };
    private static final OperationFunction EMPTY_ROW_SET_NULL_CKP = (checkpoint, limit, props) -> {
        Option empty = Option.empty();
        return Pair.of((Object)empty, null);
    };
    private static final OperationFunction EMPTY_ROW_SET_NONE_NULL_CKP_V2 = (checkpoint, limit, props) -> {
        Option empty = Option.empty();
        String returnCheckpoint = props.getString(RETURN_CHECKPOINT_KEY, CUSTOM_CHECKPOINT1);
        return Pair.of((Object)empty, (Object)new StreamerCheckpointV2(returnCheckpoint));
    };

    public static Pair<Option<Dataset<Row>>, Checkpoint> executeDummyOperation(Option<Checkpoint> lastCheckpoint, long sourceLimit, TypedProperties props) {
        String opType;
        switch (opType = props.getString(OP_FETCH_NEXT_BATCH, OP_EMPTY_ROW_SET_NONE_NULL_CKP_V1_KEY)) {
            case "OP_EMPTY_ROW_SET_NONE_NULL_CKP_V1_KEY": {
                return EMPTY_ROW_SET_NONE_NULL_CKP_V1.apply(lastCheckpoint, sourceLimit, props);
            }
            case "OP_EMPTY_ROW_SET_NONE_NULL_CKP_V2_KEY": {
                return EMPTY_ROW_SET_NONE_NULL_CKP_V2.apply(lastCheckpoint, sourceLimit, props);
            }
            case "OP_EMPTY_ROW_SET_NULL_CKP": {
                return EMPTY_ROW_SET_NULL_CKP.apply(lastCheckpoint, sourceLimit, props);
            }
        }
        throw new IllegalArgumentException("Unsupported operation type: " + opType);
    }

    @FunctionalInterface
    private static interface OperationFunction {
        public Pair<Option<Dataset<Row>>, Checkpoint> apply(Option<Checkpoint> var1, Long var2, TypedProperties var3);
    }
}

