/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

public class TestGenericRddTransform
extends SparkClientFunctionalTestHarness {
    @Test
    public void testGenericRddTransform() {
        Dataset ds = this.spark().range(10L).withColumn("null_check_col", functions.when((Column)functions.expr((String)"id % 2 == 0"), (Object)functions.lit((Object)"test")).otherwise((Object)functions.lit(null)));
        StructType structType = new StructType(new StructField[]{new StructField("id", DataTypes.StringType, false, Metadata.empty()), new StructField("null_check_col", DataTypes.StringType, false, Metadata.empty())});
        Schema nonNullSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)structType, (String)"record", (String)"record");
        Tuple2 failSafeRdds = HoodieSparkUtils.safeCreateRDD((Dataset)ds, (String)"record", (String)"record", (boolean)false, (Option)Option.of((Object)nonNullSchema));
        Assertions.assertEquals((long)5L, (long)((RDD)failSafeRdds._1).count());
        Assertions.assertEquals((long)5L, (long)((RDD)failSafeRdds._2).count());
    }

    @Test
    public void testGenericRddConvert() {
        String fieldToNull = "partition_path";
        String schemaStr = HoodieAvroUtils.makeFieldNonNull((Schema)HoodieTestDataGenerator.AVRO_SCHEMA, (String)fieldToNull, (Object)"").toString();
        HoodieTestDataGenerator datagen = new HoodieTestDataGenerator();
        List recs = datagen.generateGenericRecords(10);
        for (int i = 0; i < recs.size(); ++i) {
            if (i % 2 != 0) continue;
            ((GenericRecord)recs.get(i)).put(fieldToNull, null);
        }
        JavaSparkContext jsc = this.jsc();
        RDD rdd = jsc.parallelize(recs).rdd();
        Tuple2 failSafeRdds = HoodieSparkUtils.safeRewriteRDD((RDD)rdd, (String)schemaStr);
        Assertions.assertEquals((long)5L, (long)((RDD)failSafeRdds._1).count());
        Assertions.assertEquals((long)5L, (long)((RDD)failSafeRdds._2).count());
        failSafeRdds = HoodieSparkUtils.safeRewriteRDD((RDD)rdd, (String)HoodieTestDataGenerator.AVRO_SCHEMA.toString());
        Assertions.assertEquals((long)10L, (long)((RDD)failSafeRdds._1).count());
        Assertions.assertEquals((long)0L, (long)((RDD)failSafeRdds._2).count());
    }
}

