/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.utilities.config.S3SourceConfig;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelector;
import org.apache.hudi.utilities.testutils.CloudObjectTestUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.Message;

public class TestCloudObjectsSelector
extends HoodieSparkClientTestHarness {
    static final String REGION_NAME = "us-east-1";
    TypedProperties props;
    String sqsUrl;
    @Mock
    SqsClient sqs;
    @Mock
    private CloudObjectsSelector cloudObjectsSelector;

    @BeforeEach
    void setUp() {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.props = new TypedProperties();
        this.sqsUrl = "test-queue";
        this.props.setProperty(S3SourceConfig.S3_SOURCE_QUEUE_URL.key(), this.sqsUrl);
        this.props.setProperty(S3SourceConfig.S3_SOURCE_QUEUE_REGION.key(), REGION_NAME);
    }

    @AfterEach
    public void teardown() throws Exception {
        Mockito.reset((Object[])new CloudObjectsSelector[]{this.cloudObjectsSelector});
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testSqsQueueAttributesShouldReturnsRequiredAttribute(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        CloudObjectTestUtils.setMessagesInQueue(this.sqs, null);
        Map queueAttributes = selector.getSqsQueueAttributes(this.sqs, this.sqsUrl);
        Assertions.assertEquals((int)1, (int)queueAttributes.size());
        Assertions.assertEquals((Object)"0", queueAttributes.get("ApproximateNumberOfMessages"));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testFileAttributesFromRecordShouldReturnsExpectOutput(Class<?> clazz) throws IOException {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        String bucket = "test-bucket";
        String key = "test/year=test1/month=test2/day=test3/part-foo-bar.snappy.parquet";
        String s3Records = "{\n  \"Type\" : \"Notification\",\n  \"MessageId\" : \"1\",\n  \"TopicArn\" : \"arn:aws:sns:foo:123:foo-bar\",\n  \"Subject\" : \"Amazon S3 Notification\",\n  \"Message\" : \"{\\\"Records\\\":[{\\\"eventVersion\\\":\\\"2.1\\\",\\\"eventSource\\\":\\\"aws:s3\\\",\\\"awsRegion\\\":\\\"us-west-2\\\",\\\"eventTime\\\":\\\"2021-07-27T09:05:36.755Z\\\",\\\"eventName\\\":\\\"ObjectCreated:Copy\\\",\\\"userIdentity\\\":{\\\"principalId\\\":\\\"AWS:test\\\"},\\\"requestParameters\\\":{\\\"sourceIPAddress\\\":\\\"0.0.0.0\\\"},\\\"responseElements\\\":{\\\"x-amz-request-id\\\":\\\"test\\\",\\\"x-amz-id-2\\\":\\\"foobar\\\"},\\\"s3\\\":{\\\"s3SchemaVersion\\\":\\\"1.0\\\",\\\"configurationId\\\":\\\"foobar\\\",\\\"bucket\\\":{\\\"name\\\":\\\"" + bucket + "\\\",\\\"ownerIdentity\\\":{\\\"principalId\\\":\\\"foo\\\"},\\\"arn\\\":\\\"arn:aws:s3:::foo\\\"},\\\"object\\\":{\\\"key\\\":\\\"" + key + "\\\",\\\"size\\\":123,\\\"eTag\\\":\\\"test\\\",\\\"sequencer\\\":\\\"1\\\"}}}]}\"}";
        JSONObject messageBody = new JSONObject(s3Records);
        Map messageMap = new HashMap();
        if (messageBody.has("Message")) {
            ObjectMapper mapper = new ObjectMapper();
            messageMap = (Map)mapper.readValue(messageBody.getString("Message"), Map.class);
        }
        List records = (List)messageMap.get("Records");
        Map fileAttributes = selector.getFileAttributesFromRecord(new JSONObject((Map)records.get(0)));
        Assertions.assertEquals((int)3, (int)fileAttributes.size());
        Assertions.assertEquals((long)123L, (long)((Long)fileAttributes.get("fileSize")));
        Assertions.assertEquals((Object)("s3://" + bucket + "/" + key), fileAttributes.get("filePath"));
        Assertions.assertEquals((long)1627376736755L, (long)((Long)fileAttributes.get("eventTime")));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testCreateListPartitionsReturnsExpectedSetOfBatch(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Object> testSingleList = new ArrayList<Object>();
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "1")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "2")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "3")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "4")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "5")).build());
        ArrayList<Object> expectedFirstList = new ArrayList<Object>();
        expectedFirstList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "1")).build());
        expectedFirstList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "2")).build());
        ArrayList<Object> expectedSecondList = new ArrayList<Object>();
        expectedSecondList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "3")).build());
        expectedSecondList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "4")).build());
        ArrayList<Object> expectedFinalList = new ArrayList<Object>();
        expectedFinalList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "5")).build());
        List partitionedList = selector.createListPartitions(testSingleList, 2);
        Assertions.assertEquals((int)3, (int)partitionedList.size());
        Assertions.assertEquals(expectedFirstList, partitionedList.get(0));
        Assertions.assertEquals(expectedSecondList, partitionedList.get(1));
        Assertions.assertEquals(expectedFinalList, partitionedList.get(2));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testCreateListPartitionsReturnsEmptyIfBatchSizeIsZero(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Object> testSingleList = new ArrayList<Object>();
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "1")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("id", "2")).build());
        List partitionedList = selector.createListPartitions(testSingleList, 0);
        Assertions.assertEquals((int)0, (int)partitionedList.size());
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testOnCommitDeleteProcessedMessages(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Object> testSingleList = new ArrayList<Object>();
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("MessageId", "1")).attributesWithStrings(this.createAttributeMap("ReceiptHandle", "1")).build());
        testSingleList.add(Message.builder().attributesWithStrings(this.createAttributeMap("MessageId", "2")).attributesWithStrings(this.createAttributeMap("ReceiptHandle", "1")).build());
        CloudObjectTestUtils.deleteMessagesInQueue(this.sqs);
        selector.deleteProcessedMessages(this.sqs, this.sqsUrl, testSingleList);
    }

    public Map<String, String> createAttributeMap(String key, String value) {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put(key, value);
        return attribute;
    }
}

