/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.utilities.config.DFSPathSelectorConfig;
import org.apache.hudi.utilities.config.DatePartitionPathSelectorConfig;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.hudi.utilities.sources.helpers.DatePartitionPathSelector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestDFSPathSelectorCommonMethods
extends HoodieSparkClientTestHarness {
    TypedProperties props;
    Path inputPath;

    @BeforeEach
    void setUp() {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.props = new TypedProperties();
        this.props.setProperty(DFSPathSelectorConfig.ROOT_INPUT_PATH.key(), this.basePath);
        this.props.setProperty(DatePartitionPathSelectorConfig.PARTITIONS_LIST_PARALLELISM.key(), "1");
        this.inputPath = new Path(this.basePath);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(classes={DFSPathSelector.class, DatePartitionPathSelector.class})
    public void listEligibleFilesShouldIgnoreCertainPrefixes(Class<?> clazz) throws Exception {
        DFSPathSelector selector = (DFSPathSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props, this.storageConf.unwrap()});
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo1", (long)1L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)".foo2", (long)1L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"_foo3", (long)1L);
        List eligibleFiles = selector.listEligibleFiles((FileSystem)this.storage.getFileSystem(), this.inputPath, 0L);
        Assertions.assertEquals((int)1, (int)eligibleFiles.size());
        Assertions.assertTrue((boolean)((FileStatus)eligibleFiles.get(0)).getPath().getName().startsWith("foo1"));
    }

    @ParameterizedTest
    @ValueSource(classes={DFSPathSelector.class, DatePartitionPathSelector.class})
    public void listEligibleFilesShouldIgnore0LengthFiles(Class<?> clazz) throws Exception {
        DFSPathSelector selector = (DFSPathSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props, this.storageConf.unwrap()});
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo1", (long)1L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo2", (long)0L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo3", (long)0L);
        List eligibleFiles = selector.listEligibleFiles((FileSystem)this.storage.getFileSystem(), this.inputPath, 0L);
        Assertions.assertEquals((int)1, (int)eligibleFiles.size());
        Assertions.assertTrue((boolean)((FileStatus)eligibleFiles.get(0)).getPath().getName().startsWith("foo1"));
    }

    @ParameterizedTest
    @ValueSource(classes={DFSPathSelector.class, DatePartitionPathSelector.class})
    public void listEligibleFilesShouldIgnoreFilesEarlierThanCheckpointTime(Class<?> clazz) throws Exception {
        DFSPathSelector selector = (DFSPathSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props, this.storageConf.unwrap()});
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo1", (long)1L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo2", (long)1L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo3", (long)1L);
        List eligibleFiles = selector.listEligibleFiles((FileSystem)this.storage.getFileSystem(), this.inputPath, Long.MAX_VALUE);
        Assertions.assertEquals((int)0, (int)eligibleFiles.size());
    }

    @ParameterizedTest
    @ValueSource(classes={DFSPathSelector.class, DatePartitionPathSelector.class})
    public void getNextFilePathsAndMaxModificationTimeShouldRespectSourceLimit(Class<?> clazz) throws Exception {
        DFSPathSelector selector = (DFSPathSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props, this.storageConf.unwrap()});
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo1", (long)10L, (long)1000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo2", (long)10L, (long)2000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo3", (long)10L, (long)3000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo4", (long)10L, (long)4000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo5", (long)10L, (long)5000L);
        Pair nextFilePathsAndCheckpoint = selector.getNextFilePathsAndMaxModificationTime(this.jsc, Option.empty(), 30L);
        List fileNames = Arrays.stream(((String)((Option)nextFilePathsAndCheckpoint.getLeft()).get()).split(",")).map(p -> Paths.get(p, new String[0]).toFile().getName()).sorted().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)fileNames.size());
        Assertions.assertTrue((boolean)((String)fileNames.get(0)).startsWith("foo1"));
        Assertions.assertTrue((boolean)((String)fileNames.get(1)).startsWith("foo2"));
        String checkpointStr1stRead = ((Checkpoint)nextFilePathsAndCheckpoint.getRight()).getCheckpointKey();
        Assertions.assertEquals((long)2000L, (long)Long.parseLong(checkpointStr1stRead), (String)"should read up to foo2 (inclusive)");
    }

    @ParameterizedTest
    @ValueSource(classes={DFSPathSelector.class, DatePartitionPathSelector.class})
    public void getNextFilePathsAndMaxModificationTimeShouldIgnoreSourceLimitIfSameModTimeFilesPresent(Class<?> clazz) throws Exception {
        DFSPathSelector selector = (DFSPathSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props, this.storageConf.unwrap()});
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo1", (long)10L, (long)1000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo2", (long)10L, (long)1000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo3", (long)10L, (long)1000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo4", (long)10L, (long)2000L);
        FileCreateUtilsLegacy.createBaseFile((String)this.basePath, (String)"p1", (String)"000", (String)"foo5", (long)10L, (long)2000L);
        Pair nextFilePathsAndCheckpoint = selector.getNextFilePathsAndMaxModificationTime(this.jsc, Option.empty(), 20L);
        List fileNames1stRead = Arrays.stream(((String)((Option)nextFilePathsAndCheckpoint.getLeft()).get()).split(",")).map(p -> Paths.get(p, new String[0]).toFile().getName()).sorted().collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)fileNames1stRead.size());
        Assertions.assertTrue((boolean)((String)fileNames1stRead.get(0)).startsWith("foo1"));
        Assertions.assertTrue((boolean)((String)fileNames1stRead.get(1)).startsWith("foo2"));
        Assertions.assertTrue((boolean)((String)fileNames1stRead.get(2)).startsWith("foo3"));
        String checkpointStr1stRead = ((Checkpoint)nextFilePathsAndCheckpoint.getRight()).getCheckpointKey();
        Assertions.assertEquals((long)1000L, (long)Long.parseLong(checkpointStr1stRead), (String)"should read up to foo3 (inclusive)");
        nextFilePathsAndCheckpoint = selector.getNextFilePathsAndMaxModificationTime(this.jsc, Option.of((Object)new StreamerCheckpointV2(checkpointStr1stRead)), 20L);
        List fileNames2ndRead = Arrays.stream(((String)((Option)nextFilePathsAndCheckpoint.getLeft()).get()).split(",")).map(p -> Paths.get(p, new String[0]).toFile().getName()).sorted().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)fileNames2ndRead.size());
        Assertions.assertTrue((boolean)((String)fileNames2ndRead.get(0)).startsWith("foo4"));
        Assertions.assertTrue((boolean)((String)fileNames2ndRead.get(1)).startsWith("foo5"));
        String checkpointStr2ndRead = ((Checkpoint)nextFilePathsAndCheckpoint.getRight()).getCheckpointKey();
        Assertions.assertEquals((long)2000L, (long)Long.parseLong(checkpointStr2ndRead), (String)"should read up to foo5 (inclusive)");
    }
}

