/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.crypto.tink.subtle.Base64;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.hudi.utilities.exception.HoodieReadFromSourceException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.helpers.KafkaSourceUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestKafkaSourceUtil {
    @Mock
    SchemaProvider schemaProvider;

    @Test
    void testConfigureSchemaDeserializer() {
        TypedProperties props = new TypedProperties();
        Assertions.assertThrows(HoodieReadFromSourceException.class, () -> KafkaSourceUtil.configureSchemaDeserializer((SchemaProvider)this.schemaProvider, (TypedProperties)props));
        String avroSchemaJson = "{\"type\":\"record\",\"name\":\"Person\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"age\",\"type\":\"int\"},{\"name\":\"email\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"isEmployed\",\"type\":\"boolean\"}]}";
        Schema schema = new Schema.Parser().parse(avroSchemaJson);
        Mockito.when((Object)this.schemaProvider.getSourceSchema()).thenReturn((Object)schema);
        KafkaSourceUtil.configureSchemaDeserializer((SchemaProvider)this.schemaProvider, (TypedProperties)props);
        Assertions.assertTrue((boolean)props.containsKey((Object)"group.id"));
        Assertions.assertTrue((props.getString("group.id", "").length() <= 255 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)props.getString(KafkaSourceConfig.KAFKA_VALUE_DESERIALIZER_SCHEMA.key()), (Object)avroSchemaJson);
        String schemaHash = Base64.encode((byte[])HashID.hash((String)avroSchemaJson, (HashID.Size)HashID.Size.BITS_128));
        Assertions.assertEquals((Object)props.getString("group.id", ""), (Object)schemaHash);
    }
}

