/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.utilities.config.S3SourceConfig;
import org.apache.hudi.utilities.sources.helpers.S3EventsMetaSelector;
import org.apache.hudi.utilities.testutils.CloudObjectTestUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;

public class TestS3EventsMetaSelector
extends HoodieSparkClientTestHarness {
    TypedProperties props;
    String sqsUrl;
    @Mock
    SqsClient sqs;
    @Mock
    private S3EventsMetaSelector s3EventsMetaSelector;

    @BeforeEach
    void setUp() {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.props = new TypedProperties();
        this.sqsUrl = "test-queue";
        this.props.setProperty(S3SourceConfig.S3_SOURCE_QUEUE_URL.key(), this.sqsUrl);
        this.props.setProperty(S3SourceConfig.S3_SOURCE_QUEUE_REGION.key(), "us-east-1");
    }

    @AfterEach
    public void teardown() throws Exception {
        Mockito.reset((Object[])new S3EventsMetaSelector[]{this.s3EventsMetaSelector});
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(classes={S3EventsMetaSelector.class})
    public void testNextEventsFromQueueShouldReturnsEventsFromQueue(Class<?> clazz) {
        S3EventsMetaSelector selector = (S3EventsMetaSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        String bucket = "test-bucket";
        String key = "part%3Dpart%2Bpart%24part%A3part%23part%26part%3Fpart%7Epart%25.snappy.parquet";
        String keyRes = "part=part+part$part\u00a3part#part&part?part~part%.snappy.parquet";
        Path path = new Path(bucket, key);
        CloudObjectTestUtils.setMessagesInQueue(this.sqs, path);
        ArrayList processed = new ArrayList();
        Pair eventFromQueue = selector.getNextEventsFromQueue(this.sqs, Option.empty(), processed);
        Assertions.assertEquals((int)1, (int)((List)eventFromQueue.getLeft()).size());
        Assertions.assertEquals((int)1, (int)processed.size());
        Assertions.assertEquals((Object)keyRes, (Object)new JSONObject((String)((List)eventFromQueue.getLeft()).get(0)).getJSONObject("s3").getJSONObject("object").getString("key"));
        Assertions.assertEquals((Object)"1627376736755", (Object)((Checkpoint)eventFromQueue.getRight()).getCheckpointKey());
    }

    @Test
    public void testEventsFromQueueNoMessages() {
        S3EventsMetaSelector selector = new S3EventsMetaSelector(this.props);
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("ApproximateNumberOfMessages", "0");
        Mockito.when((Object)this.sqs.getQueueAttributes((GetQueueAttributesRequest)ArgumentMatchers.any(GetQueueAttributesRequest.class))).thenReturn(GetQueueAttributesResponse.builder().attributesWithStrings(attribute).build());
        ArrayList processed = new ArrayList();
        Pair eventFromQueue = selector.getNextEventsFromQueue(this.sqs, Option.empty(), processed);
        Assertions.assertEquals((int)0, (int)((List)eventFromQueue.getLeft()).size());
        Assertions.assertEquals((int)0, (int)processed.size());
        Assertions.assertNull((Object)eventFromQueue.getRight());
    }
}

