/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.read.IncrementalQueryAnalyzer;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.utilities.sources.SnapshotLoadQuerySplitter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;

public class TestSnapshotQuerySplitterImpl
extends SnapshotLoadQuerySplitter {
    public static final String MAX_ROWS_PER_BATCH = "test.snapshot.load.max.row.count";

    public TestSnapshotQuerySplitterImpl(TypedProperties properties) {
        super(properties);
    }

    public Option<SnapshotLoadQuerySplitter.CheckpointWithPredicates> getNextCheckpointWithPredicates(Dataset<Row> df, IncrementalQueryAnalyzer.QueryContext queryContext) {
        int maxRowsPerBatch = this.properties.getInteger(MAX_ROWS_PER_BATCH, 1);
        List instantTimeList = queryContext.getInstantTimeList();
        Map<String, String> instantToCompletionTimeMap = queryContext.getInstants().stream().collect(Collectors.toMap(HoodieInstant::requestedTime, HoodieInstant::getCompletionTime));
        Map<String, Triple> completionTimeToStats = df.select(new Column[]{functions.col((String)HoodieRecord.COMMIT_TIME_METADATA_FIELD), functions.col((String)HoodieRecord.PARTITION_PATH_METADATA_FIELD)}).filter(functions.col((String)HoodieRecord.COMMIT_TIME_METADATA_FIELD).isin(instantTimeList.toArray())).groupBy(new Column[]{functions.col((String)HoodieRecord.COMMIT_TIME_METADATA_FIELD)}).agg(functions.count((String)HoodieRecord.COMMIT_TIME_METADATA_FIELD).alias("count"), new Column[]{functions.min((String)HoodieRecord.PARTITION_PATH_METADATA_FIELD).alias("min_partition_path"), functions.max((String)HoodieRecord.PARTITION_PATH_METADATA_FIELD).alias("max_partition_path")}).collectAsList().stream().collect(Collectors.toMap(row -> (String)instantToCompletionTimeMap.get(row.getString(0)), row -> Triple.of((Object)row.getLong(1), (Object)row.getString(2), (Object)row.getString(3))));
        if (!completionTimeToStats.isEmpty()) {
            List sortedCompletionTime = completionTimeToStats.keySet().stream().sorted().collect(Collectors.toList());
            long rowCount = 0L;
            String minPartitionPath = null;
            String maxPartitionPath = null;
            String endCompletionTime = queryContext.getMaxCompletionTime();
            for (String completionTime : sortedCompletionTime) {
                Triple stats = completionTimeToStats.get(completionTime);
                endCompletionTime = completionTime;
                rowCount += ((Long)stats.getLeft()).longValue();
                if (minPartitionPath == null || ((String)stats.getMiddle()).compareTo(minPartitionPath) < 0) {
                    minPartitionPath = (String)stats.getMiddle();
                }
                if (maxPartitionPath == null || ((String)stats.getRight()).compareTo(maxPartitionPath) > 0) {
                    maxPartitionPath = (String)stats.getRight();
                }
                if (rowCount < (long)maxRowsPerBatch) continue;
                break;
            }
            String partitionFilter = String.format("partition_path >= '%s' and partition_path <= '%s'", minPartitionPath, maxPartitionPath);
            return Option.of((Object)new SnapshotLoadQuerySplitter.CheckpointWithPredicates(endCompletionTime, partitionFilter));
        }
        return Option.empty();
    }
}

