/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.deltastreamer.TestHoodieDeltaStreamerSchemaEvolutionBase;
import org.apache.hudi.utilities.streamer.ErrorTableUtils;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestErrorTableUtils {
    @Test
    public void testGetErrorTableWriter() {
        SparkSession sparkSession = (SparkSession)Mockito.mock(SparkSession.class);
        HoodieSparkEngineContext sparkContext = (HoodieSparkEngineContext)Mockito.mock(HoodieSparkEngineContext.class);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        TypedProperties props = new TypedProperties();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ErrorTableUtils.getErrorTableWriter((HoodieStreamer.Config)new HoodieStreamer.Config(), (SparkSession)sparkSession, (TypedProperties)props, (HoodieSparkEngineContext)sparkContext, (FileSystem)fileSystem, (Option)Option.empty()));
        props.put((Object)"hoodie.errortable.write.class", (Object)"");
        Assertions.assertThrows(IllegalStateException.class, () -> ErrorTableUtils.getErrorTableWriter((HoodieStreamer.Config)new HoodieStreamer.Config(), (SparkSession)sparkSession, (TypedProperties)props, (HoodieSparkEngineContext)sparkContext, (FileSystem)fileSystem, (Option)Option.empty()));
        props.put((Object)"hoodie.errortable.write.class", (Object)TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTable.class.getName());
        Assertions.assertTrue((boolean)(ErrorTableUtils.getErrorTableWriter((HoodieStreamer.Config)new HoodieStreamer.Config(), (SparkSession)sparkSession, (TypedProperties)props, (HoodieSparkEngineContext)sparkContext, (FileSystem)fileSystem, (Option)Option.empty()).get() instanceof TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTable));
        props.put((Object)"hoodie.errortable.write.class", (Object)TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTableV1.class.getName());
        Assertions.assertTrue((boolean)(ErrorTableUtils.getErrorTableWriter((HoodieStreamer.Config)new HoodieStreamer.Config(), (SparkSession)sparkSession, (TypedProperties)props, (HoodieSparkEngineContext)sparkContext, (FileSystem)fileSystem, (Option)Option.empty()).get() instanceof TestHoodieDeltaStreamerSchemaEvolutionBase.TestErrorTableV1));
        props.put((Object)"hoodie.errortable.write.class", (Object)HoodieConfig.class.getName());
        Assertions.assertThrows(HoodieException.class, () -> ErrorTableUtils.getErrorTableWriter((HoodieStreamer.Config)new HoodieStreamer.Config(), (SparkSession)sparkSession, (TypedProperties)props, (HoodieSparkEngineContext)sparkContext, (FileSystem)fileSystem, (Option)Option.empty()));
    }
}

